/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.handler.GhostItemHandler;
import me.desht.modularrouters.item.module.ItemModule;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class BaseModuleHandler
extends GhostItemHandler {
    private final ItemStack holderStack;
    private final TileEntityItemRouter router;
    private final String tagName;

    public BaseModuleHandler(ItemStack holderStack, TileEntityItemRouter router, int size, String tagName) {
        super(size);
        this.holderStack = holderStack;
        this.router = router;
        this.tagName = tagName;
        this.deserializeNBT(holderStack.func_190925_c("modularrouters").func_74775_l(tagName));
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    protected void onContentsChanged(int slot) {
        this.save();
        if (this.router != null) {
            this.router.recompileNeeded(1);
        }
    }

    public static int getFilterSize(ItemStack holderStack, String tagName) {
        CompoundNBT tag = holderStack.func_179543_a("modularrouters");
        if (tag != null && tag.func_74764_b(tagName)) {
            ModuleFilterHandler handler = new ModuleFilterHandler(holderStack, null);
            int n = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    public void save() {
        this.holderStack.func_190925_c("modularrouters").func_218657_a(this.tagName, (INBT)this.serializeNBT());
    }

    public static class ModuleFilterHandler
    extends BaseModuleHandler {
        public ModuleFilterHandler(ItemStack holderStack, TileEntityItemRouter router) {
            super(holderStack, router, 9, "ModuleFilter");
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return ((ItemModule)this.getHolderStack().func_77973_b()).isItemValidForFilter(stack);
        }
    }

    public static class BulkFilterHandler
    extends BaseModuleHandler {
        public BulkFilterHandler(ItemStack holderStack, TileEntityItemRouter router) {
            super(holderStack, router, 54, "ModuleFilter");
        }
    }
}

