/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.logic.compiled.CompiledActivatorModule;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class GuiModuleActivator
extends GuiModule {
    private static final ItemStack ITEM_STACK = new ItemStack((IItemProvider)Items.field_151033_d);
    private static final ItemStack ENTITY_STACK = new ItemStack((IItemProvider)Items.field_196184_dx);
    private static final ItemStack ATTACK_STACK = new ItemStack((IItemProvider)Items.field_151040_l);
    private LookDirectionButton lookDirectionButton;
    private ActionTypeButton actionTypeButton;
    private EntityModeButton entityModeButton;
    private SneakButton sneakButton;

    public GuiModuleActivator(ContainerModule container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        CompiledActivatorModule cam = new CompiledActivatorModule(null, this.moduleItemStack);
        ItemStack[] stacks = new ItemStack[]{ITEM_STACK, ENTITY_STACK, ATTACK_STACK};
        this.actionTypeButton = new ActionTypeButton(this.field_147003_i + 167, this.field_147009_r + 20, 16, 16, true, stacks, cam.getActionType());
        this.func_230480_a_((Widget)this.actionTypeButton);
        this.sneakButton = new SneakButton(this.field_147003_i + 167, this.field_147009_r + 40, cam.isSneaking());
        this.func_230480_a_((Widget)this.sneakButton);
        this.lookDirectionButton = new LookDirectionButton(this.field_147003_i + 167, this.field_147009_r + 60, 16, 16, cam.getLookDirection());
        this.func_230480_a_((Widget)this.lookDirectionButton);
        this.entityModeButton = new EntityModeButton(this.field_147003_i + 167, this.field_147009_r + 60, 16, 16, cam.getEntityMode());
        this.func_230480_a_((Widget)this.entityModeButton);
        this.lookDirectionButton.field_230694_p_ = !cam.getActionType().isEntityTarget();
        this.entityModeButton.field_230694_p_ = cam.getActionType().isEntityTarget();
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 130, this.field_147009_r + 18, this.field_147003_i + 183, this.field_147009_r + 37, "modularrouters.guiText.popup.activator.action");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 130, this.field_147009_r + 39, this.field_147003_i + 183, this.field_147009_r + 56, "modularrouters.guiText.popup.activator.sneak");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 130, this.field_147009_r + 59, this.field_147003_i + 183, this.field_147009_r + 76, "modularrouters.guiText.popup.activator.look", guiContainer -> this.lookDirectionButton.field_230694_p_);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 130, this.field_147009_r + 59, this.field_147003_i + 183, this.field_147009_r + 76, "modularrouters.guiText.popup.activator.look", guiContainer -> this.entityModeButton.field_230694_p_);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.func_238474_b_(matrixStack, this.field_147003_i + 165, this.field_147009_r + 19, GuiModuleActivator.BUTTON_XY.x, GuiModuleActivator.BUTTON_XY.y, 18, 18);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"modularrouters.guiText.tooltip.activator.action", (Object[])new Object[0]), 132.0f, 23.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"modularrouters.guiText.tooltip.activator.sneak", (Object[])new Object[0]), 132.0f, 43.0f, 0x404040);
        if (((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).isEntityTarget()) {
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"modularrouters.guiText.tooltip.activator.entityMode", (Object[])new Object[0]), 132.0f, 63.0f, 0x404040);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"modularrouters.guiText.tooltip.activator.lookDirection", (Object[])new Object[0]), 132.0f, 63.0f, 0x404040);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.lookDirectionButton.field_230694_p_ = !((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).isEntityTarget();
        this.entityModeButton.field_230694_p_ = ((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).isEntityTarget();
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT compound = super.buildMessageData();
        compound.func_74768_a("ActionType2", ((CompiledActivatorModule.ActionType)this.actionTypeButton.getState()).ordinal());
        compound.func_74768_a("LookDirection", ((CompiledActivatorModule.LookDirection)this.lookDirectionButton.getState()).ordinal());
        compound.func_74768_a("EntityMode", ((CompiledActivatorModule.EntityMode)this.entityModeButton.getState()).ordinal());
        compound.func_74757_a("Sneaking", this.sneakButton.isToggled());
        return compound;
    }

    private class EntityModeButton
    extends TexturedCyclerButton<CompiledActivatorModule.EntityMode> {
        private final List<List<ITextComponent>> tooltips;

        EntityModeButton(int x, int y, int width, int height, CompiledActivatorModule.EntityMode initialVal) {
            super(x, y, width, height, initialVal, GuiModuleActivator.this);
            this.tooltips = Lists.newArrayList();
            for (CompiledActivatorModule.EntityMode mode : CompiledActivatorModule.EntityMode.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(mode.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            switch ((CompiledActivatorModule.EntityMode)this.getState()) {
                case RANDOM: {
                    return 176;
                }
                case NEAREST: {
                    return 192;
                }
                case ROUND_ROBIN: {
                    return 160;
                }
            }
            return 0;
        }

        @Override
        protected int getTextureY() {
            switch ((CompiledActivatorModule.EntityMode)this.getState()) {
                case RANDOM: 
                case ROUND_ROBIN: {
                    return 32;
                }
                case NEAREST: {
                    return 16;
                }
            }
            return 0;
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tooltips.get(((CompiledActivatorModule.EntityMode)this.getState()).ordinal());
        }
    }

    private class SneakButton
    extends TexturedToggleButton {
        SneakButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, GuiModuleActivator.this);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 192 : 112;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class LookDirectionButton
    extends TexturedCyclerButton<CompiledActivatorModule.LookDirection> {
        private final Map<CompiledActivatorModule.LookDirection, List<ITextComponent>> tooltips;

        LookDirectionButton(int x, int y, int width, int height, CompiledActivatorModule.LookDirection initialVal) {
            super(x, y, width, height, initialVal, GuiModuleActivator.this);
            this.tooltips = new EnumMap<CompiledActivatorModule.LookDirection, List<ITextComponent>>(CompiledActivatorModule.LookDirection.class);
            for (CompiledActivatorModule.LookDirection dir : CompiledActivatorModule.LookDirection.values()) {
                this.tooltips.put(dir, Collections.singletonList(ClientUtil.xlate(dir.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 144 + ((CompiledActivatorModule.LookDirection)this.getState()).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 0;
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tooltips.get(this.getState());
        }
    }

    private class ActionTypeButton
    extends ItemStackCyclerButton<CompiledActivatorModule.ActionType> {
        private final Map<CompiledActivatorModule.ActionType, List<ITextComponent>> tooltips;

        ActionTypeButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, CompiledActivatorModule.ActionType initialVal) {
            super(x, y, width, height, flat, stacks, initialVal, GuiModuleActivator.this);
            this.tooltips = new EnumMap<CompiledActivatorModule.ActionType, List<ITextComponent>>(CompiledActivatorModule.ActionType.class);
            for (CompiledActivatorModule.ActionType actionType : CompiledActivatorModule.ActionType.values()) {
                this.tooltips.put(actionType, Collections.singletonList(ClientUtil.xlate(actionType.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tooltips.get(this.getState());
        }
    }
}

