/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.widgets.GuiContainerBase;
import me.desht.modularrouters.client.gui.widgets.WidgetEnergy;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerItemRouter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;

public class GuiItemRouter
extends GuiContainerBase<ContainerItemRouter>
implements ISendToServer,
IHasContainer<ContainerItemRouter> {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/router.png");
    private static final int LABEL_YPOS = 5;
    private static final int MODULE_LABEL_YPOS = 60;
    private static final int BUFFER_LABEL_YPOS = 28;
    private static final int UPGRADES_LABEL_YPOS = 28;
    private static final int GUI_HEIGHT = 186;
    private static final int GUI_WIDTH = 176;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 16;
    private static final int MODULE_START = 37;
    private static final int MODULE_END = 45;
    private RedstoneBehaviourButton redstoneBehaviourButton;
    private EcoButton ecoButton;
    private EnergyDirectionButton energyDirButton;
    private WidgetEnergy energyWidget;
    private EnergyWarningButton energyWarning;
    private int energyUsage;

    public GuiItemRouter(ContainerItemRouter container, PlayerInventory inventoryPlayer, ITextComponent displayName) {
        super(container, inventoryPlayer, displayName);
        this.field_146999_f = 176;
        this.field_147000_g = 186;
        this.field_230711_n_ = true;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        TileEntityItemRouter router = ((ContainerItemRouter)this.field_147002_h).getRouter();
        this.redstoneBehaviourButton = new RedstoneBehaviourButton(this.field_147003_i + 152, this.field_147009_r + 10, 16, 16, router.getRedstoneBehaviour(), (ISendToServer)this);
        this.func_230480_a_((Widget)this.redstoneBehaviourButton);
        this.ecoButton = new EcoButton(this.field_147003_i + 132, this.field_147009_r + 10, 16, 16, router.getEcoMode());
        this.func_230480_a_((Widget)this.ecoButton);
        this.energyDirButton = new EnergyDirectionButton(this.field_147003_i - 8, this.field_147009_r + 40, router.getEnergyDirection());
        this.func_230480_a_((Widget)this.energyDirButton);
        this.energyWidget = new WidgetEnergy(this.field_147003_i - 22, this.field_147009_r + 15, router.getEnergyStorage());
        this.func_230480_a_(this.energyWidget);
        this.energyWarning = new EnergyWarningButton(this.field_147003_i + 4, this.field_147009_r + 4);
        this.func_230480_a_((Widget)this.energyWarning);
        this.energyDirButton.field_230694_p_ = router.getEnergyCapacity() > 0;
        this.energyWidget.field_230694_p_ = this.energyDirButton.field_230694_p_;
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        String title = I18n.func_135052_a((String)"block.modularrouters.item_router", (Object[])new Object[0]);
        this.field_230712_o_.func_238421_b_(matrixStack, title, (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_78256_a(title) / 2.0f, 5.0f, -12566464);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"modularrouters.guiText.label.buffer", (Object[])new Object[0]), 8.0f, 28.0f, -12566464);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"modularrouters.guiText.label.upgrades", (Object[])new Object[0]), 80.0f, 28.0f, -12566464);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"modularrouters.guiText.label.modules", (Object[])new Object[0]), 8.0f, 60.0f, -12566464);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 4), -12566464);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float v, int i, int i1) {
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_LOCATION);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((ContainerItemRouter)this.field_147002_h).getRouter().getEnergyCapacity() > 0) {
            this.func_238474_b_(matrixStack, this.field_147003_i - 27, this.field_147009_r, 180, 0, 32, 100);
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return ClientSetup.keybindConfigure.getKey().func_197937_c() == keyCode ? this.handleModuleConfig() : super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_231044_a_(double x, double y, int btn) {
        return btn == 2 ? this.handleModuleConfig() : super.func_231044_a_(x, y, btn);
    }

    @Override
    public void func_231023_e_() {
        boolean hasEnergyUpgrade;
        super.func_231023_e_();
        this.energyUsage = 0;
        for (int i = 37; i < 45; ++i) {
            ItemStack stack = ((ContainerItemRouter)this.field_147002_h).func_75139_a(i).func_75211_c();
            if (!(stack.func_77973_b() instanceof ItemModule)) continue;
            this.energyUsage += ((ItemModule)stack.func_77973_b()).getEnergyCost(stack);
        }
        this.energyWidget.field_230694_p_ = hasEnergyUpgrade = ((ContainerItemRouter)this.field_147002_h).getRouter().getEnergyCapacity() > 0;
        this.energyDirButton.field_230694_p_ = hasEnergyUpgrade && ((ContainerItemRouter)this.func_212873_a_()).func_75139_a(36).func_75211_c().getCapability(CapabilityEnergy.ENERGY).isPresent();
        this.energyWarning.field_230690_l_ = hasEnergyUpgrade ? this.field_147003_i - 22 : this.field_147003_i + 4;
    }

    private boolean handleModuleConfig() {
        Slot slot = this.getSlotUnderMouse();
        if (slot == null || !(slot.func_75211_c().func_77973_b() instanceof ItemModule) || slot.field_75222_d < 37 || slot.field_75222_d > 45) {
            return false;
        }
        MFLocator locator = MFLocator.moduleInRouter(((ContainerItemRouter)this.field_147002_h).getRouter().func_174877_v(), slot.field_75222_d - 37);
        PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openModuleInRouter(locator));
        return true;
    }

    @Override
    public void sendToServer() {
        TileEntityItemRouter router = ((ContainerItemRouter)this.field_147002_h).getRouter();
        router.setRedstoneBehaviour((RouterRedstoneBehaviour)this.redstoneBehaviourButton.getState());
        router.setEcoMode(this.ecoButton.isToggled());
        router.setEnergyDirection((TileEntityItemRouter.EnergyDirection)this.energyDirButton.getState());
        PacketHandler.NETWORK.sendToServer((Object)new RouterSettingsMessage(router));
    }

    public Collection<Rectangle2d> getExtraArea() {
        return ((ContainerItemRouter)this.field_147002_h).getRouter().getEnergyCapacity() > 0 ? Collections.singletonList(new Rectangle2d(this.field_147003_i - 27, this.field_147009_r, 32, 100)) : Collections.emptyList();
    }

    private class EnergyWarningButton
    extends TexturedButton {
        public EnergyWarningButton(int x, int y) {
            super(x, y, 16, 16, b -> {});
        }

        @Override
        public List<ITextComponent> getTooltip() {
            if (GuiItemRouter.this.energyUsage <= ((ContainerItemRouter)GuiItemRouter.this.field_147002_h).getRouter().getEnergyStorage().getEnergyStored()) {
                return Collections.emptyList();
            }
            return ((ContainerItemRouter)GuiItemRouter.this.field_147002_h).getRouter().getEnergyCapacity() > 0 ? GuiUtil.xlateAndSplit("modularrouters.itemText.misc.energyWarning", new Object[0]) : GuiUtil.xlateAndSplit("modularrouters.itemText.misc.energyWarning.noBuffer", new Object[0]);
        }

        public void func_230988_a_(SoundHandler p_230988_1_) {
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        protected int getTextureX() {
            return 240;
        }

        @Override
        protected int getTextureY() {
            return ((ContainerItemRouter)GuiItemRouter.this.field_147002_h).getRouter().getEnergyStorage().getEnergyStored() < GuiItemRouter.this.energyUsage && ClientUtil.theClientWorld().func_82737_E() % 40L < 35L ? 0 : 240;
        }
    }

    private class EnergyDirectionButton
    extends TexturedCyclerButton<TileEntityItemRouter.EnergyDirection> {
        public EnergyDirectionButton(int x, int y, TileEntityItemRouter.EnergyDirection initialVal) {
            super(x, y, 14, 14, initialVal, GuiItemRouter.this);
        }

        @Override
        protected int getTextureX() {
            switch ((TileEntityItemRouter.EnergyDirection)this.getState()) {
                case TO_ROUTER: {
                    return 224;
                }
                case FROM_ROUTER: {
                    return 144;
                }
                case NONE: {
                    return 176;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        protected int getTextureY() {
            return 0;
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return ImmutableList.of((Object)ClientUtil.xlate(((TileEntityItemRouter.EnergyDirection)this.getState()).getTranslationKey(), new Object[0]), (Object)ClientUtil.xlate("modularrouters.guiText.tooltip.energy.rate", MiscUtil.commify(((ContainerItemRouter)GuiItemRouter.this.field_147002_h).getRouter().getEnergyXferRate())).func_240699_a_(TextFormatting.GRAY));
        }
    }

    private class EcoButton
    extends TexturedToggleButton {
        EcoButton(int x, int y, int width, int height, boolean initialVal) {
            super(x, y, width, height, initialVal, GuiItemRouter.this);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 96 : 80;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return MiscUtil.wrapStringAsTextComponent(I18n.func_135052_a((String)("modularrouters.guiText.tooltip.eco." + this.isToggled()), (Object[])new Object[]{Float.valueOf((float)MRConfig.Common.Router.ecoTimeout / 20.0f), Float.valueOf((float)MRConfig.Common.Router.lowPowerTickRate / 20.0f)}));
        }
    }
}

