/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.save;

import com.flanks255.simplyutilities.homes.PlayerHomes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class HomeDataManager
extends WorldSavedData {
    private static final String NAME = "simplyutilities_homedata";
    private static final Map<UUID, PlayerHomes> data = new HashMap<UUID, PlayerHomes>();

    public HomeDataManager() {
        super(NAME);
    }

    public static HomeDataManager get(World world) {
        ServerWorld serverWorld = world.func_73046_m().func_241755_D_();
        return (HomeDataManager)serverWorld.func_217481_x().func_215752_a(HomeDataManager::new, NAME);
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("Players")) {
            ListNBT players = nbt.func_150295_c("Players", 10);
            players.forEach(playerNBT -> PlayerHomes.fromNBT((CompoundNBT)playerNBT).ifPresent(player -> data.put(player.getID(), (PlayerHomes)player)));
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT players = new ListNBT();
        data.forEach((uuid, playerHomes) -> players.add((Object)playerHomes.toNBT()));
        compound.func_218657_a("Players", (INBT)players);
        return compound;
    }

    public PlayerHomes getPlayerHomes(UUID uuid, String playername) {
        if (data.containsKey(uuid)) {
            return data.get(uuid);
        }
        PlayerHomes newPlayer = new PlayerHomes(uuid, playername);
        data.put(uuid, newPlayer);
        return newPlayer;
    }
}

