/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.save;

import com.flanks255.simplyutilities.capabilities.SUFluidHandler;
import com.flanks255.simplyutilities.items.FluidCanister;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class FluidDataManager
extends WorldSavedData {
    private static final String NAME = "simplyutilities_fluiddata";
    private static final Map<UUID, SUFluidHandler> handlers = new HashMap<UUID, SUFluidHandler>();

    public FluidDataManager() {
        super(NAME);
    }

    public static FluidDataManager get(World world) {
        ServerWorld serverWorld = world.func_73046_m().func_241755_D_();
        return (FluidDataManager)serverWorld.func_217481_x().func_215752_a(FluidDataManager::new, NAME);
    }

    @Nullable
    public SUFluidHandler getHandler(UUID uuid) {
        if (handlers.containsKey(uuid)) {
            return handlers.get(uuid);
        }
        return null;
    }

    @Nonnull
    public SUFluidHandler getHandler(UUID uuid, int capacity) {
        if (handlers.containsKey(uuid)) {
            return handlers.get(uuid);
        }
        SUFluidHandler newCan = new SUFluidHandler(uuid, capacity);
        handlers.put(uuid, newCan);
        return newCan;
    }

    public SUFluidHandler getHandler(ItemStack itemStack) {
        UUID uuid;
        if (itemStack == null || itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof FluidCanister)) {
            return null;
        }
        CompoundNBT nbt = itemStack.func_196082_o();
        if (nbt.func_74764_b("UUID")) {
            uuid = nbt.func_186857_a("UUID");
        } else {
            uuid = UUID.randomUUID();
            nbt.func_186854_a("UUID", uuid);
            itemStack.func_77982_d(nbt);
        }
        return this.getHandler(uuid, 8000);
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("Handlers")) {
            ListNBT handlerNBT = nbt.func_150295_c("Handlers", 10);
            handlerNBT.forEach(compound -> SUFluidHandler.fromNBT((CompoundNBT)compound).ifPresent(handler -> handlers.put(handler.getUuid(), (SUFluidHandler)handler)));
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT handlersNBT = new ListNBT();
        handlers.forEach((uuid, handlerData) -> handlersNBT.add((Object)handlerData.toNBT()));
        compound.func_218657_a("Handlers", (INBT)handlersNBT);
        return compound;
    }
}

