/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.homes;

import com.flanks255.simplyutilities.homes.HomePoint;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlayerHomes {
    private final UUID ID;
    private final String Name;
    private final Map<String, HomePoint> Homes;

    public PlayerHomes(UUID uuid, String playerName) {
        this.Name = playerName;
        this.ID = uuid;
        this.Homes = new HashMap<String, HomePoint>();
    }

    public void setHome(String name, RegistryKey<World> world, BlockPos pos) {
        this.setHome(name, world.func_240901_a_().toString(), pos);
    }

    public void setHome(String name, String world, BlockPos pos) {
        if (this.isHome(name)) {
            this.getHome(name).update(world, pos);
        } else {
            this.Homes.put(name, new HomePoint(name, world, pos));
        }
    }

    public HomePoint getHome(String name) {
        return this.Homes.get(name);
    }

    public boolean isHome(String name) {
        return this.Homes.containsKey(name);
    }

    public UUID getID() {
        return this.ID;
    }

    public String getName() {
        return this.Name;
    }

    public Set<String> getHomes() {
        return this.Homes.keySet();
    }

    public int getCount() {
        return this.Homes.size();
    }

    public boolean removeHome(String name) {
        if (this.isHome(name)) {
            this.Homes.remove(name);
            return true;
        }
        return false;
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT homeList = new ListNBT();
        nbt.func_186854_a("UUID", this.ID);
        nbt.func_74778_a("Name", this.Name);
        for (Map.Entry<String, HomePoint> entry : this.Homes.entrySet()) {
            homeList.add((Object)entry.getValue().toNBT());
        }
        nbt.func_218657_a("Homes", (INBT)homeList);
        return nbt;
    }

    public static Optional<PlayerHomes> fromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("UUID") && nbt.func_74764_b("Name")) {
            PlayerHomes player = new PlayerHomes(nbt.func_186857_a("UUID"), nbt.func_74779_i("Name"));
            if (nbt.func_74764_b("Homes")) {
                ListNBT homes = nbt.func_150295_c("Homes", 10);
                for (int i = 0; i < homes.size(); ++i) {
                    CompoundNBT home = homes.func_150305_b(i);
                    if (!home.func_74764_b("Name") || !home.func_74764_b("WorldKey") || !home.func_74764_b("Pos")) continue;
                    player.setHome(home.func_74779_i("Name"), home.func_74779_i("WorldKey"), BlockPos.func_218283_e((long)home.func_74763_f("Pos")));
                }
            }
            return Optional.of(player);
        }
        return Optional.empty();
    }
}

