/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.data;

import com.flanks255.simplyutilities.configuration.CommonConfiguration;
import com.flanks255.simplyutilities.configuration.ConfigCache;
import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class BoolConfigCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("simplyutilities", "bool_config_condition");
    private final String boolConfig;

    public BoolConfigCondition(String config) {
        this.boolConfig = config;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        switch (this.boolConfig) {
            default: {
                return true;
            }
            case "smeltFleshIntoLeather": {
                return (Boolean)CommonConfiguration.RECIPE_FLESH_LEATHER.get();
            }
            case "craftLogsToSticks": {
                return (Boolean)CommonConfiguration.RECIPE_LOG_STICK.get();
            }
            case "craftLogsToChests": {
                return (Boolean)CommonConfiguration.RECIPE_LOG_CHESTS.get();
            }
            case "enableEnderInhibitor": {
                return ConfigCache.EnderInhibitorEnabled;
            }
            case "exoleggings": {
                return (Boolean)CommonConfiguration.EXO_LEGGINGS.get();
            }
            case "online_detector": 
        }
        return (Boolean)CommonConfiguration.ONLINE_DETECTOR.get();
    }

    public static class Serializer
    implements IConditionSerializer<BoolConfigCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, BoolConfigCondition value) {
            json.addProperty("config_name", value.boolConfig);
        }

        public BoolConfigCondition read(JsonObject json) {
            return new BoolConfigCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"config_name"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

