/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.noeppi_noeppi.libx.config.ConfigManager;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;

public class SimpleValueMappers {
    public static final ValueMapper<Boolean, JsonPrimitive> BOOLEAN = SimpleValueMappers.createPrimitive(Boolean.class, JsonPrimitive::getAsBoolean, JsonPrimitive::new, PacketBuffer::readBoolean, PacketBuffer::writeBoolean);
    public static final ValueMapper<Byte, JsonPrimitive> BYTE = SimpleValueMappers.createPrimitive(Byte.class, JsonPrimitive::getAsByte, JsonPrimitive::new, PacketBuffer::readByte, PacketBuffer::writeByte);
    public static final ValueMapper<Short, JsonPrimitive> SHORT = SimpleValueMappers.createPrimitive(Short.class, JsonPrimitive::getAsShort, JsonPrimitive::new, PacketBuffer::readShort, PacketBuffer::writeShort);
    public static final ValueMapper<Integer, JsonPrimitive> INTEGER = SimpleValueMappers.createPrimitive(Integer.class, JsonPrimitive::getAsInt, JsonPrimitive::new, PacketBuffer::func_150792_a, PacketBuffer::func_150787_b);
    public static final ValueMapper<Long, JsonPrimitive> LONG = SimpleValueMappers.createPrimitive(Long.class, JsonPrimitive::getAsLong, JsonPrimitive::new, PacketBuffer::func_179260_f, PacketBuffer::func_179254_b);
    public static final ValueMapper<Float, JsonPrimitive> FLOAT = SimpleValueMappers.createPrimitive(Float.class, JsonPrimitive::getAsFloat, JsonPrimitive::new, PacketBuffer::readFloat, PacketBuffer::writeFloat);
    public static final ValueMapper<Double, JsonPrimitive> DOUBLE = SimpleValueMappers.createPrimitive(Double.class, JsonPrimitive::getAsDouble, JsonPrimitive::new, PacketBuffer::readDouble, PacketBuffer::writeDouble);
    public static final ValueMapper<String, JsonPrimitive> STRING = SimpleValueMappers.createPrimitive(String.class, JsonPrimitive::getAsString, JsonPrimitive::new, buffer -> buffer.func_150789_c(Short.MAX_VALUE), (buffer, string) -> buffer.func_211400_a(string, Short.MAX_VALUE));
    public static final ValueMapper<List<?>, JsonArray> LIST = new ValueMapper<List<?>, JsonArray>(){

        @Override
        public Class<List<?>> type() {
            return List.class;
        }

        @Override
        public Class<JsonArray> element() {
            return JsonArray.class;
        }

        @Override
        public List<?> fromJSON(JsonArray json, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < json.size(); ++i) {
                JsonElement element = json.get(i);
                if (!mapper.element().isAssignableFrom(element.getClass())) {
                    throw new JsonSyntaxException("Can't deserialise object of type " + mapper.type() + " from json of type " + element.getClass().getSimpleName());
                }
                builder.add(mapper.fromJSON((Void)element, Void.TYPE));
            }
            return builder.build();
        }

        @Override
        public JsonArray toJSON(List<?> value, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            JsonArray array = new JsonArray();
            for (Object element : value) {
                array.add(mapper.toJSON((Void)element, Void.TYPE));
            }
            return array;
        }

        @Override
        public List<?> read(PacketBuffer buffer, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            int size = buffer.func_150792_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add(mapper.read(buffer, Void.TYPE));
            }
            return builder.build();
        }

        @Override
        public void write(List<?> value, PacketBuffer buffer, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            buffer.func_150787_b(value.size());
            for (Object elem : value) {
                mapper.write((Void)elem, buffer, Void.TYPE);
            }
        }
    };
    public static final ValueMapper<Map<String, ?>, JsonObject> MAP = new ValueMapper<Map<String, ?>, JsonObject>(){

        @Override
        public Class<Map<String, ?>> type() {
            return Map.class;
        }

        @Override
        public Class<JsonObject> element() {
            return JsonObject.class;
        }

        @Override
        public Map<String, ?> fromJSON(JsonObject json, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : json.entrySet()) {
                if (mapper.element().isAssignableFrom(((JsonElement)entry.getValue()).getClass())) {
                    builder.put(entry.getKey(), mapper.fromJSON((Void)((JsonElement)entry.getValue()), Void.TYPE));
                    continue;
                }
                throw new JsonSyntaxException("Can't deserialise object of type " + mapper.type() + " from json of type " + ((JsonElement)entry.getValue()).getClass().getSimpleName());
            }
            return builder.build();
        }

        @Override
        public JsonObject toJSON(Map<String, ?> value, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            JsonObject object = new JsonObject();
            for (Map.Entry<String, ?> entry : value.entrySet()) {
                object.add(entry.getKey(), mapper.toJSON((Void)entry.getValue(), Void.TYPE));
            }
            return object;
        }

        @Override
        public Map<String, ?> read(PacketBuffer buffer, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            int size = buffer.func_150792_a();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                builder.put((Object)buffer.func_150789_c(Short.MAX_VALUE), mapper.read(buffer, Void.TYPE));
            }
            return builder.build();
        }

        @Override
        public void write(Map<String, ?> value, PacketBuffer buffer, Class<?> elementType) {
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            buffer.func_150787_b(value.size());
            for (Map.Entry<String, ?> entry : value.entrySet()) {
                buffer.func_211400_a(entry.getKey(), Short.MAX_VALUE);
                mapper.write((Void)entry.getValue(), buffer, Void.TYPE);
            }
        }
    };
    public static final ValueMapper<Optional<?>, JsonElement> OPTION = new ValueMapper<Optional<?>, JsonElement>(){

        @Override
        public Class<Optional<?>> type() {
            return Optional.class;
        }

        @Override
        public Class<JsonElement> element() {
            return JsonElement.class;
        }

        @Override
        public Optional<?> fromJSON(JsonElement json, Class<?> elementType) {
            if (json.isJsonNull()) {
                return Optional.empty();
            }
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            if (!mapper.element().isAssignableFrom(json.getClass())) {
                throw new JsonSyntaxException("Can't deserialise object of type " + mapper.type() + " from json of type " + json.getClass().getSimpleName() + " (expected " + mapper.element().getSimpleName() + ")");
            }
            return Optional.of(mapper.fromJSON((Void)json, Void.TYPE));
        }

        @Override
        public JsonElement toJSON(Optional<?> value, Class<?> elementType) {
            if (!value.isPresent()) {
                return JsonNull.INSTANCE;
            }
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            return mapper.toJSON((Void)value.get(), Void.TYPE);
        }

        @Override
        public Optional<?> read(PacketBuffer buffer, Class<?> elementType) {
            if (!buffer.readBoolean()) {
                return Optional.empty();
            }
            ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
            return Optional.of(mapper.read(buffer, Void.TYPE));
        }

        @Override
        public void write(Optional<?> value, PacketBuffer buffer, Class<?> elementType) {
            if (!value.isPresent()) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                ValueMapper<Void, Void> mapper = ConfigManager.getMapper(null, elementType);
                mapper.write((Void)value.get(), buffer, Void.TYPE);
            }
        }
    };

    private static <T> ValueMapper<T, JsonPrimitive> createPrimitive(final Class<T> typeClass, final Function<JsonPrimitive, T> fromJSON, final Function<T, JsonPrimitive> toJSON, final Function<PacketBuffer, T> read, final BiConsumer<PacketBuffer, T> write) {
        return new ValueMapper<T, JsonPrimitive>(){

            @Override
            public Class<T> type() {
                return typeClass;
            }

            @Override
            public Class<JsonPrimitive> element() {
                return JsonPrimitive.class;
            }

            @Override
            public T fromJSON(JsonPrimitive json, Class<?> elementType) {
                return fromJSON.apply(json);
            }

            @Override
            public JsonPrimitive toJSON(T value, Class<?> elementType) {
                return (JsonPrimitive)toJSON.apply(value);
            }

            @Override
            public T read(PacketBuffer buffer, Class<?> elementType) {
                return read.apply(buffer);
            }

            @Override
            public void write(T value, PacketBuffer buffer, Class<?> elementType) {
                write.accept(buffer, value);
            }
        };
    }
}

