/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockTile;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockReader;

public class EntangledBlockTileRenderer
extends TileEntityRenderer<EntangledBlockTile> {
    private static int depth = 0;

    public EntangledBlockTileRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(EntangledBlockTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        VoxelShape shape;
        if (!tile.isBound()) {
            return;
        }
        TileEntity boundTile = tile.func_145831_w().func_234923_W_() == tile.getBoundDimension() ? tile.func_145831_w().func_175625_s(tile.getBoundBlockPos()) : null;
        BlockState boundState = tile.getBoundBlockState();
        boolean renderTile = boundTile != null && EntangledBlockTileRenderer.canRenderTileEntity(boundTile.func_200662_C().getRegistryName());
        boolean renderBlock = boundState != null && boundState.func_185901_i() == BlockRenderType.MODEL && EntangledBlockTileRenderer.canRenderBlock(boundState.func_177230_c().getRegistryName());
        AxisAlignedBB bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (renderBlock && tile.func_145831_w().func_234923_W_() == tile.getBoundDimension() && !(shape = boundState.func_235754_c_((IBlockReader)tile.func_145831_w(), tile.getBoundBlockPos())).func_197766_b()) {
            bounds = shape.func_197752_a();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float angleX = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 360.0f;
        float angleY = (float)(System.currentTimeMillis() % 11000L) / 11000.0f * 360.0f;
        float angleZ = (float)(System.currentTimeMillis() % 12000L) / 12000.0f * 360.0f;
        matrixStack.func_227863_a_(new Quaternion(angleX, angleY, angleZ, true));
        float scale = 0.4763f / (float)Math.sqrt((bounds.func_216364_b() * bounds.func_216364_b() + bounds.func_216360_c() * bounds.func_216360_c() + bounds.func_216362_d() * bounds.func_216362_d()) / 4.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_(-bounds.func_189972_c().field_72450_a, -bounds.func_189972_c().field_72448_b, -bounds.func_189972_c().field_72449_c);
        if (renderTile && (!(boundTile instanceof EntangledBlockTile) || depth < 10)) {
            ++depth;
            TileEntityRendererDispatcher.field_147556_a.func_228850_a_(boundTile, partialTicks, matrixStack, buffer);
            --depth;
        }
        if (renderBlock) {
            Minecraft.func_71410_x().func_175602_ab().func_228791_a_(boundState, matrixStack, buffer, combinedLight, combinedOverlay);
        }
        matrixStack.func_227865_b_();
    }

    private static boolean canRenderBlock(ResourceLocation block) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(block.func_110624_b()) && !Entangled.RENDER_BLACKLISTED_BLOCKS.contains(block);
    }

    private static boolean canRenderTileEntity(ResourceLocation tile) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(tile.func_110624_b()) && !Entangled.RENDER_BLACKLISTED_TILE_ENTITIES.contains(tile);
    }
}

