/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockBakedItemModel;
import com.supermartijn642.entangled.EntangledBlockTile;
import com.supermartijn642.entangled.EntangledBlockTileRenderer;
import com.supermartijn642.entangled.EntangledConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        ClientRegistry.bindTileEntityRenderer(Entangled.tile, EntangledBlockTileRenderer::new);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("entangled", "block"), "inventory");
        IBakedModel model = (IBakedModel)e.getModelRegistry().get(location);
        if (model != null) {
            e.getModelRegistry().put(location, new EntangledBlockBakedItemModel(model));
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onDrawPlayerEvent(RenderWorldLastEvent e) {
            CompoundNBT compound;
            ItemStack stack = ClientUtils.getPlayer().func_184586_b(Hand.MAIN_HAND);
            World world = ClientUtils.getWorld();
            if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() == Entangled.block && stack.func_77942_o() && stack.func_196082_o().func_74764_b("tileData")) {
                CompoundNBT compound2 = stack.func_196082_o().func_74775_l("tileData");
                if (compound2.func_74767_n("bound") && compound2.func_74779_i("dimension").equals(world.func_234923_W_().func_240901_a_().toString())) {
                    BlockPos pos = new BlockPos(compound2.func_74762_e("boundx"), compound2.func_74762_e("boundy"), compound2.func_74762_e("boundz"));
                    e.getMatrixStack().func_227860_a_();
                    Vector3d camera = RenderUtils.getCameraPosition();
                    e.getMatrixStack().func_227861_a_(-camera.field_72450_a, -camera.field_72448_b, -camera.field_72449_c);
                    e.getMatrixStack().func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    RenderUtils.disableDepthTest();
                    RenderUtils.renderShape((MatrixStack)e.getMatrixStack(), (VoxelShape)world.func_180495_p(pos).func_235754_c_((IBlockReader)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f);
                    RenderUtils.renderShapeSides((MatrixStack)e.getMatrixStack(), (VoxelShape)world.func_180495_p(pos).func_235754_c_((IBlockReader)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f, (float)0.11764706f);
                    RenderUtils.resetState();
                    e.getMatrixStack().func_227865_b_();
                }
            } else if (stack.func_77973_b() == Entangled.item && (compound = stack.func_196082_o()).func_74767_n("bound") && compound.func_74779_i("dimension").equals(world.func_234923_W_().func_240901_a_().toString())) {
                BlockPos pos = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
                e.getMatrixStack().func_227860_a_();
                Vector3d camera = RenderUtils.getCameraPosition();
                e.getMatrixStack().func_227861_a_(-camera.field_72450_a, -camera.field_72448_b, -camera.field_72449_c);
                e.getMatrixStack().func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                RenderUtils.disableDepthTest();
                RenderUtils.renderShape((MatrixStack)e.getMatrixStack(), (VoxelShape)world.func_180495_p(pos).func_235754_c_((IBlockReader)world, pos), (float)0.92156863f, (float)0.8235294f, (float)0.20392157f);
                RenderUtils.renderShapeSides((MatrixStack)e.getMatrixStack(), (VoxelShape)world.func_180495_p(pos).func_235754_c_((IBlockReader)world, pos), (float)0.92156863f, (float)0.8235294f, (float)0.20392157f, (float)0.11764706f);
                RenderUtils.resetState();
                e.getMatrixStack().func_227865_b_();
            }
        }

        @SubscribeEvent
        public static void onBlockHighlight(DrawHighlightEvent.HighlightBlock e) {
            if (e.getTarget().func_216346_c() != RayTraceResult.Type.BLOCK || e.getTarget().func_216350_a() == null || !EntangledConfig.renderBlockHighlight.get().booleanValue()) {
                return;
            }
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            TileEntity tile = world.func_175625_s(e.getTarget().func_216350_a());
            if (tile instanceof EntangledBlockTile && ((EntangledBlockTile)tile).isBound() && ((EntangledBlockTile)tile).getBoundDimension() == world.func_234923_W_()) {
                BlockPos pos = ((EntangledBlockTile)tile).getBoundBlockPos();
                e.getMatrix().func_227860_a_();
                Vector3d camera = RenderUtils.getCameraPosition();
                e.getMatrix().func_227861_a_(-camera.field_72450_a, -camera.field_72448_b, -camera.field_72449_c);
                e.getMatrix().func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                RenderUtils.disableDepthTest();
                RenderUtils.renderShape((MatrixStack)e.getMatrix(), (VoxelShape)world.func_180495_p(pos).func_235754_c_((IBlockReader)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f);
                RenderUtils.renderShapeSides((MatrixStack)e.getMatrix(), (VoxelShape)world.func_180495_p(pos).func_235754_c_((IBlockReader)world, pos), (float)0.3372549f, (float)0.0f, (float)0.6117647f, (float)0.11764706f);
                RenderUtils.resetState();
                e.getMatrix().func_227865_b_();
            }
        }
    }
}

