/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.SimpleFluidHandler;
import cofh.lib.tileentity.ITileCallback;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ManagedFluidHandler
extends SimpleFluidHandler {
    protected List<FluidStorageCoFH> inputTanks;
    protected List<FluidStorageCoFH> outputTanks;
    protected boolean preventInputDrain = false;

    public ManagedFluidHandler(@Nullable ITileCallback tile, @Nonnull List<FluidStorageCoFH> inputTanks, @Nonnull List<FluidStorageCoFH> outputTanks) {
        super(tile);
        this.inputTanks = inputTanks;
        this.outputTanks = outputTanks;
        this.tanks.addAll(inputTanks);
        this.tanks.addAll(outputTanks);
    }

    public ManagedFluidHandler restrict() {
        this.preventInputDrain = true;
        return this;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (FluidStorageCoFH tank : this.inputTanks) {
            int ret = tank.fill(resource, action);
            if (ret <= 0) continue;
            return ret;
        }
        return 0;
    }

    @Override
    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack ret;
        for (FluidStorageCoFH tank : this.outputTanks) {
            ret = tank.drain(resource, action);
            if (ret.isEmpty()) continue;
            return ret;
        }
        if (!this.preventInputDrain) {
            for (FluidStorageCoFH tank : this.inputTanks) {
                ret = tank.drain(resource, action);
                if (action.execute()) {
                    this.onTankChange(0);
                }
                if (ret.isEmpty()) continue;
                return ret;
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack ret;
        for (FluidStorageCoFH tank : this.outputTanks) {
            ret = tank.drain(maxDrain, action);
            if (ret.isEmpty()) continue;
            return ret;
        }
        if (!this.preventInputDrain) {
            for (FluidStorageCoFH tank : this.inputTanks) {
                ret = tank.drain(maxDrain, action);
                if (action.execute()) {
                    this.onTankChange(0);
                }
                if (ret.isEmpty()) continue;
                return ret;
            }
        }
        return FluidStack.EMPTY;
    }
}

