/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.client.gui.element.ElementEnergyStorage;
import cofh.core.client.gui.element.ElementFluidStorage;
import cofh.core.client.gui.element.ElementResourceStorage;
import cofh.core.client.gui.element.ElementScaled;
import cofh.core.client.gui.element.ElementScaledFluid;
import cofh.core.client.gui.element.ElementSlot;
import cofh.core.client.gui.element.ElementXpStorage;
import cofh.core.network.packet.server.ClaimXPPacket;
import cofh.core.network.packet.server.StorageClearPacket;
import cofh.core.tileentity.TileCoFH;
import cofh.lib.client.gui.IGuiAccess;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.xp.XpStorage;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;

public class GuiHelper {
    public static final int SLOT_SIZE = 18;
    public static final int LARGE_SLOT_SIZE = 26;
    public static final int DURATION = 16;
    public static final int PROGRESS = 24;
    public static final int SPEED = 16;
    public static final int HEIGHT = 16;
    public static final String BUTTON_18 = "cofh_core:textures/gui/elements/button_18.png";
    public static final String BUTTON_18_HIGHLIGHT = "cofh_core:textures/gui/elements/button_18_highlight.png";
    public static final String BUTTON_18_INACTIVE = "cofh_core:textures/gui/elements/button_18_inactive.png";
    public static final String INFO_INPUT = "cofh_core:textures/gui/elements/info_input.png";
    public static final String INFO_OUTPUT = "cofh_core:textures/gui/elements/info_output.png";
    public static final String NAV_BACK = "cofh_core:textures/gui/elements/nav_back.png";
    public static final String NAV_FILTER = "cofh_core:textures/gui/elements/nav_filter.png";
    public static final String TAB_BOTTOM = "cofh_core:textures/gui/elements/tab_bottom.png";
    public static final String TAB_TOP = "cofh_core:textures/gui/elements/tab_top.png";
    public static final String PROG_ARROW_LEFT = "cofh_core:textures/gui/elements/progress_arrow_left.png";
    public static final String PROG_ARROW_RIGHT = "cofh_core:textures/gui/elements/progress_arrow_right.png";
    public static final String PROG_ARROW_FLUID_LEFT = "cofh_core:textures/gui/elements/progress_arrow_fluid_left.png";
    public static final String PROG_ARROW_FLUID_RIGHT = "cofh_core:textures/gui/elements/progress_arrow_fluid_right.png";
    public static final String PROG_DROP_LEFT = "cofh_core:textures/gui/elements/progress_fluid_left.png";
    public static final String PROG_DROP_RIGHT = "cofh_core:textures/gui/elements/progress_fluid_right.png";
    public static final String SCALE_ALCHEMY = "cofh_core:textures/gui/elements/scale_alchemy.png";
    public static final String SCALE_BOOK = "cofh_core:textures/gui/elements/scale_book.png";
    public static final String SCALE_BUBBLE = "cofh_core:textures/gui/elements/scale_bubble.png";
    public static final String SCALE_COMPACT = "cofh_core:textures/gui/elements/scale_compact.png";
    public static final String SCALE_CRUSH = "cofh_core:textures/gui/elements/scale_crush.png";
    public static final String SCALE_FLAME = "cofh_core:textures/gui/elements/scale_flame.png";
    public static final String SCALE_FLAME_GREEN = "cofh_core:textures/gui/elements/scale_flame_green.png";
    public static final String SCALE_FLUX = "cofh_core:textures/gui/elements/scale_flux.png";
    public static final String SCALE_SAW = "cofh_core:textures/gui/elements/scale_saw.png";
    public static final String SCALE_SPIN = "cofh_core:textures/gui/elements/scale_spin.png";
    public static final String SCALE_SUN = "cofh_core:textures/gui/elements/scale_sun.png";
    public static final String SCALE_SNOWFLAKE = "cofh_core:textures/gui/elements/scale_snowflake.png";

    private GuiHelper() {
    }

    public static ElementEnergyStorage createDefaultEnergyStorage(IGuiAccess gui, int posX, int posY, EnergyStorageCoFH storage) {
        return GuiHelper.createDefaultEnergyStorage(gui, posX, posY, storage, 16, 42, 32, 64);
    }

    public static ElementEnergyStorage createDefaultEnergyStorage(IGuiAccess gui, int posX, int posY, EnergyStorageCoFH storage, int width, int height, int texW, int texH) {
        return (ElementEnergyStorage)new ElementEnergyStorage(gui, posX, posY, storage).setCreativeTexture("cofh_core:textures/gui/elements/storage_energy_c.png").setTexture("cofh_core:textures/gui/elements/storage_energy.png", texW, texH).setSize(width, height);
    }

    public static ElementResourceStorage setClearable(ElementEnergyStorage storage, TileCoFH tile, int coil) {
        return storage.setClearStorage(() -> StorageClearPacket.sendToServer(tile, StorageClearPacket.StorageType.ENERGY, coil));
    }

    public static ElementFluidStorage createLargeFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 62, "cofh_core:textures/gui/elements/storage_fluid_large.png", "cofh_core:textures/gui/elements/overlay_fluid_large.png", 32, 64);
    }

    public static ElementFluidStorage createLargeInputFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, IReconfigurable reconfig) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 62, "cofh_core:textures/gui/elements/storage_fluid_large.png", "cofh_core:textures/gui/elements/input_underlay_fluid_large.png", reconfig::hasInputSide, "cofh_core:textures/gui/elements/overlay_fluid_large.png", 32, 64);
    }

    public static ElementFluidStorage createLargeOutputFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, IReconfigurable reconfig) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 62, "cofh_core:textures/gui/elements/storage_fluid_large.png", "cofh_core:textures/gui/elements/output_underlay_fluid_large.png", reconfig::hasOutputSide, "cofh_core:textures/gui/elements/overlay_fluid_large.png", 32, 64);
    }

    public static ElementFluidStorage createMediumFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 42, "cofh_core:textures/gui/elements/storage_fluid_medium.png", "cofh_core:textures/gui/elements/overlay_fluid_medium.png", 32, 64);
    }

    public static ElementFluidStorage createMediumInputFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, IReconfigurable reconfig) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 42, "cofh_core:textures/gui/elements/storage_fluid_medium.png", "cofh_core:textures/gui/elements/input_underlay_fluid_medium.png", reconfig::hasInputSide, "cofh_core:textures/gui/elements/overlay_fluid_medium.png", 32, 64);
    }

    public static ElementFluidStorage createMediumOutputFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, IReconfigurable reconfig) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 42, "cofh_core:textures/gui/elements/storage_fluid_medium.png", "cofh_core:textures/gui/elements/output_underlay_fluid_medium.png", reconfig::hasOutputSide, "cofh_core:textures/gui/elements/overlay_fluid_medium.png", 32, 64);
    }

    public static ElementFluidStorage createSmallFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 34, "cofh_core:textures/gui/elements/storage_fluid_small.png", "cofh_core:textures/gui/elements/overlay_fluid_small.png", 32, 64);
    }

    public static ElementFluidStorage createSmallInputFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, IReconfigurable reconfig) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 34, "cofh_core:textures/gui/elements/storage_fluid_small.png", "cofh_core:textures/gui/elements/input_underlay_fluid_small.png", reconfig::hasInputSide, "cofh_core:textures/gui/elements/overlay_fluid_small.png", 32, 64);
    }

    public static ElementFluidStorage createSmallOutputFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, IReconfigurable reconfig) {
        return GuiHelper.createDefaultFluidStorage(gui, posX, posY, storage, 18, 34, "cofh_core:textures/gui/elements/storage_fluid_small.png", "cofh_core:textures/gui/elements/output_underlay_fluid_small.png", reconfig::hasOutputSide, "cofh_core:textures/gui/elements/overlay_fluid_small.png", 32, 64);
    }

    public static ElementFluidStorage createDefaultFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, int width, int height, String texture, String overlayTexture, int texW, int texH) {
        return (ElementFluidStorage)new ElementFluidStorage(gui, posX, posY, storage).setOverlayTexture(overlayTexture).setSize(width, height).setTexture(texture, texW, texH);
    }

    public static ElementFluidStorage createDefaultFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage, int width, int height, String texture, String underlayTexture, BooleanSupplier drawUnderlay, String overlayTexture, int texW, int texH) {
        return (ElementFluidStorage)new ElementFluidStorage(gui, posX, posY, storage).setUnderlayTexture(underlayTexture, drawUnderlay).setOverlayTexture(overlayTexture).setSize(width, height).setTexture(texture, texW, texH);
    }

    public static ElementResourceStorage setClearable(ElementFluidStorage storage, TileCoFH tile, int tank) {
        return storage.setClearStorage(() -> StorageClearPacket.sendToServer(tile, StorageClearPacket.StorageType.FLUID, tank));
    }

    public static ElementSlot createSlot(IGuiAccess gui, int posX, int posY) {
        return GuiHelper.createDefaultSlot(gui, posX - 1, posY - 1, 18, 18, "cofh_core:textures/gui/elements/slot.png", 32, 32);
    }

    public static ElementSlot createInputSlot(IGuiAccess gui, int posX, int posY, IReconfigurable reconfig) {
        return GuiHelper.createDefaultSlot(gui, posX - 1, posY - 1, 18, 18, "cofh_core:textures/gui/elements/slot.png", "cofh_core:textures/gui/elements/input_underlay_slot.png", reconfig::hasInputSide, 32, 32);
    }

    public static ElementSlot createOutputSlot(IGuiAccess gui, int posX, int posY, IReconfigurable reconfig) {
        return GuiHelper.createDefaultSlot(gui, posX - 1, posY - 1, 18, 18, "cofh_core:textures/gui/elements/slot.png", "cofh_core:textures/gui/elements/output_underlay_slot.png", reconfig::hasOutputSide, 32, 32);
    }

    public static ElementSlot createLargeSlot(IGuiAccess gui, int posX, int posY) {
        return GuiHelper.createDefaultSlot(gui, posX - 1, posY - 1, 26, 26, "cofh_core:textures/gui/elements/slot_large.png", 32, 32);
    }

    public static ElementSlot createLargeInputSlot(IGuiAccess gui, int posX, int posY, IReconfigurable reconfig) {
        return GuiHelper.createDefaultSlot(gui, posX - 5, posY - 5, 26, 26, "cofh_core:textures/gui/elements/slot_large.png", "cofh_core:textures/gui/elements/input_underlay_slot_large.png", reconfig::hasInputSide, 32, 32);
    }

    public static ElementSlot createLargeOutputSlot(IGuiAccess gui, int posX, int posY, IReconfigurable reconfig) {
        return GuiHelper.createDefaultSlot(gui, posX - 5, posY - 5, 26, 26, "cofh_core:textures/gui/elements/slot_large.png", "cofh_core:textures/gui/elements/output_underlay_slot_large.png", reconfig::hasOutputSide, 32, 32);
    }

    public static ElementSlot createDefaultSlot(IGuiAccess gui, int posX, int posY, int width, int height, String texture, int texW, int texH) {
        return (ElementSlot)new ElementSlot(gui, posX, posY).setSize(width, height).setTexture(texture, texW, texH);
    }

    public static ElementSlot createDefaultSlot(IGuiAccess gui, int posX, int posY, int width, int height, String texture, String overlayTexture, int texW, int texH) {
        return (ElementSlot)new ElementSlot(gui, posX, posY).setOverlayTexture(overlayTexture).setSize(width, height).setTexture(texture, texW, texH);
    }

    public static ElementSlot createDefaultSlot(IGuiAccess gui, int posX, int posY, int width, int height, String texture, String underlayTexture, BooleanSupplier drawUnderlay, int texW, int texH) {
        return (ElementSlot)new ElementSlot(gui, posX, posY).setUnderlayTexture(underlayTexture, drawUnderlay).setSize(width, height).setTexture(texture, texW, texH);
    }

    public static ElementSlot createDefaultSlot(IGuiAccess gui, int posX, int posY, int width, int height, String texture, String underlayTexture, BooleanSupplier drawUnderlay, String overlayTexture, int texW, int texH) {
        return (ElementSlot)new ElementSlot(gui, posX, posY).setUnderlayTexture(underlayTexture, drawUnderlay).setOverlayTexture(overlayTexture).setSize(width, height).setTexture(texture, texW, texH);
    }

    public static ElementXpStorage createDefaultXpStorage(IGuiAccess gui, int posX, int posY, XpStorage storage) {
        return GuiHelper.createDefaultXpStorage(gui, posX, posY, storage, 16, 16, "cofh_core:textures/gui/elements/storage_xp.png", 16, 80);
    }

    public static ElementXpStorage createDefaultXpStorage(IGuiAccess gui, int posX, int posY, XpStorage storage, int width, int height, String texture, int texW, int texH) {
        return (ElementXpStorage)new ElementXpStorage(gui, posX, posY, storage).setSize(width, height).setTexture(texture, texW, texH);
    }

    public static ElementResourceStorage setClaimable(ElementXpStorage storage, TileCoFH tile) {
        return storage.setClaimStorage(() -> ClaimXPPacket.sendToServer(tile));
    }

    public static ElementScaled createDefaultProgress(IGuiAccess gui, int posX, int posY, String texture, IntSupplier quantitySup) {
        return GuiHelper.createDefaultProgress(gui, posX, posY, texture, quantitySup, Constants.TRUE);
    }

    public static ElementScaled createDefaultProgress(IGuiAccess gui, int posX, int posY, String texture, IntSupplier quantitySup, BooleanSupplier visible) {
        return (ElementScaled)new ElementScaled(gui, posX, posY).setQuantity(quantitySup).setDirection(ElementScaled.StartDirection.LEFT).setSize(24, 16).setTexture(texture, 64, 16).setVisible(visible);
    }

    public static ElementScaledFluid createDefaultFluidProgress(IGuiAccess gui, int posX, int posY, String texture, IntSupplier quantitySup, Supplier<FluidStack> fluidSup) {
        return GuiHelper.createDefaultFluidProgress(gui, posX, posY, texture, quantitySup, fluidSup, Constants.TRUE);
    }

    public static ElementScaledFluid createDefaultFluidProgress(IGuiAccess gui, int posX, int posY, String texture, IntSupplier quantitySup, Supplier<FluidStack> fluidSup, BooleanSupplier visible) {
        return (ElementScaledFluid)new ElementScaledFluid(gui, posX, posY).setFluid(fluidSup).setQuantity(quantitySup).setDirection(ElementScaled.StartDirection.LEFT).setSize(24, 16).setTexture(texture, 64, 16).setVisible(visible);
    }

    public static ElementScaled createDefaultSpeed(IGuiAccess gui, int posX, int posY, String texture, IntSupplier quantitySup) {
        return (ElementScaled)new ElementScaled(gui, posX, posY).setQuantity(quantitySup).setSize(16, 16).setTexture(texture, 32, 16);
    }

    public static ElementScaled createDefaultDuration(IGuiAccess gui, int posX, int posY, String texture, IntSupplier quantitySup) {
        return (ElementScaled)new ElementScaled(gui, posX, posY).setQuantity(quantitySup).setSize(16, 16).setTexture(texture, 32, 16);
    }

    public static String generatePanelInfo(String key) {
        int i = 0;
        String line = key + "." + i;
        StringBuilder builder = new StringBuilder();
        while (StringHelper.canLocalize(line)) {
            if (i > 0) {
                builder.append("\n\n");
            }
            builder.append(StringHelper.localize(line));
            line = key + "." + ++i;
        }
        return builder.toString();
    }

    public static String appendLine(String existing, String line) {
        return existing + "\n\n" + StringHelper.localize(line);
    }
}

