/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.filter;

import cofh.lib.util.filter.IFilter;
import cofh.lib.util.filter.IFilterOptions;
import cofh.lib.util.helpers.ItemHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractItemFilter
implements IFilter,
IFilterOptions {
    public static final int SIZE = 15;
    protected List<ItemStack> items;
    protected Predicate<ItemStack> rules;
    protected boolean allowList = false;
    protected boolean checkNBT = false;

    public AbstractItemFilter(int size) {
        this.items = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(ItemStack.field_190927_a);
        }
    }

    public int size() {
        return this.items.size();
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
        this.reset();
    }

    public void reset() {
        this.rules = null;
    }

    @Override
    public Predicate<ItemStack> getItemRules() {
        if (this.rules == null) {
            ObjectOpenHashSet itemSet = new ObjectOpenHashSet();
            for (ItemStack item : this.items) {
                itemSet.add(item.func_77973_b());
            }
            this.rules = arg_0 -> this.lambda$getItemRules$0((Set)itemSet, arg_0);
        }
        return this.rules;
    }

    @Override
    public IFilter read(CompoundNBT nbt) {
        CompoundNBT subTag = nbt.func_74775_l("Filter");
        ListNBT list = subTag.func_150295_c("ItemInv", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT slotTag = list.func_150305_b(i);
            byte slot = slotTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, ItemStack.func_199557_a((CompoundNBT)slotTag));
        }
        this.allowList = subTag.func_74767_n("AllowList");
        this.checkNBT = subTag.func_74767_n("CheckNBT");
        return this;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        CompoundNBT subTag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).func_190926_b()) continue;
            CompoundNBT slotTag = new CompoundNBT();
            slotTag.func_74774_a("Slot", (byte)i);
            this.items.get(i).func_77955_b(slotTag);
            list.add((Object)slotTag);
        }
        subTag.func_218657_a("ItemInv", (INBT)list);
        subTag.func_74757_a("AllowList", this.allowList);
        subTag.func_74757_a("CheckNBT", this.checkNBT);
        nbt.func_218657_a("Filter", (INBT)subTag);
        return nbt;
    }

    @Override
    public boolean getAllowList() {
        return this.allowList;
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        this.allowList = allowList;
        return true;
    }

    @Override
    public boolean getCheckNBT() {
        return this.checkNBT;
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        this.checkNBT = checkNBT;
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("info.cofh.item_filter");
    }

    private /* synthetic */ boolean lambda$getItemRules$0(Set itemSet, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.allowList != itemSet.contains(stack.func_77973_b())) {
            return false;
        }
        if (this.checkNBT) {
            for (ItemStack item : this.items) {
                if (!ItemHelper.itemsEqualWithTags(stack, item)) continue;
                return this.allowList;
            }
            return !this.allowList;
        }
        return true;
    }
}

