/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.tileentity.TileCoFH;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.tileentity.ITilePacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileConfigPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected PacketBuffer buffer;

    public TileConfigPacket() {
        super(32, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof ITilePacketHandler) {
            ((ITilePacketHandler)tile).handleConfigPacket(this.buffer);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.buffer = buf;
        this.pos = this.buffer.func_179259_c();
    }

    public static void sendToServer(TileCoFH tile) {
        TileConfigPacket packet = new TileConfigPacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getConfigPacket(new PacketBuffer(Unpooled.buffer()));
        packet.sendToServer();
    }
}

