/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.lib.capability.templates.AreaEffectMiningItemWrapper;
import cofh.lib.util.constants.ToolTypes;
import javax.annotation.Nullable;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ExcavatorItem
extends ShovelItem {
    private static final float DEFAULT_ATTACK_DAMAGE = 2.0f;
    private static final float DEFAULT_ATTACK_SPEED = -3.2f;
    private static final int DEFAULT_BASE_AREA = 1;
    private final int radius;

    public ExcavatorItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, int radius, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder.addToolType(ToolTypes.EXCAVATOR, tier.func_200925_d()));
        this.radius = radius;
    }

    public ExcavatorItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackDamageIn, attackSpeedIn, 1, builder.addToolType(ToolTypes.EXCAVATOR, tier.func_200925_d()));
    }

    public ExcavatorItem(IItemTier tier, float attackDamageIn, Item.Properties builder) {
        this(tier, attackDamageIn, -3.2f, 1, builder.addToolType(ToolTypes.EXCAVATOR, tier.func_200925_d()));
    }

    public ExcavatorItem(IItemTier tier, Item.Properties builder) {
        this(tier, 2.0f, -3.2f, 1, builder.addToolType(ToolTypes.EXCAVATOR, tier.func_200925_d()));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new AreaEffectMiningItemWrapper(stack, this.radius, AreaEffectMiningItemWrapper.Type.EXCAVATOR);
    }
}

