/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.client.renderer.MyRenderType;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.ModItems;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RenderMiningLaser {
    private static final ResourceLocation laserBeam = new ResourceLocation("mininggadgets:textures/misc/laser.png");
    private static final ResourceLocation laserBeam2 = new ResourceLocation("mininggadgets:textures/misc/laser2.png");
    private static final ResourceLocation laserBeamGlow = new ResourceLocation("mininggadgets:textures/misc/laser_glow.png");

    public static void renderLaser(RenderWorldLastEvent event, PlayerEntity player, float ticks) {
        ItemStack stack = MiningGadget.getGadget(player);
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        int range = MiningProperties.getBeamRange(stack);
        Vector3d playerPos = player.func_174824_e(ticks);
        RayTraceResult trace = player.func_213324_a((double)range, 0.0f, false);
        float speedModifier = RenderMiningLaser.getSpeedModifier(stack);
        RenderMiningLaser.drawLasers(stack, event, playerPos, trace, 0.0, 0.0, 0.0, (float)MiningProperties.getColor(stack, "colorRed") / 255.0f, (float)MiningProperties.getColor(stack, "colorGreen") / 255.0f, (float)MiningProperties.getColor(stack, "colorBlue") / 255.0f, 0.02f, player, ticks, speedModifier);
    }

    private static float getSpeedModifier(ItemStack stack) {
        if (UpgradeTools.containsUpgrade(stack, Upgrade.EFFICIENCY_1)) {
            double efficiency = (float)UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier() / 5.0f;
            double speedModifier = MathHelper.func_219803_d((double)efficiency, (double)0.02, (double)0.05);
            return (float)(-speedModifier);
        }
        return -0.02f;
    }

    private static void drawLasers(ItemStack stack, RenderWorldLastEvent event, Vector3d from, RayTraceResult trace, double xOffset, double yOffset, double zOffset, float r, float g, float b, float thickness, PlayerEntity player, float ticks, float speedModifier) {
        Hand activeHand;
        if (player.func_184614_ca().func_77973_b() instanceof MiningGadget) {
            activeHand = Hand.MAIN_HAND;
        } else if (player.func_184592_cb().func_77973_b() instanceof MiningGadget) {
            activeHand = Hand.OFF_HAND;
        } else {
            return;
        }
        double distance = Math.max(1.0, from.func_178788_d(trace.func_216347_e()).func_72433_c());
        long gameTime = player.field_70170_p.func_82737_E();
        double v = (float)gameTime * speedModifier;
        float additiveThickness = thickness * 3.5f * RenderMiningLaser.calculateLaserFlickerModifier(gameTime);
        float beam2r = (float)MiningProperties.getColor(stack, "colorRedInner") / 255.0f;
        float beam2g = (float)MiningProperties.getColor(stack, "colorGreenInner") / 255.0f;
        float beam2b = (float)MiningProperties.getColor(stack, "colorBlueInner") / 255.0f;
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        MatrixStack matrix = event.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        matrix.func_227861_a_(from.field_72450_a, from.field_72448_b, from.field_72449_c);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)ticks, (float)(-player.field_70177_z), (float)(-player.field_70126_B))));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_219799_g((float)ticks, (float)player.field_70125_A, (float)player.field_70127_C)));
        MatrixStack.Entry matrixstack$entry = matrix.func_227866_c_();
        Matrix3f matrixNormal = matrixstack$entry.func_227872_b_();
        Matrix4f positionMatrix = matrixstack$entry.func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(MyRenderType.LASER_MAIN_ADDITIVE);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, additiveThickness, activeHand, distance, 0.5, 1.0, ticks, r, g, b, 0.7f);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, thickness, activeHand, distance, v, v + distance * 1.5, ticks, r, g, b, 1.0f);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_CORE);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, thickness / 2.0f, activeHand, distance, v, v + distance * 1.5, ticks, beam2r, beam2g, beam2b, 1.0f);
        matrix.func_227865_b_();
        buffer.func_228461_a_();
    }

    private static float calculateLaserFlickerModifier(long gameTime) {
        return 0.9f + 0.1f * MathHelper.func_76126_a((float)((float)gameTime * 0.99f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.3f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.1f));
    }

    private static void drawBeam(ItemStack stack, double xOffset, double yOffset, double zOffset, IVertexBuilder builder, Matrix4f positionMatrix, Matrix3f matrixNormalIn, float thickness, Hand hand, double distance, double v1, double v2, float ticks, float r, float g, float b, float alpha) {
        boolean isFancy = stack.func_77973_b().equals(ModItems.MININGGADGET_FANCY.get());
        boolean isSimple = stack.func_77973_b().equals(ModItems.MININGGADGET_SIMPLE.get());
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        vector3f.func_229188_a_(matrixNormalIn);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (Minecraft.func_71410_x().field_71474_y.field_186715_A != HandSide.RIGHT) {
            hand = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        }
        float startXOffset = -0.2f;
        float startYOffset = -0.108f;
        float startZOffset = 0.6f;
        if (isFancy) {
            startYOffset += 0.02f;
        }
        if (isSimple) {
            startXOffset -= 0.02f;
            startZOffset += 0.05f;
            startYOffset -= 0.005f;
        }
        startZOffset += 1.0f - player.func_175156_o();
        if (hand == Hand.OFF_HAND) {
            startYOffset = -0.12f;
            startXOffset = 0.25f;
        }
        float f = MathHelper.func_219799_g((float)ticks, (float)player.field_70127_C, (float)player.field_70125_A) - MathHelper.func_219799_g((float)ticks, (float)player.field_71164_i, (float)player.field_71155_g);
        float f1 = MathHelper.func_219799_g((float)ticks, (float)player.field_70126_B, (float)player.field_70177_z) - MathHelper.func_219799_g((float)ticks, (float)player.field_71163_h, (float)player.field_71154_f);
        Vector4f vec1 = new Vector4f(startXOffset += f1 / 750.0f, -thickness + (startYOffset += f / 750.0f), startZOffset, 1.0f);
        vec1.func_229372_a_(positionMatrix);
        Vector4f vec2 = new Vector4f((float)xOffset, -thickness + (float)yOffset, (float)distance + (float)zOffset, 1.0f);
        vec2.func_229372_a_(positionMatrix);
        Vector4f vec3 = new Vector4f((float)xOffset, thickness + (float)yOffset, (float)distance + (float)zOffset, 1.0f);
        vec3.func_229372_a_(positionMatrix);
        Vector4f vec4 = new Vector4f(startXOffset, thickness + startYOffset, startZOffset, 1.0f);
        vec4.func_229372_a_(positionMatrix);
        if (hand == Hand.MAIN_HAND) {
            builder.func_225588_a_(vec4.func_195910_a(), vec4.func_195913_b(), vec4.func_195914_c(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec3.func_195910_a(), vec3.func_195913_b(), vec3.func_195914_c(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec2.func_195910_a(), vec2.func_195913_b(), vec2.func_195914_c(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec1.func_195910_a(), vec1.func_195913_b(), vec1.func_195914_c(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec1.func_195910_a(), vec1.func_195913_b(), vec1.func_195914_c(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec2.func_195910_a(), vec2.func_195913_b(), vec2.func_195914_c(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec3.func_195910_a(), vec3.func_195913_b(), vec3.func_195914_c(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec4.func_195910_a(), vec4.func_195913_b(), vec4.func_195914_c(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
        } else {
            builder.func_225588_a_(vec1.func_195910_a(), vec1.func_195913_b(), vec1.func_195914_c(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec2.func_195910_a(), vec2.func_195913_b(), vec2.func_195914_c(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec3.func_195910_a(), vec3.func_195913_b(), vec3.func_195914_c(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec4.func_195910_a(), vec4.func_195913_b(), vec4.func_195914_c(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec4.func_195910_a(), vec4.func_195913_b(), vec4.func_195914_c(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec3.func_195910_a(), vec3.func_195913_b(), vec3.func_195914_c(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec2.func_195910_a(), vec2.func_195913_b(), vec2.func_195914_c(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            builder.func_225588_a_(vec1.func_195910_a(), vec1.func_195913_b(), vec1.func_195914_c(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.field_229196_a_, 0xF000F0, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
        }
    }
}

