/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class EntityFilter
implements Predicate<Entity> {
    private static final Pattern ELEMENT_DIVIDER = Pattern.compile(";");
    private static final Pattern ELEMENT_SUBDIVIDER = Pattern.compile("[(),]");
    private static final Map<String, Predicate<Entity>> ENTITY_PREDICATES = ImmutableMap.builder().put((Object)"mob", e -> e instanceof IMob && (!(e instanceof TameableEntity) || !((TameableEntity)e).func_70909_n())).put((Object)"animal", e -> e instanceof AnimalEntity).put((Object)"living", e -> e instanceof LivingEntity).put((Object)"player", e -> e instanceof PlayerEntity).put((Object)"item", e -> e instanceof ItemEntity).put((Object)"drone", e -> e instanceof EntityDrone).put((Object)"boat", e -> e instanceof BoatEntity).put((Object)"minecart", e -> e instanceof AbstractMinecartEntity).put((Object)"painting", e -> e instanceof PaintingEntity).put((Object)"orb", e -> e instanceof ExperienceOrbEntity).build();
    private final List<EntityMatcher> matchers = new ArrayList<EntityMatcher>();
    private final boolean sense;
    private final String rawFilter;
    private static final Set<String> DYE_COLORS = new HashSet<String>();

    public EntityFilter(String filter) {
        if (filter.startsWith("!")) {
            filter = filter.substring(1);
            this.sense = false;
        } else {
            this.sense = true;
        }
        this.rawFilter = filter;
        if (!filter.isEmpty()) {
            Arrays.stream(ELEMENT_DIVIDER.split(filter)).map(x$0 -> new EntityMatcher((String)x$0)).forEach(this.matchers::add);
        }
    }

    public static <T extends IProgWidget & IEntityProvider> EntityFilter fromProgWidget(T widget, boolean whitelist) {
        if (widget.getParameters().size() > 1) {
            int pos = ((IEntityProvider)widget).getEntityFilterPosition();
            IProgWidget w = widget.getConnectedParameters()[whitelist ? pos : widget.getParameters().size() + pos];
            if (w instanceof ProgWidgetText) {
                ArrayList<String> l = new ArrayList<String>();
                while (w instanceof ProgWidgetText) {
                    String str = ((ProgWidgetText)w).string;
                    Validate.isTrue((!str.startsWith("!") ? 1 : 0) != 0, (String)"'!' negation can't be used here (put blacklist filters on left of widget)", (Object[])new Object[0]);
                    l.add(str);
                    w = w.getConnectedParameters()[0];
                }
                return new EntityFilter(Strings.join(l, (String)";"));
            }
        }
        return whitelist ? ConstantEntityFilter.ALLOW : ConstantEntityFilter.DENY;
    }

    public static EntityFilter fromString(String s) {
        try {
            return new EntityFilter(s);
        }
        catch (Exception e) {
            Log.warning("ignoring invalid filter: " + s, new Object[0]);
            return null;
        }
    }

    public static EntityFilter allow() {
        return ConstantEntityFilter.ALLOW;
    }

    public static EntityFilter deny() {
        return ConstantEntityFilter.DENY;
    }

    public String toString() {
        return this.sense ? this.rawFilter : "!" + this.rawFilter;
    }

    @Override
    public boolean test(Entity entity) {
        if (this.matchers.isEmpty()) {
            return true;
        }
        for (EntityMatcher m : this.matchers) {
            if (!m.test(entity)) continue;
            return this.sense;
        }
        return !this.sense;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\").append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    static /* synthetic */ Set access$000() {
        return DYE_COLORS;
    }

    static {
        for (DyeColor d : DyeColor.values()) {
            DYE_COLORS.add(d.func_176762_d());
        }
    }

    public static class ConstantEntityFilter
    extends EntityFilter {
        static final ConstantEntityFilter ALLOW = new ConstantEntityFilter(true);
        static final ConstantEntityFilter DENY = new ConstantEntityFilter(false);
        private final boolean allow;

        private ConstantEntityFilter(boolean allow) {
            super("");
            this.allow = allow;
        }

        @Override
        public boolean test(Entity entity) {
            return this.allow;
        }
    }

    private static class ModifierEntry
    implements Predicate<Entity> {
        final Modifier modifier;
        final String value;
        final boolean sense;

        private ModifierEntry(Modifier modifier, String value, boolean sense) {
            this.modifier = modifier;
            this.value = value;
            this.sense = sense;
        }

        @Override
        public boolean test(Entity e) {
            return this.modifier.test(e, this.value) == this.sense;
        }
    }

    private static class EntityMatcher
    implements Predicate<Entity> {
        private final Pattern regex;
        private final Predicate<Entity> entityPredicate;
        private final List<ModifierEntry> modifiers = new ArrayList<ModifierEntry>();

        private EntityMatcher(String element) {
            String[] splits = ELEMENT_SUBDIVIDER.split(element);
            for (int i = 0; i < splits.length; ++i) {
                splits[i] = splits[i].trim();
            }
            if (splits[0].startsWith("@")) {
                String sub = splits[0].substring(1);
                if (StringUtils.countMatches((CharSequence)element, (CharSequence)"(") != StringUtils.countMatches((CharSequence)element, (CharSequence)")")) {
                    throw new IllegalArgumentException("Mismatched opening/closing braces");
                }
                this.entityPredicate = (Predicate)ENTITY_PREDICATES.get(sub);
                Validate.isTrue((this.entityPredicate != null ? 1 : 0) != 0, (String)("Unknown entity type specifier: @" + sub), (Object[])new Object[0]);
                this.regex = null;
            } else {
                this.entityPredicate = null;
                this.regex = Pattern.compile(EntityFilter.wildcardToRegex(splits[0]), 2);
            }
            for (int i = 1; i < splits.length; ++i) {
                Modifier modifier;
                String[] parts = splits[i].split("=");
                Validate.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)("Invalid modifier syntax: " + splits[i]), (Object[])new Object[0]);
                boolean sense = true;
                if (parts[0].endsWith("!")) {
                    parts[0] = parts[0].substring(0, parts[0].length() - 1);
                    sense = false;
                }
                try {
                    modifier = Modifier.valueOf(parts[0].toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unknown modifier: " + parts[0]);
                }
                if (!modifier.isValid(parts[1])) {
                    throw new IllegalArgumentException(String.format("Invalid value '%s' for modifier '%s'. Valid values: %s", parts[1], parts[0], modifier.displayValidOptions()));
                }
                this.modifiers.add(new ModifierEntry(modifier, parts[1], sense));
            }
        }

        @Override
        public boolean test(Entity entity) {
            boolean ok = false;
            if (this.entityPredicate != null) {
                ok = this.entityPredicate.test(entity);
            } else if (this.regex != null) {
                Matcher m = this.regex.matcher(entity.func_200200_C_().getString());
                ok = m.matches();
            }
            return ok && this.modifiers.stream().allMatch(modifierEntry -> modifierEntry.test(entity));
        }
    }

    private static enum Modifier implements BiPredicate<Entity, String>
    {
        AGE((Set<String>)ImmutableSet.of((Object)"adult", (Object)"baby"), Modifier::testAge),
        BREEDABLE((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), Modifier::testBreedable),
        SHEARABLE((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no"), Modifier::testShearable),
        COLOR(EntityFilter.access$000(), Modifier::hasColor),
        HOLDING(item -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item)), "any valid item registry name, e.g. 'minecraft:cobblestone'", (entity, val) -> Modifier.isHeldItem(entity, val, true)),
        HOLDING_OFFHAND(item -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item)), "any valid item registry name, e.g. 'minecraft:cobblestone'", (entity, val) -> Modifier.isHeldItem(entity, val, false));

        private final Set<String> validationSet;
        private final Predicate<String> validationPredicate;
        private final String valText;
        private final BiPredicate<Entity, String> testPredicate;

        private Modifier(Predicate<String> validationPredicate, String valText, BiPredicate<Entity, String> testPredicate) {
            this.validationPredicate = validationPredicate;
            this.valText = valText;
            this.testPredicate = testPredicate;
            this.validationSet = Collections.emptySet();
        }

        private Modifier(Set<String> validationSet, BiPredicate<Entity, String> testPredicate) {
            this.validationPredicate = null;
            this.valText = "";
            this.testPredicate = testPredicate;
            this.validationSet = validationSet;
        }

        private static boolean testShearable(Entity entity, String val) {
            return entity instanceof IForgeShearable && ((IForgeShearable)entity).isShearable(new ItemStack((IItemProvider)Items.field_151097_aZ), entity.func_130014_f_(), entity.func_233580_cy_()) ? val.equalsIgnoreCase("yes") : val.equalsIgnoreCase("no");
        }

        private static boolean testBreedable(Entity entity, String val) {
            return entity instanceof AnimalEntity && (((AnimalEntity)entity).func_70874_b() == 0 ? val.equalsIgnoreCase("yes") : val.equalsIgnoreCase("no"));
        }

        private static boolean testAge(Entity entity, String val) {
            return entity instanceof AgeableEntity && (((AgeableEntity)entity).func_70874_b() >= 0 ? val.equalsIgnoreCase("adult") : val.equalsIgnoreCase("baby"));
        }

        boolean isValid(String s) {
            return this.validationPredicate == null ? this.validationSet.contains(s) : this.validationPredicate.test(s);
        }

        @Override
        public boolean test(Entity entity, String val) {
            return this.testPredicate.test(entity, val);
        }

        public String displayValidOptions() {
            return this.validationSet.isEmpty() ? this.valText : Strings.join(this.validationSet, (String)",");
        }

        private static boolean hasColor(Entity entity, String val) {
            if (entity instanceof SheepEntity) {
                return ((SheepEntity)entity).func_175509_cj().func_176762_d().equalsIgnoreCase(val);
            }
            if (entity instanceof WolfEntity) {
                return ((WolfEntity)entity).func_175546_cu().func_176762_d().equalsIgnoreCase(val);
            }
            if (entity instanceof CatEntity) {
                return ((CatEntity)entity).func_213414_ei().func_176762_d().equalsIgnoreCase(val);
            }
            return false;
        }

        private static boolean isHeldItem(Entity entity, String name, boolean mainHand) {
            if (entity instanceof LivingEntity) {
                if (!name.contains(":")) {
                    name = "minecraft:" + name;
                }
                ItemStack stack = mainHand ? ((LivingEntity)entity).func_184614_ca() : ((LivingEntity)entity).func_184592_cb();
                return stack.func_77973_b().getRegistryName() != null && stack.func_77973_b().getRegistryName().toString().equals(name);
            }
            return false;
        }
    }
}

