/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerProgrammer;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLabel;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class TileEntityProgrammer
extends TileEntityTickableBase
implements IGUITextFieldSensitive,
INamedContainerProvider {
    private static final int PROGRAM_SLOT = 0;
    private static final int INVENTORY_SIZE = 1;
    public final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final ProgrammerItemHandler inventory = new ProgrammerItemHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public double translatedX;
    public double translatedY;
    public int zoomState;
    public boolean showInfo = true;
    public boolean showFlow = true;
    @GuiSynced
    public boolean recentreStartPiece = false;
    @GuiSynced
    public boolean canUndo;
    @GuiSynced
    public boolean canRedo;
    @GuiSynced
    public boolean programOnInsert;
    @GuiSynced
    public int availablePuzzlePieces;
    private ListNBT history = new ListNBT();
    private int historyIndex;

    public TileEntityProgrammer() {
        super((TileEntityType)ModTileEntities.PROGRAMMER.get());
        this.saveToHistory();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.programOnInsert = tag.func_74764_b("redstoneMode") ? tag.func_74762_e("redstoneMode") == 1 : tag.func_74767_n("ProgramOnInsert");
        this.history = tag.func_150295_c("history", 10);
        if (this.history.size() == 0) {
            this.saveToHistory();
        }
        this.readProgWidgetsFromNBT(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        tag.func_218657_a("history", (INBT)this.history);
        tag.func_74757_a("ProgramOnInsert", this.programOnInsert);
        this.writeProgWidgetsToNBT(tag);
        return tag;
    }

    public List<IProgWidget> mergeWidgetsFromNBT(CompoundNBT tag) {
        List<IProgWidget> mergedWidgets = TileEntityProgrammer.getWidgetsFromNBT(tag);
        ArrayList<IProgWidget> result = new ArrayList<IProgWidget>(this.progWidgets);
        if (!this.progWidgets.isEmpty() && !mergedWidgets.isEmpty()) {
            PuzzleExtents extents1 = this.getPuzzleExtents(this.progWidgets);
            PuzzleExtents extents2 = this.getPuzzleExtents(mergedWidgets);
            for (IProgWidget w2 : mergedWidgets) {
                w2.setX(w2.getX() - extents2.getX() + extents1.getX() + extents1.getWidth() + 10);
                w2.setY(w2.getY() - extents2.getY() + extents1.getY());
            }
        }
        mergedWidgets.forEach(w -> {
            if (w instanceof ProgWidgetStart) {
                ProgWidgetLabel lab = new ProgWidgetLabel();
                lab.setX(w.getX());
                lab.setY(w.getY());
                result.add(lab);
                ProgWidgetText text = new ProgWidgetText();
                text.string = "Merge #" + this.field_145850_b.func_82737_E();
                text.setX(lab.getX() + lab.getWidth() / 2);
                text.setY(lab.getY());
                result.add(text);
            } else {
                result.add((IProgWidget)w);
            }
        });
        return result;
    }

    private PuzzleExtents getPuzzleExtents(List<IProgWidget> widgets) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (IProgWidget w : widgets) {
            minX = Math.min(minX, w.getX());
            maxX = Math.max(maxX, w.getX() + w.getWidth());
            minY = Math.min(minY, w.getY());
            maxY = Math.max(maxY, w.getY() + w.getHeight());
        }
        return new PuzzleExtents(minX, minY, maxX - minX, maxY - minY);
    }

    public void readProgWidgetsFromNBT(CompoundNBT tag) {
        this.progWidgets.clear();
        this.progWidgets.addAll(TileEntityProgrammer.getWidgetsFromNBT(tag));
        TileEntityProgrammer.updatePuzzleConnections(this.progWidgets);
    }

    public CompoundNBT writeProgWidgetsToNBT(CompoundNBT tag) {
        TileEntityProgrammer.putWidgetsToNBT(this.progWidgets, tag);
        return tag;
    }

    public static List<IProgWidget> getWidgetsFromNBT(CompoundNBT tag) {
        ArrayList<IProgWidget> newWidgets = new ArrayList<IProgWidget>();
        ListNBT widgetTags = tag.func_150295_c("pneumaticcraft:progWidgets", 10);
        for (int i = 0; i < widgetTags.size(); ++i) {
            IProgWidget addedWidget = ProgWidget.fromNBT(widgetTags.func_150305_b(i));
            if (addedWidget == null) continue;
            if (addedWidget.isAvailable()) {
                newWidgets.add(addedWidget);
                continue;
            }
            Log.warning("ignoring unavailable widget type: " + addedWidget.getType(), new Object[0]);
        }
        return newWidgets;
    }

    public static CompoundNBT putWidgetsToNBT(List<IProgWidget> widgets, CompoundNBT tag) {
        ListNBT widgetTags = new ListNBT();
        for (IProgWidget widget : widgets) {
            CompoundNBT widgetTag = new CompoundNBT();
            widget.writeToNBT(widgetTag);
            widgetTags.add(widgetTags.size(), (INBT)widgetTag);
        }
        tag.func_218657_a("pneumaticcraft:progWidgets", (INBT)widgetTags);
        return tag;
    }

    public static void updatePuzzleConnections(List<IProgWidget> progWidgets) {
        List<ProgWidgetType<?>> parameters;
        for (IProgWidget widget : progWidgets) {
            widget.setParent(null);
            parameters = widget.getParameters();
            for (int i = 0; i < parameters.size() * 2; ++i) {
                widget.setParameter(i, null);
            }
            if (!widget.hasStepOutput()) continue;
            widget.setOutputWidget(null);
        }
        for (IProgWidget checkedWidget : progWidgets) {
            parameters = checkedWidget.getParameters();
            if (!parameters.isEmpty()) {
                for (IProgWidget widget : progWidgets) {
                    if (widget == checkedWidget || checkedWidget.getX() + checkedWidget.getWidth() / 2 != widget.getX()) continue;
                    for (int i = 0; i < parameters.size(); ++i) {
                        if (!checkedWidget.canSetParameter(i) || parameters.get(i) != widget.returnType() || checkedWidget.getY() + i * 11 != widget.getY()) continue;
                        checkedWidget.setParameter(i, widget);
                        widget.setParent(checkedWidget);
                    }
                }
            }
            if (!checkedWidget.hasStepOutput()) continue;
            for (IProgWidget widget : progWidgets) {
                if (!widget.hasStepInput() || widget.getX() != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + checkedWidget.getHeight() / 2) continue;
                checkedWidget.setOutputWidget(widget);
            }
        }
        for (IProgWidget checkedWidget : progWidgets) {
            if (checkedWidget.returnType() != null) continue;
            parameters = checkedWidget.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!checkedWidget.canSetParameter(i)) continue;
                for (IProgWidget widget : progWidgets) {
                    if (parameters.get(i) != widget.returnType() || widget == checkedWidget || widget.getX() + widget.getWidth() / 2 != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + i * 11) continue;
                    IProgWidget root = widget;
                    while (root.getParent() != null) {
                        root = root.getParent();
                    }
                    checkedWidget.setParameter(i + parameters.size(), root);
                }
            }
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        switch (tag) {
            case "program_when": {
                this.programOnInsert = !this.programOnInsert;
                break;
            }
            case "import": {
                this.tryImport(shiftHeld);
                break;
            }
            case "export": {
                this.tryProgramDrone((PlayerEntity)player);
                break;
            }
            case "undo": {
                this.undo();
                break;
            }
            case "redo": {
                this.redo();
            }
        }
        this.sendDescriptionPacket();
    }

    @Nonnull
    public ItemStack getItemInProgrammingSlot() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public void setText(int textFieldID, String text) {
        ItemStack stack = this.inventory.getStackInSlot(0).func_77946_l();
        if (textFieldID == 0 && !stack.func_190926_b()) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(text));
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.inventory.getStackInSlot(0).func_200301_q().getString();
    }

    private void tryImport(boolean merge) {
        CompoundNBT nbt;
        ItemStack stack = this.inventory.getStackInSlot(0);
        CompoundNBT compoundNBT = nbt = stack.func_190926_b() ? null : stack.func_77978_p();
        if (nbt != null) {
            List<IProgWidget> widgets = merge ? this.mergeWidgetsFromNBT(nbt) : TileEntityProgrammer.getWidgetsFromNBT(nbt);
            this.setProgWidgets(widgets, null);
        } else if (!merge) {
            this.setProgWidgets(Collections.emptyList(), null);
        }
    }

    public void tryProgramDrone(PlayerEntity player) {
        if (this.inventory.getStackInSlot(0).func_77973_b() instanceof IProgrammable) {
            if (player == null || !player.func_184812_l_()) {
                int required = this.getRequiredPuzzleCount();
                if (required > 0) {
                    if (!this.takePuzzlePieces(player, true)) {
                        if (player instanceof ServerPlayerEntity) {
                            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundCategory.BLOCKS, this.func_174877_v(), 1.0f, 1.5f, false), (ServerPlayerEntity)player);
                        }
                        return;
                    }
                    this.takePuzzlePieces(player, false);
                } else if (required < 0) {
                    this.returnPuzzlePieces(player, -required);
                }
            }
            ItemStack stack = this.inventory.getStackInSlot(0);
            this.writeProgWidgetsToNBT(stack.func_196082_o());
            if (player instanceof ServerPlayerEntity) {
                NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), SoundCategory.BLOCKS, this.func_174877_v(), 1.0f, 1.0f, false), (ServerPlayerEntity)player);
                AdvancementTriggers.PROGRAM_DRONE.trigger((ServerPlayerEntity)player);
            }
        }
    }

    private void returnPuzzlePieces(@Nullable PlayerEntity player, int count) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.PROGRAMMING_PUZZLE.get());
        for (Direction d : DirectionUtil.VALUES) {
            TileEntity te = this.getCachedNeighbor(d);
            if (te != null) {
                while (count > 0) {
                    int toInsert = Math.min(count, stack.func_77976_d());
                    int inserted = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d()).map(h -> {
                        ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)toInsert), (boolean)false);
                        return toInsert - excess.func_190916_E();
                    }).orElse(0);
                    if (inserted == 0) break;
                    count -= inserted;
                }
            }
            if (count > 0) continue;
            return;
        }
        while (count > 0) {
            int size = Math.min(count, stack.func_77976_d());
            if (player != null) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
            } else {
                PneumaticCraftUtils.dropItemOnGround(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), this.func_145831_w(), this.func_174877_v());
            }
            count -= size;
        }
    }

    public int getRequiredPuzzleCount() {
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        if (!stackInSlot.func_190926_b() && ((IProgrammable)stackInSlot.func_77973_b()).usesPieces(stackInSlot)) {
            List<IProgWidget> inDrone = TileEntityProgrammer.getProgWidgets(stackInSlot);
            int dronePieces = (int)inDrone.stream().filter(p -> !p.freeToUse()).count();
            int required = (int)this.progWidgets.stream().filter(p -> !p.freeToUse()).count();
            return (required - dronePieces) * stackInSlot.func_190916_E();
        }
        return 0;
    }

    public static List<IProgWidget> getProgWidgets(ItemStack iStack) {
        if (NBTUtils.hasTag(iStack, "pneumaticcraft:progWidgets")) {
            return TileEntityProgrammer.getWidgetsFromNBT(iStack.func_77978_p());
        }
        return new ArrayList<IProgWidget>();
    }

    private boolean takePuzzlePieces(@Nullable PlayerEntity player, boolean simulate) {
        int required = this.getRequiredPuzzleCount();
        if (required <= 0) {
            return true;
        }
        int found = 0;
        if (player != null && (found += this.extractPuzzlePieces((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), required, simulate)) >= required) {
            return true;
        }
        for (Direction d : DirectionUtil.VALUES) {
            TileEntity te = this.getCachedNeighbor(d);
            if (te == null) continue;
            int r = required - found;
            if ((found += te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d()).map(h -> this.extractPuzzlePieces((IItemHandler)h, r, simulate)).orElse(0).intValue()) < required) continue;
            return true;
        }
        return false;
    }

    private int extractPuzzlePieces(IItemHandler handler, int max, boolean simulate) {
        int n = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extracted;
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.func_77973_b() != ModItems.PROGRAMMING_PUZZLE.get() || (n += (extracted = handler.extractItem(i, Math.min(max - n, stackInSlot.func_77976_d()), simulate)).func_190916_E()) < max) continue;
            return n;
        }
        return n;
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IVariableWidget)) continue;
            ((IVariableWidget)((Object)widget)).addVariables(variables);
        }
        variables.remove("");
        return variables;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && (this.field_145850_b.func_82737_E() & 0xFL) == 0L && this.countPlayersUsing() > 0) {
            int total = 0;
            for (Direction dir : DirectionUtil.VALUES) {
                TileEntity te = this.getCachedNeighbor(dir);
                if (te == null) continue;
                total += IOHelper.countItems((LazyOptional<IItemHandler>)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()), stack -> stack.func_77973_b() == ModItems.PROGRAMMING_PUZZLE.get());
            }
            this.availablePuzzlePieces = total;
        }
    }

    public void previewArea(IProgWidget progWidget) {
        if (progWidget == null) {
            AreaRenderManager.getInstance().removeHandlers(this);
        } else if (progWidget instanceof IAreaProvider) {
            HashSet<BlockPos> area = new HashSet<BlockPos>();
            ((IAreaProvider)((Object)progWidget)).getArea(area);
            AreaRenderManager.getInstance().showArea(area, -1878982912, (TileEntity)this);
        }
    }

    private void saveToHistory() {
        CompoundNBT tag = new CompoundNBT();
        this.writeProgWidgetsToNBT(tag);
        if (this.history.size() == 0 || !this.history.func_150305_b(this.historyIndex).equals((Object)tag)) {
            while (this.history.size() > this.historyIndex + 1) {
                this.history.remove(this.historyIndex + 1);
            }
            this.history.add((Object)tag);
            if (this.history.size() > 20) {
                this.history.remove(0);
            }
            this.historyIndex = this.history.size() - 1;
            this.updateUndoRedoState();
        }
    }

    private void undo() {
        if (this.canUndo) {
            --this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.func_150305_b(this.historyIndex));
            this.updateUndoRedoState();
            this.syncToClient(null);
        }
    }

    private void redo() {
        if (this.canRedo) {
            ++this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.func_150305_b(this.historyIndex));
            this.updateUndoRedoState();
            this.syncToClient(null);
        }
    }

    private void updateUndoRedoState() {
        this.canUndo = this.historyIndex > 0;
        this.canRedo = this.historyIndex < this.history.size() - 1;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerProgrammer(i, playerInventory, this.func_174877_v());
    }

    public void setProgWidgets(List<IProgWidget> widgets, PlayerEntity player) {
        this.progWidgets.clear();
        this.progWidgets.addAll(widgets);
        TileEntityProgrammer.updatePuzzleConnections(this.progWidgets);
        if (!this.field_145850_b.field_72995_K) {
            this.saveToHistory();
            this.syncToClient(player);
        }
    }

    private void syncToClient(PlayerEntity updatingPlayer) {
        if (!this.func_145831_w().field_72995_K) {
            List players = this.field_145850_b.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(5.0));
            for (ServerPlayerEntity player : players) {
                if (player == updatingPlayer || !(player.field_71070_bA instanceof ContainerProgrammer)) continue;
                NetworkHandler.sendToPlayer(new PacketProgrammerUpdate(this), player);
            }
        }
    }

    private static class PuzzleExtents {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        PuzzleExtents(int xIn, int yIn, int widthIn, int heightIn) {
            this.x = xIn;
            this.y = yIn;
            this.width = widthIn;
            this.height = heightIn;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean contains(int x, int y) {
            return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
        }
    }

    private class ProgrammerItemHandler
    extends BaseItemStackHandler {
        ProgrammerItemHandler() {
            super(TileEntityProgrammer.this, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TileEntityProgrammer.this.programOnInsert && slot == 0 && !this.getStackInSlot(slot).func_190926_b() && !this.te.func_145831_w().field_72995_K) {
                TileEntityProgrammer.this.tryProgramDrone(null);
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof IProgrammable && ((IProgrammable)itemStack.func_77973_b()).canProgram(itemStack);
        }
    }
}

