/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberGlass;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberValve;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerPressureChamberValve;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberWall;
import me.desht.pneumaticcraft.common.util.CountedItemStacks;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.SizeLimitedItemHandlerWrapper;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityPressureChamberValve
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IAirListener,
INamedContainerProvider {
    private static final int CHAMBER_INV_SIZE = 18;
    private static final int OUTPUT_INV_SIZE = 9;
    @DescSynced
    public int multiBlockX;
    @DescSynced
    public int multiBlockY;
    @DescSynced
    public int multiBlockZ;
    @DescSynced
    public int multiBlockSize;
    @DescSynced
    public boolean hasGlass;
    @DescSynced
    private float roundedPressure;
    @GuiSynced
    public boolean isValidRecipeInChamber;
    @GuiSynced
    public boolean isSufficientPressureInChamber;
    @GuiSynced
    public float recipePressure;
    private final ItemStackHandler itemsInChamber = new ChamberStackHandler();
    final ItemStackHandler craftedItems = new OutputStackHandler();
    @DescSynced
    final CombinedInvWrapper allItems = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemsInChamber, this.craftedItems});
    public final List<ItemStack> renderedItems = new ArrayList<ItemStack>();
    public List<TileEntityPressureChamberValve> accessoryValves;
    private final List<BlockPos> nbtValveList;
    private final List<ApplicableRecipe> applicableRecipes = new ArrayList<ApplicableRecipe>();
    private boolean recipeRecalcNeeded = true;
    private long lastSoundTick;
    private int nParticles;
    private boolean triedRebuild;
    private int savedVolume = 0;

    public TileEntityPressureChamberValve() {
        super((TileEntityType)ModTileEntities.PRESSURE_CHAMBER_VALVE.get(), 5.0f, 7.0f, 16000, 4);
        this.accessoryValves = new ArrayList<TileEntityPressureChamberValve>();
        this.nbtValveList = new ArrayList<BlockPos>();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.func_176740_k() == this.getRotation().func_176740_k();
    }

    @Override
    public List<IAirHandlerMachine> addConnectedPneumatics(List<IAirHandlerMachine> airHandlers) {
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                if (valve == this) continue;
                airHandlers.add(valve.airHandler);
            }
        }
        return airHandlers;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            this.checkForAirLeak();
        }
        if (this.multiBlockSize != 0 && !this.func_145831_w().field_72995_K) {
            this.roundedPressure = (float)((int)(this.getPressure() * 4.0f)) / 4.0f;
            if (this.recipeRecalcNeeded) {
                this.isValidRecipeInChamber = false;
                this.isSufficientPressureInChamber = false;
                this.recipePressure = Float.MAX_VALUE;
                this.applicableRecipes.clear();
                SizeLimitedItemHandlerWrapper h = new SizeLimitedItemHandlerWrapper((IItemHandler)this.itemsInChamber);
                if (h.getSlots() > 0) {
                    PneumaticCraftRecipeType.PRESSURE_CHAMBER.stream(this.field_145850_b).forEach(recipe -> {
                        Collection<Integer> slots = recipe.findIngredients(h);
                        if (!slots.isEmpty()) {
                            this.applicableRecipes.add(new ApplicableRecipe((PressureChamberRecipe)recipe, slots));
                        }
                    });
                }
                this.isValidRecipeInChamber = !this.applicableRecipes.isEmpty();
                this.recipeRecalcNeeded = !this.isValidRecipeInChamber && this.coalesceItems();
            }
            this.processApplicableRecipes();
            if (this.getPressure() > 1.0f) {
                this.handleEntitiesInChamber();
            }
        }
        if (this.func_145831_w().field_72995_K && this.hasGlass && this.isPrimaryValve() && (double)this.roundedPressure > 0.2 && ClientUtils.getClientPlayer().func_70092_e((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) < 256.0) {
            for (int i = 0; i < this.nParticles; ++i) {
                double posX = (double)this.multiBlockX + 1.0 + this.func_145831_w().field_73012_v.nextDouble() * ((double)this.multiBlockSize - 2.0);
                double posY = (double)this.multiBlockY + 1.5 + this.func_145831_w().field_73012_v.nextDouble() * ((double)this.multiBlockSize - 2.5);
                double posZ = (double)this.multiBlockZ + 1.0 + this.func_145831_w().field_73012_v.nextDouble() * ((double)this.multiBlockSize - 2.0);
                this.func_145831_w().func_195594_a((IParticleData)AirParticleData.NORMAL, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean coalesceItems() {
        CountedItemStacks count = new CountedItemStacks((IItemHandler)this.itemsInChamber);
        if (!count.canCoalesce()) {
            return false;
        }
        NonNullList<ItemStack> coalesced = count.coalesce();
        for (int i = 0; i < this.itemsInChamber.getSlots(); ++i) {
            if (i < coalesced.size()) {
                this.itemsInChamber.setStackInSlot(i, (ItemStack)coalesced.get(i));
                continue;
            }
            this.itemsInChamber.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return true;
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.doPostNBTSetup();
    }

    private void doPostNBTSetup() {
        if (!this.nbtValveList.isEmpty()) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state.func_177230_c() instanceof BlockPressureChamberValve) {
                this.func_145831_w().func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)BlockPressureChamberValve.FORMED, (Comparable)Boolean.valueOf(this.isPrimaryValve())), 2);
            }
            this.accessoryValves.clear();
            for (BlockPos valve : this.nbtValveList) {
                TileEntity te = this.func_145831_w().func_175625_s(valve);
                if (!(te instanceof TileEntityPressureChamberValve)) continue;
                this.accessoryValves.add((TileEntityPressureChamberValve)te);
            }
            if (this.isPrimaryValve()) {
                this.hasGlass = this.checkForGlass();
                this.sendDescriptionPacket();
            }
            this.nbtValveList.clear();
        }
    }

    private void checkForAirLeak() {
        TileEntityPressureChamberValve primaryValve;
        BitSet disconnected = new BitSet(6);
        switch (this.getRotation().func_176740_k()) {
            case X: {
                disconnected.set(Direction.WEST.func_176745_a());
                disconnected.set(Direction.EAST.func_176745_a());
                break;
            }
            case Y: {
                disconnected.set(Direction.UP.func_176745_a());
                disconnected.set(Direction.DOWN.func_176745_a());
                break;
            }
            case Z: {
                disconnected.set(Direction.NORTH.func_176745_a());
                disconnected.set(Direction.SOUTH.func_176745_a());
            }
        }
        List<IAirHandlerMachine.Connection> l = this.airHandler.getConnectedAirHandlers(this);
        for (IAirHandlerMachine.Connection c : l) {
            if (c.getDirection() == null) continue;
            disconnected.clear(c.getDirection().func_176745_a());
        }
        if (this.accessoryValves.isEmpty() && !this.triedRebuild) {
            if (TileEntityPressureChamberValve.checkIfProperlyFormed(this.field_145850_b, this.field_174879_c, true)) {
                Log.warning("Rebuilt damaged pressure chamber multiblock: valve pos = " + this.field_174879_c, new Object[0]);
            }
            this.triedRebuild = true;
        }
        TileEntityPressureChamberValve tileEntityPressureChamberValve = primaryValve = this.accessoryValves.isEmpty() ? null : this.accessoryValves.get(this.accessoryValves.size() - 1);
        if (primaryValve != null) {
            switch (this.getRotation().func_176740_k()) {
                case X: {
                    if (primaryValve.multiBlockX == this.func_174877_v().func_177958_n()) {
                        disconnected.clear(Direction.EAST.func_176745_a());
                        break;
                    }
                    disconnected.clear(Direction.WEST.func_176745_a());
                    break;
                }
                case Y: {
                    if (primaryValve.multiBlockY == this.func_174877_v().func_177956_o()) {
                        disconnected.clear(Direction.UP.func_176745_a());
                        break;
                    }
                    disconnected.clear(Direction.DOWN.func_176745_a());
                    break;
                }
                case Z: {
                    if (primaryValve.multiBlockZ == this.func_174877_v().func_177952_p()) {
                        disconnected.clear(Direction.SOUTH.func_176745_a());
                        break;
                    }
                    disconnected.clear(Direction.NORTH.func_176745_a());
                }
            }
        }
        this.airHandler.setSideLeaking(disconnected.isEmpty() ? null : this.getRotation());
    }

    private void processApplicableRecipes() {
        for (ApplicableRecipe applicableRecipe : this.applicableRecipes) {
            boolean pressureOK;
            PressureChamberRecipe recipe = applicableRecipe.recipe;
            float requiredPressure = recipe.getCraftingPressure((IItemHandler)this.itemsInChamber, applicableRecipe.slots);
            boolean bl = pressureOK = requiredPressure <= this.getPressure() && requiredPressure > 0.0f || requiredPressure >= this.getPressure() && requiredPressure < 0.0f;
            if (Math.abs(requiredPressure) < Math.abs(this.recipePressure)) {
                this.recipePressure = requiredPressure;
            }
            if (!pressureOK) continue;
            this.isSufficientPressureInChamber = true;
            if (!this.giveOutput(recipe.craftRecipe((IItemHandler)this.itemsInChamber, applicableRecipe.slots, true), true) || !this.giveOutput(recipe.craftRecipe((IItemHandler)this.itemsInChamber, applicableRecipe.slots, false), false) || this.func_145831_w().func_82737_E() - this.lastSoundTick <= 5L) break;
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.7f, 0.8f);
            this.lastSoundTick = this.func_145831_w().func_82737_E();
            break;
        }
    }

    private void handleEntitiesInChamber() {
        AxisAlignedBB bbBox = new AxisAlignedBB((double)(this.multiBlockX + 1), (double)(this.multiBlockY + 1), (double)(this.multiBlockZ + 1), (double)(this.multiBlockX + this.multiBlockSize - 1), (double)(this.multiBlockY + this.multiBlockSize - 1), (double)(this.multiBlockZ + this.multiBlockSize - 1));
        List entities = this.func_145831_w().func_217357_a(LivingEntity.class, bbBox);
        for (LivingEntity entity : entities) {
            entity.func_70097_a(DamageSourcePneumaticCraft.PRESSURE, (float)((int)((double)this.getPressure() * 2.0)));
        }
    }

    private boolean checkForGlass() {
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    if (!(this.field_145850_b.func_180495_p((BlockPos)(mPos = mPos.func_181079_c(this.multiBlockX + x, this.multiBlockY + y, this.multiBlockZ + z))).func_177230_c() instanceof BlockPressureChamberGlass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean giveOutput(NonNullList<ItemStack> stacks, boolean simulate) {
        if (stacks.isEmpty()) {
            return false;
        }
        for (ItemStack stack : stacks) {
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)this.craftedItems, (ItemStack)(stack = stack.func_77946_l()), (boolean)simulate);
            if (result.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    ItemStack insertItemToChamber(ItemStack stack) {
        return ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack.func_77946_l(), (boolean)false);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.setupMultiBlock(tag.func_74762_e("multiBlockSize"), tag.func_74762_e("multiBlockX"), tag.func_74762_e("multiBlockY"), tag.func_74762_e("multiBlockZ"));
        ItemStackHandler handler = new ItemStackHandler();
        handler.deserializeNBT(tag.func_74775_l("itemsInChamber"));
        for (int i = 0; i < handler.getSlots() && i < 18; ++i) {
            this.itemsInChamber.setStackInSlot(i, handler.getStackInSlot(i));
        }
        ItemStackHandler outHandler = new ItemStackHandler();
        outHandler.deserializeNBT(tag.func_74775_l("craftedItems"));
        for (int i = 0; i < outHandler.getSlots() && i < 9; ++i) {
            this.craftedItems.setStackInSlot(i, outHandler.getStackInSlot(i));
        }
        ListNBT accList = tag.func_150295_c("Valves", 10);
        this.nbtValveList.clear();
        for (int i = 0; i < accList.size(); ++i) {
            CompoundNBT tagCompound = accList.func_150305_b(i);
            this.nbtValveList.add(NBTUtil.func_186861_c((CompoundNBT)tagCompound));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("multiBlockX", this.multiBlockX);
        tag.func_74768_a("multiBlockY", this.multiBlockY);
        tag.func_74768_a("multiBlockZ", this.multiBlockZ);
        tag.func_74768_a("multiBlockSize", this.multiBlockSize);
        tag.func_218657_a("itemsInChamber", (INBT)this.itemsInChamber.serializeNBT());
        tag.func_218657_a("craftedItems", (INBT)this.craftedItems.serializeNBT());
        ListNBT accList = this.accessoryValves.stream().map(valve -> NBTUtil.func_186859_a((BlockPos)valve.func_174877_v())).collect(Collectors.toCollection(ListNBT::new));
        tag.func_218657_a("Valves", (INBT)accList);
        return tag;
    }

    public void onMultiBlockBreak() {
        if (this.isPrimaryValve()) {
            Iterator<ItemStack> itemsInChamberIterator = new ItemStackHandlerIterable((IItemHandlerModifiable)this.allItems).iterator();
            while (itemsInChamberIterator.hasNext()) {
                ItemStack stack = itemsInChamberIterator.next();
                if (stack.func_190926_b()) continue;
                this.dropItemOnGround(stack);
                itemsInChamberIterator.remove();
            }
            this.invalidateMultiBlock();
        }
    }

    private void dropItemOnGround(ItemStack stack) {
        PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.func_145831_w(), (double)this.multiBlockX + (double)this.multiBlockSize / 2.0, (double)this.multiBlockY + 1.0, (double)this.multiBlockZ + (double)this.multiBlockSize / 2.0);
    }

    private void invalidateMultiBlock() {
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    TileEntity te = this.func_145831_w().func_175625_s(new BlockPos(x + this.multiBlockX, y + this.multiBlockY, z + this.multiBlockZ));
                    if (!(te instanceof TileEntityPressureChamberWall)) continue;
                    TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                    teWall.setCore(null);
                }
            }
        }
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                this.savedVolume = valve.airHandler.getVolume();
                float p = valve.getPressure();
                valve.setupMultiBlock(0, 0, 0, 0);
                valve.airHandler.addAir((int)(p * (float)valve.airHandler.getBaseVolume()) - valve.airHandler.getAir());
                if (valve != this) {
                    valve.accessoryValves.clear();
                    if (!this.func_145831_w().field_72995_K) {
                        valve.sendDescriptionPacket();
                    }
                }
                valve.func_70296_d();
            }
            this.accessoryValves.clear();
        }
        if (!this.func_145831_w().field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    private void setupMultiBlock(int size, int baseX, int baseY, int baseZ) {
        this.multiBlockSize = size;
        this.multiBlockX = baseX;
        this.multiBlockY = baseY;
        this.multiBlockZ = baseZ;
        int vol = 16000;
        this.airHandler.setBaseVolume(this.multiBlockSize > 3 ? vol * IntMath.pow((int)(this.multiBlockSize - 2), (int)3) : vol);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.nParticles = (int)(Math.min(1.0f, this.roundedPressure / this.getDangerPressure() * (float)(this.multiBlockSize - 2) * (float)(this.multiBlockSize - 2)) * 2.0f);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public static boolean checkIfProperlyFormed(World world, BlockPos pos) {
        return TileEntityPressureChamberValve.checkIfProperlyFormed(world, pos, false);
    }

    public static boolean checkIfProperlyFormed(World world, BlockPos pos, boolean forceRebuild) {
        for (int i = 3; i < 6; ++i) {
            if (!TileEntityPressureChamberValve.checkForShiftedCubeOfSize(i, world, pos, forceRebuild)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForShiftedCubeOfSize(int size, World world, BlockPos pos, boolean forceRebuild) {
        int baseX = pos.func_177958_n();
        int baseY = pos.func_177956_o();
        int baseZ = pos.func_177952_p();
        BlockPos rebuildPos = forceRebuild ? pos : null;
        for (int wallX = 0; wallX < size; ++wallX) {
            for (int wallY = 0; wallY < size; ++wallY) {
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY - wallY, baseZ - wallX, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY + wallY, baseZ + wallX, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY, baseZ - wallY, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY, baseZ + wallY, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY - wallY, baseZ - wallX, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY + wallY, baseZ + wallX, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ - size + 1, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ - size + 1, rebuildPos)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - size + 1, baseZ - wallY, rebuildPos)) {
                    return true;
                }
                if (!TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY - size + 1, baseZ + wallY, rebuildPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkForCubeOfSize(int size, World world, int baseX, int baseY, int baseZ, BlockPos rebuildPos) {
        ArrayList<TileEntityPressureChamberValve> valveList = new ArrayList<TileEntityPressureChamberValve>();
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    TileEntityPressureChamberValve teV;
                    mPos = mPos.func_181079_c(x + baseX, y + baseY, z + baseZ);
                    BlockState state = world.func_180495_p((BlockPos)mPos);
                    if (x != 0 && x != size - 1 && y != 0 && y != size - 1 && z != 0 && z != size - 1) {
                        if (world.func_175623_d((BlockPos)mPos)) continue;
                        return false;
                    }
                    if (!(state.func_177230_c() instanceof IBlockPressureChamber)) {
                        return false;
                    }
                    if (state.func_177230_c() instanceof BlockPressureChamberValve) {
                        boolean xMid = x != 0 && x != size - 1;
                        boolean yMid = y != 0 && y != size - 1;
                        boolean zMid = z != 0 && z != size - 1;
                        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
                        if (xMid && yMid && facing.func_176740_k() == Direction.Axis.Z || xMid && zMid && facing.func_176740_k() == Direction.Axis.Y || yMid && zMid && facing.func_176740_k() == Direction.Axis.X) {
                            TileEntity te = world.func_175625_s((BlockPos)mPos);
                            if (!(te instanceof TileEntityPressureChamberValve)) continue;
                            valveList.add((TileEntityPressureChamberValve)te);
                            continue;
                        }
                        return false;
                    }
                    TileEntity te = world.func_175625_s((BlockPos)mPos);
                    if (!(te instanceof TileEntityPressureChamberWall) || (teV = ((TileEntityPressureChamberWall)te).getCore()) == null || rebuildPos != null && rebuildPos.equals((Object)teV.func_174877_v())) continue;
                    return false;
                }
            }
        }
        if (valveList.isEmpty()) {
            return false;
        }
        TileEntityPressureChamberValve primaryValve = (TileEntityPressureChamberValve)valveList.get(valveList.size() - 1);
        valveList.forEach(valve -> {
            valve.accessoryValves = new ArrayList<TileEntityPressureChamberValve>(valveList);
        });
        primaryValve.setupMultiBlock(size, baseX, baseY, baseZ);
        primaryValve.hasGlass = false;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    TileEntity te = world.func_175625_s(new BlockPos(x + baseX, y + baseY, z + baseZ));
                    if (te instanceof TileEntityPressureChamberWall) {
                        TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                        teWall.setCore(primaryValve);
                        if (world.func_180495_p(te.func_174877_v()).func_177230_c() instanceof BlockPressureChamberGlass) {
                            primaryValve.hasGlass = true;
                        }
                    } else if (te instanceof TileEntityPressureChamberValve) {
                        BlockState state = world.func_180495_p(te.func_174877_v());
                        world.func_180501_a(te.func_174877_v(), (BlockState)state.func_206870_a((Property)BlockPressureChamberValve.FORMED, (Comparable)Boolean.valueOf(((TileEntityPressureChamberValve)te).isPrimaryValve())), 2);
                    }
                    if (te == null) continue;
                    double dx = x == 0 ? -0.1 : 0.1;
                    double dz = z == 0 ? -0.1 : 0.1;
                    NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((IParticleData)ParticleTypes.field_197598_I, (double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 0.5, (double)te.func_174877_v().func_177952_p() + 0.5, dx, 0.3, dz, 5, 0.0, 0.0, 0.0), te);
                }
            }
        }
        if (primaryValve.savedVolume != 0) {
            int mul = primaryValve.savedVolume / primaryValve.airHandler.getBaseVolume();
            int newAir = primaryValve.airHandler.getAir() * mul;
            primaryValve.addAir(newAir - primaryValve.airHandler.getAir());
            primaryValve.savedVolume = 0;
        }
        primaryValve.captureEntityItemsInChamber();
        primaryValve.scheduleDescriptionPacket();
        primaryValve.func_70296_d();
        return true;
    }

    private boolean isPrimaryValve() {
        return this.multiBlockSize > 0;
    }

    private AxisAlignedBB getChamberAABB() {
        return new AxisAlignedBB((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
    }

    private void captureEntityItemsInChamber() {
        List items = this.func_145831_w().func_175647_a(ItemEntity.class, this.getChamberAABB(), EntityPredicates.field_94557_a);
        for (ItemEntity item : items) {
            ItemStack stack = item.func_92059_d();
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack, (boolean)false);
            if (excess.func_190926_b()) {
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(excess);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getChamberAABB();
    }

    @Override
    public float getMinWorkingPressure() {
        return this.isValidRecipeInChamber ? this.recipePressure : -3.4028235E38f;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPressureChamberValve(i, playerInventory, this.func_174877_v());
    }

    private void rebuildRenderedItems() {
        this.renderedItems.clear();
        for (int i = 0; i < this.allItems.getSlots(); ++i) {
            if (this.allItems.getStackInSlot(i).func_190926_b()) continue;
            this.renderedItems.add(this.allItems.getStackInSlot(i));
        }
    }

    private static class ApplicableRecipe {
        final PressureChamberRecipe recipe;
        final List<Integer> slots;

        ApplicableRecipe(PressureChamberRecipe recipe, Collection<Integer> slots) {
            this.recipe = recipe;
            this.slots = ImmutableList.copyOf(slots);
        }
    }

    private class OutputStackHandler
    extends ItemStackHandler {
        OutputStackHandler() {
            super(9);
        }

        protected void onContentsChanged(int slot) {
            if (TileEntityPressureChamberValve.this.field_145850_b != null && ((TileEntityPressureChamberValve)TileEntityPressureChamberValve.this).field_145850_b.field_72995_K) {
                TileEntityPressureChamberValve.this.rebuildRenderedItems();
            }
            TileEntityPressureChamberValve.this.func_70296_d();
        }
    }

    private class ChamberStackHandler
    extends ItemStackHandler {
        ChamberStackHandler() {
            super(18);
        }

        protected void onContentsChanged(int slot) {
            TileEntityPressureChamberValve.this.recipeRecalcNeeded = true;
            if (TileEntityPressureChamberValve.this.field_145850_b != null && ((TileEntityPressureChamberValve)TileEntityPressureChamberValve.this).field_145850_b.field_72995_K) {
                TileEntityPressureChamberValve.this.rebuildRenderedItems();
            }
            TileEntityPressureChamberValve.this.func_70296_d();
        }
    }
}

