/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.block.BlockOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class TileEntityAbstractHopper<T extends TileEntity>
extends TileEntityTickableBase
implements IRedstoneControl<T>,
IComparatorSupport,
INamedContainerProvider {
    private static final int BASE_TICK_RATE = 8;
    private int lastComparatorValue = -1;
    private int cooldown;
    private int entityScanCooldown;
    @GuiSynced
    int leaveMaterialCount;
    @DescSynced
    public boolean isCreative;
    private boolean wasCreative = false;
    Direction inputDir = Direction.UP;
    AxisAlignedBB inputAABB;
    AxisAlignedBB outputAABB;
    final List<Entity> cachedInputEntities = new ArrayList<Entity>();
    final List<Entity> cachedOutputEntities = new ArrayList<Entity>();

    TileEntityAbstractHopper(TileEntityType type) {
        super(type, 4);
    }

    public Direction getInputDirection() {
        return (Direction)this.func_195044_w().func_177229_b(BlockOmnidirectionalHopper.INPUT_FACING);
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.isCreative = this.getUpgrades(EnumUpgrade.CREATIVE) > 0;
        this.setupInputOutputRegions();
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.inputDir = this.getInputDirection();
        this.setupInputOutputRegions();
    }

    @Override
    public void func_73660_a() {
        this.inputDir = this.getInputDirection();
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.getRedstoneController().shouldRun()) {
            if (--this.entityScanCooldown <= 0) {
                this.cachedInputEntities.clear();
                if (this.shouldScanForEntities(this.inputDir)) {
                    this.cachedInputEntities.addAll(this.field_145850_b.func_175647_a(Entity.class, this.inputAABB, EntityPredicates.field_94557_a));
                }
                this.cachedOutputEntities.clear();
                if (this.shouldScanForEntities(this.getRotation())) {
                    this.cachedOutputEntities.addAll(this.field_145850_b.func_175647_a(Entity.class, this.outputAABB, EntityPredicates.field_94557_a));
                }
                this.entityScanCooldown = 8;
            }
            if (--this.cooldown <= 0) {
                int maxItems = this.getMaxItems();
                boolean success = this.doImport(maxItems);
                int n = this.cooldown = (success |= this.doExport(maxItems)) ? this.getItemTransferInterval() : 8;
                if (this.lastComparatorValue != this.getComparatorValueInternal()) {
                    this.lastComparatorValue = this.getComparatorValueInternal();
                }
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        boolean rerender = this.wasCreative != this.isCreative;
        this.wasCreative = this.isCreative;
        return rerender;
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(EnumUpgrade.SPEED);
        if (upgrades > 3) {
            return Math.min(1 << upgrades - 3, 256);
        }
        return 1;
    }

    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(EnumUpgrade.SPEED));
    }

    protected abstract void setupInputOutputRegions();

    protected abstract boolean doExport(int var1);

    protected abstract boolean doImport(int var1);

    protected abstract int getComparatorValueInternal();

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("leaveMaterialCount", this.leaveMaterialCount);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.leaveMaterialCount = tag.func_74764_b("leaveMaterial") ? (int)((byte)(tag.func_74767_n("leaveMaterial") ? 1 : 0)) : tag.func_74762_e("leaveMaterialCount");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.getRedstoneController().parseRedstoneMode(tag)) {
            return;
        }
        switch (tag) {
            case "empty": {
                this.leaveMaterialCount = 0;
                break;
            }
            case "leave": {
                this.leaveMaterialCount = 1;
            }
        }
        this.func_70296_d();
    }

    public boolean doesLeaveMaterial() {
        return this.leaveMaterialCount > 0;
    }

    @Override
    public int getComparatorValue() {
        return this.getComparatorValueInternal();
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.isCreative = this.getUpgrades(EnumUpgrade.CREATIVE) > 0;
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    List<ItemEntity> getNeighborItems(AxisAlignedBB aabb) {
        return aabb == null ? Collections.emptyList() : this.field_145850_b.func_175647_a(ItemEntity.class, aabb, EntityPredicates.field_94557_a);
    }

    abstract boolean shouldScanForEntities(Direction var1);
}

