/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class JEIMemoryEssenceCategory
extends AbstractPNCCategory<MemoryEssenceRecipe> {
    public JEIMemoryEssenceCategory() {
        super(ModCategoryUid.MEMORY_ESSENCE, MemoryEssenceRecipe.class, new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), 1000).getDisplayName(), (IDrawable)JEIMemoryEssenceCategory.guiHelper().createDrawable(Textures.GUI_JEI_MEMORY_ESSENCE, 0, 0, 146, 73), JEIMemoryEssenceCategory.guiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.MEMORY_ESSENCE_BUCKET.get())));
    }

    public void setIngredients(MemoryEssenceRecipe recipe, IIngredients ingredients) {
        if (recipe.input2.func_190926_b()) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.input1);
        } else {
            ingredients.setInputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)recipe.input1, (Object)recipe.input2));
        }
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), 1000));
    }

    public void setRecipe(IRecipeLayout recipeLayout, MemoryEssenceRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 53, 28);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        if (!recipe.input2.func_190926_b()) {
            recipeLayout.getItemStacks().init(1, true, 75, 28);
            recipeLayout.getItemStacks().set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        }
        recipeLayout.getFluidStacks().init(0, false, 112, 29);
        recipeLayout.getFluidStacks().set(0, new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), 1000));
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            String tooltipKey = recipe.getTooltipKey(slotIndex);
            if (!tooltipKey.isEmpty()) {
                tooltip.addAll(PneumaticCraftUtils.splitStringComponent(TextFormatting.GREEN + I18n.func_135052_a((String)tooltipKey, (Object[])new Object[0])));
            }
        });
    }

    public void draw(MemoryEssenceRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
        String s = "1 XP = " + ratio + " mB";
        int w = fr.func_78256_a(s);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, s, (float)(this.getBackground().getWidth() - w) / 2.0f, 0.0f, 0x404040);
    }

    static Collection<MemoryEssenceRecipe> getAllRecipes() {
        return ImmutableList.of((Object)new MemoryEssenceRecipe((IItemProvider)ModItems.MEMORY_STICK.get(), null), (Object)new MemoryEssenceRecipe((IItemProvider)ModBlocks.AERIAL_INTERFACE.get(), (IItemProvider)EnumUpgrade.DISPENSER.getItem()), (Object)new MemoryEssenceRecipe((IItemProvider)ModItems.DRONE.get(), (IItemProvider)ModItems.PROGRAMMING_PUZZLE.get()).setTooltipKey(1, "pneumaticcraft.gui.jei.tooltip.droneImportOrbs"));
    }

    static class MemoryEssenceRecipe {
        final ItemStack input1;
        final ItemStack input2;
        final String[] tooltips = new String[]{"", ""};

        public MemoryEssenceRecipe(IItemProvider input1, IItemProvider input2) {
            this.input1 = new ItemStack(input1);
            this.input2 = input2 == null ? ItemStack.field_190927_a : new ItemStack(input2);
        }

        public MemoryEssenceRecipe setTooltipKey(int slot, String tooltipKey) {
            this.tooltips[slot] = tooltipKey;
            return this;
        }

        public String getTooltipKey(int slot) {
            return slot >= 0 && slot <= 2 ? this.tooltips[slot] : "";
        }
    }
}

