/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.block.BlockThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ThermoPlantRecipeImpl
extends ThermoPlantRecipe {
    private final FluidIngredient inputFluid;
    private final FluidStack outputFluid;
    private final Ingredient inputItem;
    private final float requiredPressure;
    private final float recipeSpeed;
    private final boolean exothermic;
    private final TemperatureRange operatingTemperature;
    private final ItemStack outputItem;

    public ThermoPlantRecipeImpl(ResourceLocation id, @Nonnull FluidIngredient inputFluid, @Nonnull Ingredient inputItem, FluidStack outputFluid, ItemStack outputItem, TemperatureRange operatingTemperature, float requiredPressure, float recipeSpeed, boolean exothermic) {
        super(id);
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.operatingTemperature = operatingTemperature;
        this.requiredPressure = requiredPressure;
        this.recipeSpeed = recipeSpeed;
        this.exothermic = exothermic;
    }

    @Override
    public boolean matches(FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        return (this.inputFluid.func_203189_d() && fluidStack.isEmpty() || this.inputFluid.testFluid(fluidStack.getFluid())) && (this.inputItem.func_203189_d() && itemStack.func_190926_b() || this.inputItem.test(itemStack));
    }

    @Override
    public TemperatureRange getOperatingTemperature() {
        return this.operatingTemperature;
    }

    @Override
    public float getRequiredPressure() {
        return this.requiredPressure;
    }

    @Override
    public FluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    @Override
    @Nonnull
    public Ingredient getInputItem() {
        return this.inputItem;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public boolean isExothermic() {
        return this.exothermic;
    }

    @Override
    public double getRecipeSpeed() {
        return this.recipeSpeed;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.operatingTemperature.write(buffer);
        buffer.writeFloat(this.requiredPressure);
        this.inputItem.func_199564_a(buffer);
        this.inputFluid.func_199564_a(buffer);
        this.outputFluid.writeToPacket(buffer);
        buffer.func_150788_a(this.outputItem);
        buffer.writeFloat(this.recipeSpeed);
        buffer.writeBoolean(this.exothermic);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.THERMO_PLANT.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.THERMO_PLANT;
    }

    public String func_193358_e() {
        return ((BlockThermopneumaticProcessingPlant)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).getRegistryName().func_110623_a();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get());
    }

    public static class Serializer<T extends ThermoPlantRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            if (!json.has("item_input") && !json.has("fluid_input")) {
                throw new JsonSyntaxException("Must have at least one of item_input and/or fluid_input!");
            }
            if (!json.has("item_output") && !json.has("fluid_output")) {
                throw new JsonSyntaxException("Must have at least one of item_output and/or fluid_output!");
            }
            Ingredient itemInput = json.has("item_input") ? Ingredient.func_199802_a((JsonElement)json.get("item_input")) : Ingredient.field_193370_a;
            FluidIngredient fluidInput = json.has("fluid_input") ? FluidIngredient.func_199802_a((JsonElement)json.get("fluid_input")) : FluidIngredient.EMPTY;
            FluidStack fluidOutput = json.has("fluid_output") ? ModCraftingHelper.fluidStackFromJson(json.getAsJsonObject("fluid_output")) : FluidStack.EMPTY;
            ItemStack itemOutput = json.has("item_output") ? ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"item_output")) : ItemStack.field_190927_a;
            TemperatureRange range = json.has("temperature") ? TemperatureRange.fromJson(json.getAsJsonObject("temperature")) : TemperatureRange.any();
            float pressure = JSONUtils.func_151221_a((JsonObject)json, (String)"pressure", (float)0.0f);
            boolean exothermic = JSONUtils.func_151209_a((JsonObject)json, (String)"exothermic", (boolean)false);
            float recipeSpeed = JSONUtils.func_151221_a((JsonObject)json, (String)"speed", (float)1.0f);
            return this.factory.create(recipeId, fluidInput, itemInput, fluidOutput, itemOutput, range, pressure, recipeSpeed, exothermic);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            TemperatureRange range = TemperatureRange.read(buffer);
            float pressure = buffer.readFloat();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidIngredient fluidIn = (FluidIngredient)Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack fluidOut = FluidStack.readFromPacket((PacketBuffer)buffer);
            ItemStack itemOutput = buffer.func_150791_c();
            float recipeSpeed = buffer.readFloat();
            boolean exothermic = buffer.readBoolean();
            return this.factory.create(recipeId, fluidIn, input, fluidOut, itemOutput, range, pressure, recipeSpeed, exothermic);
        }

        public void toNetwork(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends ThermoPlantRecipe> {
            public T create(ResourceLocation var1, @Nonnull FluidIngredient var2, @Nullable Ingredient var3, FluidStack var4, ItemStack var5, TemperatureRange var6, float var7, float var8, boolean var9);
        }
    }
}

