/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.BitSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;

public class AxisOptions {
    public static final AxisOptions TRUE = new AxisOptions(true, true, true);
    private final BitSet options = new BitSet(3);

    public AxisOptions(boolean x, boolean y, boolean z) {
        this.options.set(0, x);
        this.options.set(1, y);
        this.options.set(2, z);
    }

    public boolean shouldCheck(Direction.Axis axis) {
        return this.options.get(axis.ordinal());
    }

    public void setCheck(Direction.Axis axis, boolean check) {
        this.options.set(axis.ordinal(), check);
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74757_a("checkX", this.shouldCheck(Direction.Axis.X));
        nbt.func_74757_a("checkY", this.shouldCheck(Direction.Axis.Y));
        nbt.func_74757_a("checkZ", this.shouldCheck(Direction.Axis.Z));
    }

    public void readFromNBT(CompoundNBT nbt, boolean def) {
        this.setCheck(Direction.Axis.X, nbt.func_74764_b("checkX") ? nbt.func_74767_n("checkX") : def);
        this.setCheck(Direction.Axis.Y, nbt.func_74764_b("checkY") ? nbt.func_74767_n("checkY") : def);
        this.setCheck(Direction.Axis.Z, nbt.func_74764_b("checkZ") ? nbt.func_74767_n("checkZ") : def);
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeBoolean(this.shouldCheck(Direction.Axis.X));
        buffer.writeBoolean(this.shouldCheck(Direction.Axis.Y));
        buffer.writeBoolean(this.shouldCheck(Direction.Axis.Z));
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.setCheck(Direction.Axis.X, buffer.readBoolean());
        this.setCheck(Direction.Axis.Y, buffer.readBoolean());
        this.setCheck(Direction.Axis.Z, buffer.readBoolean());
    }
}

