/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.EntityRing;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSpawnRing
extends LocationDoublePacket {
    private final int[] colors;
    private final int targetEntityId;

    public PacketSpawnRing(double x, double y, double z, Entity targetEntity, int ... colors) {
        super(x, y, z);
        this.targetEntityId = targetEntity.func_145782_y();
        this.colors = colors;
    }

    public PacketSpawnRing(PacketBuffer buffer) {
        super(buffer);
        this.targetEntityId = buffer.readInt();
        this.colors = new int[buffer.func_150792_a()];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = buffer.readInt();
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.targetEntityId);
        buffer.func_150787_b(this.colors.length);
        Arrays.stream(this.colors).forEach(arg_0 -> ((PacketBuffer)buffer).writeInt(arg_0));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ClientUtils.getClientWorld();
            Entity entity = world.func_73045_a(this.targetEntityId);
            if (entity != null) {
                for (int color : this.colors) {
                    ClientUtils.spawnEntityClientside(new EntityRing(world, this.x, this.y, this.z, entity, color));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

