/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSpawnParticleTrail
extends LocationDoublePacket {
    private final IParticleData particle;
    private final double x2;
    private final double y2;
    private final double z2;

    public PacketSpawnParticleTrail(IParticleData particle, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1);
        this.particle = particle;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public PacketSpawnParticleTrail(PacketBuffer buffer) {
        super(buffer);
        ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.func_192575_l());
        assert (type != null);
        this.x2 = buffer.readDouble();
        this.y2 = buffer.readDouble();
        this.z2 = buffer.readDouble();
        this.particle = this.readParticle(type, buffer);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.func_192572_a(Objects.requireNonNull(this.particle.func_197554_b().getRegistryName()));
        buffer.writeDouble(this.x2);
        buffer.writeDouble(this.y2);
        buffer.writeDouble(this.z2);
        this.particle.func_197553_a(new PacketBuffer((ByteBuf)buffer));
    }

    private <T extends IParticleData> T readParticle(ParticleType<T> type, PacketBuffer buffer) {
        return (T)type.func_197571_g().func_197543_b(type, buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ClientUtils.getClientWorld();
            int numParticles = (int)PneumaticCraftUtils.distBetween(this.x, this.y, this.z, this.x2, this.y2, this.z2) * 25;
            if (numParticles == 0) {
                numParticles = 1;
            }
            for (int i = 0; i <= numParticles; ++i) {
                double pct = (double)i / (double)numParticles;
                double px = MathHelper.func_219803_d((double)pct, (double)this.x, (double)this.x2);
                double py = MathHelper.func_219803_d((double)pct, (double)this.y, (double)this.y2);
                double pz = MathHelper.func_219803_d((double)pct, (double)this.z, (double)this.z2);
                world.func_195594_a(this.particle, px + world.field_73012_v.nextDouble() * 0.2 - 0.1, py + world.field_73012_v.nextDouble() * 0.2 - 0.1, pz + world.field_73012_v.nextDouble() * 0.2 - 0.1, 0.0, 0.0, 0.0);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

