/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketAbstractAmadronTrade;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketAphorismTileUpdate;
import me.desht.pneumaticcraft.common.network.PacketBlockDestroyed;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.network.PacketClearRecipeCache;
import me.desht.pneumaticcraft.common.network.PacketDebugBlock;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketDroneDebugBase;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketJetBootsActivate;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.network.PacketMinigunStop;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketMultiHeader;
import me.desht.pneumaticcraft.common.network.PacketMultiPart;
import me.desht.pneumaticcraft.common.network.PacketNotifyVariablesRemote;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketPneumaticKick;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.network.PacketShiftScrollWheel;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSpawnIndicatorParticles;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticleTrail;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import me.desht.pneumaticcraft.common.network.PacketSyncHackSimulationUpdate;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToClient;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.network.PacketTubeModuleColor;
import me.desht.pneumaticcraft.common.network.PacketUpdateAirGrateModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorColors;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import me.desht.pneumaticcraft.common.network.PacketUpdateGPSAreaTool;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticsModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateRemoteLayout;
import me.desht.pneumaticcraft.common.network.PacketUpdateSearchItem;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.network.PacketUpdateTubeModule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "8";
    private static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)PneumaticRegistry.RL("main_channel")).clientAcceptedVersions("8"::equals).serverAcceptedVersions("8"::equals).networkProtocolVersion(() -> "8").simpleChannel();
    private static int det = 0;

    private static int nextId() {
        return det++;
    }

    public static void init() {
        NetworkHandler.registerMessage(PacketAphorismTileUpdate.class, PacketAphorismTileUpdate::toBytes, PacketAphorismTileUpdate::new, PacketAphorismTileUpdate::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketChangeGPSToolCoordinate.class, PacketChangeGPSToolCoordinate::toBytes, PacketChangeGPSToolCoordinate::new, PacketChangeGPSToolCoordinate::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdateGPSAreaTool.class, PacketUpdateGPSAreaTool::toBytes, PacketUpdateGPSAreaTool::new, PacketUpdateGPSAreaTool::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketDescription.class, PacketDescription::toBytes, PacketDescription::new, PacketDescription::process, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketDescriptionPacketRequest.class, LocationIntPacket::toBytes, PacketDescriptionPacketRequest::new, PacketDescriptionPacketRequest::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketGuiButton.class, PacketGuiButton::toBytes, PacketGuiButton::new, PacketGuiButton::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketPlaySound.class, PacketPlaySound::toBytes, PacketPlaySound::new, PacketPlaySound::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketProgrammerUpdate.class, PacketProgrammerUpdate::toBytes, PacketProgrammerUpdate::new, PacketProgrammerUpdate::handle);
        NetworkHandler.registerMessage(PacketSendNBTPacket.class, PacketSendNBTPacket::toBytes, PacketSendNBTPacket::new, PacketSendNBTPacket::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketShowWireframe.class, PacketShowWireframe::toBytes, PacketShowWireframe::new, PacketShowWireframe::handle);
        NetworkHandler.registerMessage(PacketSpawnParticle.class, PacketSpawnParticle::toBytes, PacketSpawnParticle::new, PacketSpawnParticle::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSpawnParticleTrail.class, PacketSpawnParticleTrail::toBytes, PacketSpawnParticleTrail::new, PacketSpawnParticleTrail::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSpawnIndicatorParticles.class, PacketSpawnIndicatorParticles::toBytes, PacketSpawnIndicatorParticles::new, PacketSpawnIndicatorParticles::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketUpdateSearchItem.class, PacketUpdateSearchItem::toBytes, PacketUpdateSearchItem::new, PacketUpdateSearchItem::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdateTextfield.class, PacketUpdateTextfield::toBytes, PacketUpdateTextfield::new, PacketUpdateTextfield::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdatePressureModule.class, PacketUpdatePressureModule::toBytes, PacketUpdatePressureModule::new, PacketUpdateTubeModule::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdateAirGrateModule.class, PacketUpdateAirGrateModule::toBytes, PacketUpdateAirGrateModule::new, PacketUpdateTubeModule::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdateGui.class, PacketUpdateGui::toBytes, PacketUpdateGui::new, PacketUpdateGui::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketUpdateRemoteLayout.class, PacketUpdateRemoteLayout::toBytes, PacketUpdateRemoteLayout::new, PacketUpdateRemoteLayout::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketSetGlobalVariable.class, PacketSetGlobalVariable::toBytes, PacketSetGlobalVariable::new, PacketSetGlobalVariable::handle);
        NetworkHandler.registerMessage(PacketServerTickTime.class, PacketServerTickTime::toBytes, PacketServerTickTime::new, PacketServerTickTime::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketUpdatePressureBlock.class, PacketUpdatePressureBlock::toBytes, PacketUpdatePressureBlock::new, PacketUpdatePressureBlock::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSyncAmadronOffers.class, PacketSyncAmadronOffers::toBytes, PacketSyncAmadronOffers::new, PacketSyncAmadronOffers::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketAmadronOrderResponse.class, PacketAmadronOrderResponse::toBytes, PacketAmadronOrderResponse::new, PacketAmadronOrderResponse::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketAmadronOrderUpdate.class, PacketAmadronOrderUpdate::toBytes, PacketAmadronOrderUpdate::new, PacketAmadronOrderUpdate::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketAmadronStockUpdate.class, PacketAmadronStockUpdate::toBytes, PacketAmadronStockUpdate::new, PacketAmadronStockUpdate::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketAmadronTradeAddCustom.class, PacketAbstractAmadronTrade::toBytes, PacketAmadronTradeAddCustom::new, PacketAmadronTradeAddCustom::handle);
        NetworkHandler.registerMessage(PacketAmadronTradeNotifyDeal.class, PacketAmadronTradeNotifyDeal::toBytes, PacketAmadronTradeNotifyDeal::new, PacketAmadronTradeNotifyDeal::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketAmadronTradeRemoved.class, PacketAbstractAmadronTrade::toBytes, PacketAmadronTradeRemoved::new, PacketAmadronTradeRemoved::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketUpdateLogisticsModule.class, PacketUpdateLogisticsModule::toBytes, PacketUpdateLogisticsModule::new, PacketUpdateLogisticsModule::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketTubeModuleColor.class, PacketTubeModuleColor::toBytes, PacketTubeModuleColor::new, PacketTubeModuleColor::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketSyncRedstoneModuleToClient.class, PacketSyncRedstoneModuleToClient::toBytes, PacketSyncRedstoneModuleToClient::new, PacketSyncRedstoneModuleToClient::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSyncRedstoneModuleToServer.class, PacketSyncRedstoneModuleToServer::toBytes, PacketSyncRedstoneModuleToServer::new, PacketSyncRedstoneModuleToServer::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketNotifyVariablesRemote.class, PacketNotifyVariablesRemote::toBytes, PacketNotifyVariablesRemote::new, PacketNotifyVariablesRemote::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketHackingBlockStart.class, LocationIntPacket::toBytes, PacketHackingBlockStart::new, PacketHackingBlockStart::handle);
        NetworkHandler.registerMessage(PacketHackingBlockFinish.class, LocationIntPacket::toBytes, PacketHackingBlockFinish::new, PacketHackingBlockFinish::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketHackingEntityStart.class, PacketHackingEntityStart::toBytes, PacketHackingEntityStart::new, PacketHackingEntityStart::handle);
        NetworkHandler.registerMessage(PacketHackingEntityFinish.class, PacketHackingEntityFinish::toBytes, PacketHackingEntityFinish::new, PacketHackingEntityFinish::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketToggleArmorFeature.class, PacketToggleArmorFeature::toBytes, PacketToggleArmorFeature::new, PacketToggleArmorFeature::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketToggleArmorFeatureBulk.class, PacketToggleArmorFeatureBulk::toBytes, PacketToggleArmorFeatureBulk::new, PacketToggleArmorFeatureBulk::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdateDebuggingDrone.class, PacketDroneDebugBase::toBytes, PacketUpdateDebuggingDrone::new, PacketDroneDebugBase::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketSendDroneDebugEntry.class, PacketSendDroneDebugEntry::toBytes, PacketSendDroneDebugEntry::new, PacketDroneDebugBase::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSyncDroneEntityProgWidgets.class, PacketSyncDroneEntityProgWidgets::toBytes, PacketSyncDroneEntityProgWidgets::new, PacketDroneDebugBase::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSpawnRing.class, PacketSpawnRing::toBytes, PacketSpawnRing::new, PacketSpawnRing::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketShowArea.class, PacketShowArea::toBytes, PacketShowArea::new, PacketShowArea::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSetEntityMotion.class, PacketSetEntityMotion::toBytes, PacketSetEntityMotion::new, PacketSetEntityMotion::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketDebugBlock.class, LocationIntPacket::toBytes, PacketDebugBlock::new, PacketDebugBlock::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketMultiHeader.class, PacketMultiHeader::toBytes, PacketMultiHeader::new, PacketMultiHeader::handle);
        NetworkHandler.registerMessage(PacketMultiPart.class, PacketMultiPart::toBytes, PacketMultiPart::new, PacketMultiPart::handle);
        NetworkHandler.registerMessage(PacketPneumaticKick.class, PacketPneumaticKick::toBytes, PacketPneumaticKick::new, PacketPneumaticKick::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketJetBootsActivate.class, PacketJetBootsActivate::toBytes, PacketJetBootsActivate::new, PacketJetBootsActivate::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketPlayMovingSound.class, PacketPlayMovingSound::toBytes, PacketPlayMovingSound::new, PacketPlayMovingSound::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketJetBootsStateSync.class, PacketJetBootsStateSync::toBytes, PacketJetBootsStateSync::new, PacketJetBootsStateSync::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketModWrenchBlock.class, PacketModWrenchBlock::toBytes, PacketModWrenchBlock::new, PacketModWrenchBlock::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdateArmorExtraData.class, PacketUpdateArmorExtraData::toBytes, PacketUpdateArmorExtraData::new, PacketUpdateArmorExtraData::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketUpdateMicromissileSettings.class, PacketUpdateMicromissileSettings::toBytes, PacketUpdateMicromissileSettings::new, PacketUpdateMicromissileSettings::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketSendArmorHUDMessage.class, PacketSendArmorHUDMessage::toBytes, PacketSendArmorHUDMessage::new, PacketSendArmorHUDMessage::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketChestplateLauncher.class, PacketChestplateLauncher::toBytes, PacketChestplateLauncher::new, PacketChestplateLauncher::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketSyncSemiblock.class, PacketSyncSemiblock::toBytes, PacketSyncSemiblock::new, PacketSyncSemiblock::handle);
        NetworkHandler.registerMessage(PacketSyncSmartChest.class, PacketSyncSmartChest::toBytes, PacketSyncSmartChest::new, PacketSyncSmartChest::handle);
        NetworkHandler.registerMessage(PacketClearRecipeCache.class, PacketClearRecipeCache::toBytes, PacketClearRecipeCache::new, PacketClearRecipeCache::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketLeftClickEmpty.class, PacketLeftClickEmpty::toBytes, PacketLeftClickEmpty::new, PacketLeftClickEmpty::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketShiftScrollWheel.class, PacketShiftScrollWheel::toBytes, PacketShiftScrollWheel::new, PacketShiftScrollWheel::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketBlockDestroyed.class, LocationIntPacket::toBytes, PacketBlockDestroyed::new, PacketBlockDestroyed::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketSyncHackSimulationUpdate.class, PacketSyncHackSimulationUpdate::toBytes, PacketSyncHackSimulationUpdate::new, PacketSyncHackSimulationUpdate::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkHandler.registerMessage(PacketUpdateArmorColors.class, PacketUpdateArmorColors::toBytes, PacketUpdateArmorColors::new, PacketUpdateArmorColors::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkHandler.registerMessage(PacketMinigunStop.class, PacketMinigunStop::toBytes, PacketMinigunStop::new, PacketMinigunStop::handle, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        NETWORK.registerMessage(NetworkHandler.nextId(), messageType, encoder, decoder, messageConsumer);
    }

    public static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer, NetworkDirection direction) {
        NETWORK.registerMessage(NetworkHandler.nextId(), messageType, encoder, decoder, messageConsumer, Optional.of(direction));
    }

    public static void sendToAll(Object message) {
        NetworkHandler.sendMessage(message, msg -> NETWORK.send(PacketDistributor.ALL.noArg(), msg));
    }

    public static void sendToPlayer(Object message, ServerPlayerEntity player) {
        NetworkHandler.sendMessage(message, msg -> NETWORK.send(PacketDistributor.PLAYER.with(() -> player), msg));
    }

    public static void sendToAllTracking(Object message, Entity entity) {
        NetworkHandler.sendMessage(message, msg -> NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg));
    }

    public static void sendToAllTracking(Object message, World world, BlockPos pos) {
        NetworkHandler.sendMessage(message, msg -> NETWORK.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), msg));
    }

    public static void sendToAllTracking(Object message, TileEntity te) {
        if (te.func_145831_w() != null) {
            NetworkHandler.sendToAllTracking(message, te.func_145831_w(), te.func_174877_v());
        }
    }

    public static void sendToDimension(Object message, RegistryKey<World> world) {
        NetworkHandler.sendMessage(message, msg -> NETWORK.send(PacketDistributor.DIMENSION.with(() -> world), msg));
    }

    public static void sendToServer(Object message) {
        NetworkHandler.sendMessage(message, arg_0 -> ((SimpleChannel)NETWORK).sendToServer(arg_0));
    }

    public static void sendNonLocal(Object packet) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            if (server.func_71262_S()) {
                NetworkHandler.sendToAll(packet);
            } else {
                for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                    if (player.field_71133_b.func_213199_b(player.func_146103_bH())) continue;
                    NetworkHandler.sendToPlayer(packet, player);
                }
            }
        }
    }

    public static void sendNonLocal(ServerPlayerEntity player, Object packet) {
        if (!player.field_71133_b.func_213199_b(player.func_146103_bH())) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    private static void sendMessage(Object message, Consumer<Object> consumer) {
        if (message instanceof ILargePayload) {
            PacketBuffer buf = ((ILargePayload)message).dumpToBuffer();
            if (buf.writerIndex() < 32000) {
                consumer.accept(message);
            } else {
                ArrayList<Object> messageParts = new ArrayList<Object>();
                messageParts.add(new PacketMultiHeader(buf.writerIndex(), message.getClass().getName()));
                byte[] bytes = buf.array();
                for (int offset = 0; offset < buf.writerIndex(); offset += 32000) {
                    messageParts.add(new PacketMultiPart(Arrays.copyOfRange(bytes, offset, Math.min(offset + 32000, buf.writerIndex()))));
                }
                messageParts.forEach(consumer);
            }
        } else {
            consumer.accept(message);
        }
    }
}

