/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IMagnetSuppressor;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.api.item.ItemVolumeModifier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.item.ItemSpawnerCore;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.Validate;

public enum ItemRegistry implements IItemRegistry
{
    INSTANCE;

    private final List<Item> inventoryItemBlacklist = new ArrayList<Item>();
    public final List<IInventoryItem> inventoryItems = new ArrayList<IInventoryItem>();
    private final Map<EnumUpgrade, List<IUpgradeAcceptor>> upgradeToAcceptors = new EnumMap<EnumUpgrade, List<IUpgradeAcceptor>>(EnumUpgrade.class);
    private final List<IMagnetSuppressor> magnetSuppressors = new ArrayList<IMagnetSuppressor>();
    private final List<ItemVolumeModifier> volumeModifiers = new ArrayList<ItemVolumeModifier>();

    public static ItemRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerInventoryItem(@Nonnull IInventoryItem handler) {
        Validate.notNull((Object)handler);
        this.inventoryItems.add(handler);
    }

    @Override
    public void registerUpgradeAcceptor(@Nonnull IUpgradeAcceptor upgradeAcceptor) {
        Map<EnumUpgrade, Integer> applicableUpgrades = upgradeAcceptor.getApplicableUpgrades();
        if (applicableUpgrades != null) {
            for (EnumUpgrade applicableUpgrade : applicableUpgrades.keySet()) {
                List acceptors = this.upgradeToAcceptors.computeIfAbsent(applicableUpgrade, k -> new ArrayList());
                acceptors.add(upgradeAcceptor);
            }
        }
    }

    @Override
    public void addTooltip(EnumUpgrade upgrade, List<ITextComponent> tooltip) {
        List<IUpgradeAcceptor> acceptors = this.upgradeToAcceptors.get((Object)upgrade);
        if (acceptors != null) {
            ArrayList<String> tempList = new ArrayList<String>(acceptors.size());
            for (IUpgradeAcceptor acceptor : acceptors) {
                tempList.add("\u2022 " + I18n.func_135052_a((String)acceptor.getUpgradeAcceptorTranslationKey(), (Object[])new Object[0]));
            }
            Collections.sort(tempList);
            tooltip.addAll(tempList.stream().map(StringTextComponent::new).collect(Collectors.toList()));
        }
    }

    @Override
    public void registerMagnetSuppressor(IMagnetSuppressor suppressor) {
        this.magnetSuppressors.add(suppressor);
    }

    @Override
    public boolean doesItemMatchFilter(@Nonnull ItemStack filterStack, @Nonnull ItemStack stack, boolean checkDurability, boolean checkNBT, boolean checkModSimilarity) {
        return PneumaticCraftUtils.doesItemMatchFilter(filterStack, stack, checkDurability, checkNBT, checkModSimilarity);
    }

    @Override
    public void registerPneumaticVolumeModifier(ItemVolumeModifier modifierFunc) {
        this.volumeModifiers.add(modifierFunc);
    }

    @Override
    public ISpawnerCoreStats getSpawnerCoreStats(ItemStack stack) {
        Validate.isTrue((boolean)(stack.func_77973_b() instanceof ItemSpawnerCore), (String)"item is not a Spawner Core!", (Object[])new Object[0]);
        return ItemSpawnerCore.SpawnerCoreStats.forItemStack(stack);
    }

    @Override
    public IAirHandlerItem.Provider makeItemAirHandlerProvider(ItemStack stack, float maxPressure) {
        return new AirHandlerItemStack(stack, maxPressure);
    }

    public boolean shouldSuppressMagnet(Entity e) {
        return this.magnetSuppressors.stream().anyMatch(s -> s.shouldSuppressMagnet(e));
    }

    @Override
    public int getModifiedVolume(ItemStack stack, int originalVolume) {
        for (ItemVolumeModifier modifier : this.volumeModifiers) {
            originalVolume = modifier.getNewVolume(stack, originalVolume);
        }
        return originalVolume;
    }

    public List<ItemStack> getStacksInItem(@Nonnull ItemStack item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (item.func_77973_b() instanceof IInventoryItem && !this.inventoryItemBlacklist.contains(item.func_77973_b())) {
            try {
                ((IInventoryItem)item.func_77973_b()).getStacksInItem(item, items);
            }
            catch (Throwable e) {
                Log.error("An InventoryItem crashed:", new Object[0]);
                e.printStackTrace();
                this.inventoryItemBlacklist.add(item.func_77973_b());
            }
        } else {
            Iterator<IInventoryItem> iterator = ItemRegistry.getInstance().inventoryItems.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().getStacksInItem(item, items);
                }
                catch (Throwable e) {
                    Log.error("An InventoryItem crashed:", new Object[0]);
                    e.printStackTrace();
                    iterator.remove();
                }
            }
        }
        return items;
    }
}

