/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourTransition;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class ItemManometer
extends ItemPressurizable {
    public ItemManometer() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
            TileEntity te;
            if (h.getAir() < 30) {
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", stack.func_200301_q()).func_240699_a_(TextFormatting.RED), true);
                return ActionResultType.FAIL;
            }
            ArrayList<ITextComponent> curInfo = new ArrayList<ITextComponent>();
            Direction side = context.func_196000_l();
            BlockPos pos = context.func_195995_a();
            BlockState state = world.func_180495_p(pos.func_177972_a(side));
            if (!player.func_225608_bj_() && state.func_177230_c() instanceof FlowingFluidBlock) {
                pos = pos.func_177972_a(side);
            }
            if ((te = world.func_175625_s(pos)) != null) {
                TemperatureData tempData;
                if (te instanceof INameable) {
                    curInfo.add((ITextComponent)((INameable)te).func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.AQUA));
                } else {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate(te.func_195044_w().func_177230_c().func_149739_a(), new Object[0]).func_240699_a_(TextFormatting.AQUA));
                }
                if (te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).isPresent()) {
                    te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(teAirHandler -> teAirHandler.printManometerMessage(player, curInfo));
                } else {
                    te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, side).ifPresent(teAirHandler -> teAirHandler.printManometerMessage(player, curInfo));
                }
                if (te instanceof IManoMeasurable) {
                    ((IManoMeasurable)te).printManometerMessage(player, curInfo);
                }
                if ((tempData = new TemperatureData((ICapabilityProvider)te)).isMultisided()) {
                    for (Direction face : DirectionUtil.VALUES) {
                        if (!tempData.hasData(face)) continue;
                        curInfo.add(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
                    }
                } else if (tempData.hasData(null)) {
                    curInfo.add(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
                } else {
                    HeatExchangerManager.getInstance().getLogic(world, pos, side).ifPresent(logic -> curInfo.add(HeatUtil.formatHeatString((int)logic.getTemperature())));
                }
            } else {
                BlockState state1 = world.func_180495_p(pos);
                if (state1.func_177230_c() instanceof FlowingFluidBlock) {
                    FlowingFluid f = ((FlowingFluidBlock)state1.func_177230_c()).getFluid();
                    FluidStack fs = new FluidStack((Fluid)f, 1000);
                    curInfo.add((ITextComponent)fs.getDisplayName().func_230532_e_().func_240699_a_(TextFormatting.AQUA));
                } else {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate(world.func_180495_p(pos).func_177230_c().func_149739_a(), new Object[0]).func_240699_a_(TextFormatting.AQUA));
                }
                HeatExchangerManager.INSTANCE.getLogic(world, pos, side).ifPresent(logic -> curInfo.add(HeatUtil.formatHeatString(logic.getTemperatureAsInt())));
            }
            this.checkForHeatExtraction(world, pos, curInfo);
            if (curInfo.size() > 0) {
                for (int i = 1; i < curInfo.size(); ++i) {
                    curInfo.set(i, (ITextComponent)Symbols.bullet().func_230529_a_((ITextComponent)curInfo.get(i)));
                }
                h.addAir(-30);
                curInfo.forEach(s -> player.func_146105_b(s, false));
            }
            return ActionResultType.SUCCESS;
        }).orElse(ActionResultType.PASS);
    }

    private void checkForHeatExtraction(World world, BlockPos pos, List<ITextComponent> curInfo) {
        for (Direction d : DirectionUtil.VALUES) {
            TileEntity te1 = world.func_175625_s(pos.func_177972_a(d));
            if (te1 == null) continue;
            te1.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, d.func_176734_d()).ifPresent(handler -> handler.getHeatBehaviour(pos, HeatBehaviourTransition.class).ifPresent(behaviour -> {
                double progress = behaviour.getExtractionProgress();
                if (progress != 0.0) {
                    String key = "pneumaticcraft.waila.temperature" + (progress < 0.0 ? "Gain" : "Loss");
                    int pct = progress < 0.0 ? (int)(progress * -100.0) : (int)(progress * 100.0);
                    curInfo.add((ITextComponent)new TranslationTextComponent(key, new Object[]{pct}));
                }
            }));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
            if (h.getPressure() >= 0.1f) {
                double temp = HeatExchangerLogicAmbient.getAmbientTemperature((IWorld)worldIn, playerIn.func_233580_cy_());
                playerIn.func_146105_b((ITextComponent)ItemStack.field_190927_a.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.AQUA), false);
                playerIn.func_146105_b((ITextComponent)Symbols.bullet().func_230529_a_(HeatUtil.formatHeatString((int)temp)), false);
                return ActionResult.func_226249_b_((Object)stack);
            }
            return ActionResult.func_226251_d_((Object)stack);
        }).orElse(ActionResult.func_226250_c_((Object)stack));
    }

    public ActionResultType func_111207_a(ItemStack iStack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (!player.field_70170_p.field_72995_K) {
            return iStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                if (h.getAir() < 30) {
                    player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", iStack.func_200301_q()).func_240699_a_(TextFormatting.RED), true);
                    return ActionResultType.FAIL;
                }
                ArrayList<ITextComponent> curInfo = new ArrayList<ITextComponent>();
                if (entity instanceof IManoMeasurable) {
                    ((IManoMeasurable)entity).printManometerMessage(player, curInfo);
                } else {
                    curInfo.add((ITextComponent)entity.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.AQUA));
                }
                if (curInfo.size() > 0) {
                    h.addAir(-30);
                    for (int i = 1; i < curInfo.size(); ++i) {
                        curInfo.set(i, (ITextComponent)Symbols.bullet().func_230529_a_((ITextComponent)curInfo.get(i)));
                    }
                    curInfo.forEach(s -> player.func_146105_b(s, false));
                }
                return ActionResultType.SUCCESS;
            }).orElse(ActionResultType.PASS);
        }
        return ActionResultType.SUCCESS;
    }
}

