/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class HeatExchangerLogicAmbient
extends HeatExchangerLogicConstant {
    static final double BASE_AMBIENT_TEMP = 300.0;
    private static final HeatExchangerLogicAmbient DEFAULT_AIR_EXCHANGER = new HeatExchangerLogicAmbient(300.0);
    private static final Int2ObjectOpenHashMap<HeatExchangerLogicAmbient> exchangers = new Int2ObjectOpenHashMap();

    public static HeatExchangerLogicAmbient atPosition(IWorld world, BlockPos pos) {
        double biomeMod = (Double)ConfigHelper.common().heat.ambientTemperatureBiomeModifier.get();
        double heightMod = (Double)ConfigHelper.common().heat.ambientTemperatureHeightModifier.get();
        if (biomeMod == 0.0 && heightMod == 0.0) {
            return DEFAULT_AIR_EXCHANGER;
        }
        float t = world.func_226691_t_(pos).func_225486_c(pos) - 0.8f;
        int y1 = (int)((float)world.func_181545_F() * 0.75f);
        int h = pos.func_177956_o() < y1 ? y1 - pos.func_177956_o() : 0;
        int temp = (int)(300.0 + biomeMod * (double)t + heightMod * (double)h);
        return (HeatExchangerLogicAmbient)exchangers.computeIfAbsent(temp, HeatExchangerLogicAmbient::new);
    }

    public static double getAmbientTemperature(IWorld world, BlockPos pos) {
        return HeatExchangerLogicAmbient.atPosition(world, pos).getAmbientTemperature();
    }

    private HeatExchangerLogicAmbient(double temperature) {
        super(temperature, (Double)ConfigHelper.common().heat.airThermalResistance.get());
    }
}

