/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PneumaticArmorHandler {
    private static final Map<Integer, Integer> targetingTracker = new HashMap<Integer, Integer>();
    private static final Map<UUID, Map<String, Integer>> targetWarnings = new HashMap<UUID, Map<String, Integer>>();
    private static final int ARMOR_REPAIR_AMOUNT = 16;

    @SubscribeEvent
    public void onMobTargetSet(LivingSetAttackTargetEvent event) {
        int mobId = event.getEntityLiving().func_145782_y();
        if (event.getTarget() instanceof ServerPlayerEntity) {
            CommonArmorHandler handler;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getTarget();
            if (ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, EquipmentSlotType.HEAD) && (!targetingTracker.containsKey(mobId) || targetingTracker.get(mobId).intValue() != event.getTarget().func_145782_y()) && (handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player)).upgradeUsable(ArmorUpgradeRegistry.getInstance().entityTrackerHandler, true)) {
                Map map = targetWarnings.computeIfAbsent(player.func_110124_au(), k -> new HashMap());
                map.merge(event.getEntityLiving().func_200200_C_().getString(), 1, Integer::sum);
            }
            targetingTracker.put(mobId, event.getTarget().func_145782_y());
        } else {
            targetingTracker.remove(mobId);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        targetingTracker.remove(event.getEntityLiving().func_145782_y());
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (event.getDistance() > 3.0f && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            ItemStack stack = player.func_184582_a(EquipmentSlotType.FEET);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
            if (event.getEntity().field_70170_p.func_175659_aa() == Difficulty.HARD && jbState.isActive()) {
                event.setDamageMultiplier(0.2f);
                return;
            }
            if (handler.upgradeUsable(ArmorUpgradeRegistry.getInstance().jumpBoostHandler, true)) {
                event.setDistance(Math.max(0.0f, event.getDistance() - 1.5f * (float)handler.getUpgradeCount(EquipmentSlotType.LEGS, EnumUpgrade.JUMPING)));
                if (event.getDistance() < 2.0f) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (!player.field_70170_p.field_72995_K) {
                float airNeeded = event.getDistance() * 20.0f;
                int vol = stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(IAirHandler::getVolume).orElse(0);
                float airAvailable = (float)vol * handler.getArmorPressure(EquipmentSlotType.FEET);
                if (airAvailable < 1.0f) {
                    return;
                }
                if (airAvailable >= airNeeded) {
                    event.setCanceled(true);
                } else {
                    event.setDamageMultiplier(1.0f - airAvailable / airNeeded);
                }
                int i = 0;
                while ((float)i < event.getDistance() / 2.0f) {
                    float sx = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                    float sz = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sx, 0.1, sz), player.field_70170_p, player.func_233580_cy_());
                    ++i;
                }
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.SHORT_HISS.get(), SoundCategory.PLAYERS, 0.3f, 0.8f);
                handler.addAir(EquipmentSlotType.FEET, (int)(-airNeeded));
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        CommonArmorHandler handler;
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && ItemPneumaticArmor.isPneumaticArmorPiece(player = (PlayerEntity)event.getEntityLiving(), EquipmentSlotType.CHEST) && event.getSource().func_76347_k() && !player.func_184812_l_() && !player.func_175149_v() && (handler = CommonArmorHandler.getHandlerForPlayer(player)).isArmorEnabled() && handler.hasMinPressure(EquipmentSlotType.CHEST) && handler.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.SECURITY) > 0) {
            event.setCanceled(true);
            player.func_70066_B();
            if (!player.field_70170_p.field_72995_K) {
                handler.addAir(EquipmentSlotType.CHEST, -50);
                for (int i = 0; i < 2; ++i) {
                    float sx = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                    float sz = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.func_226277_ct_() + (double)sx, player.func_226278_cu_() + 1.0, player.func_226281_cx_() + (double)sz, sx / 4.0f, -0.2, sz / 4.0f), player.field_70170_p, player.func_233580_cy_());
                }
                if ((player.field_70173_aa & 0xF) == 0) {
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.LEAKING_GAS.get(), SoundCategory.PLAYERS, 1.0f, 0.7f);
                    this.tryExtinguish(player);
                }
            }
        }
    }

    private void tryExtinguish(PlayerEntity player) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos pos = player.func_233580_cy_().func_177982_a(i, 0, j);
                BlockState state = player.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150480_ab && player.func_70681_au().nextInt(3) == 0) {
                    player.field_70170_p.func_217377_a(pos, false);
                    continue;
                }
                if (state.func_177230_c() != Blocks.field_150353_l || player.func_70681_au().nextInt(5) != 0) continue;
                int level = (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b);
                player.field_70170_p.func_175656_a(pos, level == 0 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150347_e.func_176223_P());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = player.func_184582_a(EquipmentSlotType.LEGS);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (handler.upgradeUsable(ArmorUpgradeRegistry.getInstance().jetBootsHandler, true) && !handler.getExtensionData(ArmorUpgradeRegistry.getInstance().jetBootsHandler).isSmartHover()) {
                return;
            }
            if (handler.upgradeUsable(ArmorUpgradeRegistry.getInstance().jumpBoostHandler, true)) {
                float power = (float)ItemPneumaticArmor.getIntData(stack, "jumpBoost", 100, 0, 100) / 100.0f;
                int rangeUpgrades = handler.getUpgradeCount(EquipmentSlotType.LEGS, EnumUpgrade.JUMPING, player.func_225608_bj_() ? 1 : 4);
                float actualBoost = Math.max(1.0f, (float)rangeUpgrades * power);
                Vector3d m = player.func_213322_ci();
                double scale = player.func_70051_ag() ? (double)actualBoost : (double)actualBoost * 0.6;
                player.func_213293_j(m.field_72450_a * scale, m.field_72448_b + (double)(actualBoost * 0.15f), m.field_72449_c * scale);
                int airUsed = (int)Math.ceil(25.0f * actualBoost * (float)(player.func_70051_ag() ? 2 : 1));
                handler.addAir(EquipmentSlotType.LEGS, -airUsed);
            }
        }
    }

    @SubscribeEvent
    public void breakSpeedCheck(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        int max = 5;
        if (ItemPneumaticArmor.isPneumaticArmorPiece(player, EquipmentSlotType.FEET) && !player.func_233570_aj_()) {
            int n;
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(event.getPlayer());
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
            if (jbState.isEnabled() && jbState.isBuilderMode() && (n = max + 1 - handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS, max)) < 4) {
                float newSpeed;
                float mult = 5.0f / (float)n;
                float oldSpeed = event.getOriginalSpeed();
                if (oldSpeed < (newSpeed = event.getNewSpeed()) * mult) {
                    event.setNewSpeed(newSpeed * mult);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        CommonArmorHandler handler;
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && ItemPneumaticArmor.isPneumaticArmorPiece(player = (PlayerEntity)event.getEntity(), EquipmentSlotType.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(player)).hasMinPressure(EquipmentSlotType.FEET) && handler.isArmorReady(EquipmentSlotType.FEET)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.player.field_70170_p.field_72995_K) {
            this.handleJetbootsPose(event.player);
        } else if (event.player instanceof ServerPlayerEntity && event.player.field_70170_p.func_82737_E() % 20L == 0L && ItemPneumaticArmor.isPneumaticArmorPiece(event.player, EquipmentSlotType.HEAD)) {
            this.handleTargetWarnings((ServerPlayerEntity)event.player);
        }
    }

    private void handleJetbootsPose(PlayerEntity thisPlayer) {
        JetBootsStateTracker tracker = JetBootsStateTracker.getClientTracker();
        int distThresholdSq = ClientUtils.getRenderDistanceThresholdSq();
        for (PlayerEntity otherPlayer : thisPlayer.field_70170_p.func_217369_A()) {
            JetBootsStateTracker.JetBootsState state;
            if (otherPlayer.func_233570_aj_() || !ItemPneumaticArmor.isPneumaticArmorPiece(otherPlayer, EquipmentSlotType.FEET) || (state = tracker.getJetBootsState(otherPlayer)) == null || !state.isEnabled() || otherPlayer.func_184613_cA() && !state.isActive() || !(otherPlayer.func_70068_e((Entity)thisPlayer) < (double)distThresholdSq) || otherPlayer.func_145782_y() == thisPlayer.func_145782_y() || !state.shouldRotatePlayer()) continue;
            otherPlayer.func_213301_b(Pose.FALL_FLYING);
        }
    }

    private void handleTargetWarnings(ServerPlayerEntity player) {
        Map<String, Integer> map = targetWarnings.get(player.func_110124_au());
        if (map != null) {
            map.forEach((name, count) -> {
                TranslationTextComponent msg = PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.targetWarning", name);
                if (count > 1) {
                    msg.func_240702_b_(" (x" + count + ")");
                }
                NetworkHandler.sendToPlayer(new PacketSendArmorHUDMessage((ITextComponent)msg, 60, 1895776256), player);
            });
            map.clear();
        }
    }

    @SubscribeEvent
    public void onArmorRepair(AnvilUpdateEvent event) {
        if (event.getLeft().func_77973_b() instanceof ItemPneumaticArmor && PneumaticCraftTags.Items.INGOTS_COMPRESSED_IRON.func_230235_a_((Object)event.getRight().func_77973_b())) {
            ItemStack repairedItem = event.getLeft().func_77946_l();
            int damageRepaired = Math.min(repairedItem.func_77952_i(), event.getRight().func_190916_E() * 16);
            int ingotsToUse = (damageRepaired - 1) / 16 + 1;
            repairedItem.func_196085_b(repairedItem.func_77952_i() - damageRepaired);
            event.setOutput(repairedItem);
            event.setCost(Math.max(1, ingotsToUse / 2));
            event.setMaterialCost(ingotsToUse);
        }
    }

    @SubscribeEvent
    public void onPlayerTrack(PlayerEvent.StartTracking event) {
        CommonArmorHandler handler;
        ServerPlayerEntity trackedPlayer;
        if (event.getPlayer() instanceof ServerPlayerEntity && event.getTarget() instanceof ServerPlayerEntity && (trackedPlayer = (ServerPlayerEntity)event.getTarget()).func_184582_a(EquipmentSlotType.FEET).func_77973_b() == ModItems.PNEUMATIC_BOOTS.get() && (handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)trackedPlayer)).getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) > 0) {
            JetBootsStateTracker.JetBootsState state = JetBootsStateTracker.getServerTracker().getJetBootsState((PlayerEntity)trackedPlayer);
            NetworkHandler.sendToPlayer(new PacketJetBootsStateSync((PlayerEntity)trackedPlayer, state), (ServerPlayerEntity)event.getPlayer());
        }
    }
}

