/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.PressureHelper;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.capabilities.BasicAirHandler;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketBlockDestroyed;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class MachineAirHandler
extends BasicAirHandler
implements IAirHandlerMachine,
IManoMeasurable {
    private final float dangerPressure;
    private final float criticalPressure;
    private int volumeUpgrades = 0;
    private boolean hasSecurityUpgrade = false;
    private final BitSet connectedFaces = new BitSet(6);
    private Direction leakDir = null;
    private Direction prevLeakDir = null;
    private boolean safetyLeak;
    private int prevAir;
    private final Map<Direction, LazyOptional<IAirHandlerMachine>> neighbourAirHandlers = new EnumMap<Direction, LazyOptional<IAirHandlerMachine>>(Direction.class);

    public MachineAirHandler(float dangerPressure, float criticalPressure, int volume) {
        super(volume);
        this.dangerPressure = dangerPressure;
        this.criticalPressure = criticalPressure;
        for (Direction dir : DirectionUtil.VALUES) {
            this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty());
        }
    }

    @Override
    public int getVolume() {
        return PressureHelper.getUpgradedVolume(this.getBaseVolume(), this.volumeUpgrades);
    }

    @Override
    public float getDangerPressure() {
        return this.dangerPressure;
    }

    @Override
    public float getCriticalPressure() {
        return this.criticalPressure;
    }

    @Override
    public void setPressure(float pressure) {
        this.addAir((int)(pressure * (float)this.getVolume()) - this.getAir());
    }

    @Override
    public void setVolumeUpgrades(int newVolumeUpgrades) {
        int newVolume = PressureHelper.getUpgradedVolume(this.getBaseVolume(), newVolumeUpgrades);
        if (newVolume < this.getVolume()) {
            int newAir = (int)((float)this.getAir() * (float)newVolume / (float)this.getVolume());
            this.addAir(newAir - this.getAir());
        }
        this.volumeUpgrades = newVolumeUpgrades;
    }

    @Override
    public void setHasSecurityUpgrade(boolean hasSecurityUpgrade) {
        this.hasSecurityUpgrade = hasSecurityUpgrade;
    }

    @Override
    public void setConnectedFaces(List<Direction> sides) {
        this.connectedFaces.clear();
        sides.forEach(side -> this.connectedFaces.set(side.func_176745_a()));
        for (Direction dir : DirectionUtil.VALUES) {
            this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty());
        }
    }

    @Override
    public void tick(TileEntity ownerTE) {
        World world = ownerTE.func_145831_w();
        Direction actualLeakDir = this.leakDir;
        if (!world.field_72995_K) {
            this.disperseAir(ownerTE);
            BlockPos pos = ownerTE.func_174877_v();
            if (this.hasSecurityUpgrade) {
                float pressure = this.getPressure();
                if (!this.safetyLeak && pressure >= this.dangerPressure) {
                    this.safetyLeak = true;
                } else if (this.safetyLeak && (double)pressure < (double)this.dangerPressure - 0.2) {
                    this.safetyLeak = false;
                }
                if (pressure >= this.criticalPressure) {
                    int wanted = (int)(this.criticalPressure * (float)this.getVolume());
                    this.addAir(wanted - this.getAir());
                }
            } else if (world.func_73046_m().func_71259_af() > 20) {
                this.doOverpressureChecks(ownerTE, world, pos);
            }
            Direction direction = actualLeakDir = this.safetyLeak ? this.anyClearDirection(world, pos) : this.leakDir;
            if (this.prevLeakDir != actualLeakDir || actualLeakDir != null && (world.func_82737_E() & 0x1FL) == 0L) {
                NetworkHandler.sendToAllTracking((Object)new PacketUpdatePressureBlock(ownerTE, this.anyConnectedFace(), actualLeakDir, this.getAir()), ownerTE);
            }
            this.prevAir = this.getAir();
            this.prevLeakDir = actualLeakDir;
        }
        if (actualLeakDir != null && this.getAir() != 0) {
            this.handleAirLeak(ownerTE, actualLeakDir);
        }
    }

    private Direction anyClearDirection(World world, BlockPos pos) {
        for (Direction d : DirectionUtil.VALUES) {
            if (Block.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177972_a(d), (Direction)d.func_176734_d())) continue;
            return d;
        }
        return Direction.UP;
    }

    private Direction anyConnectedFace() {
        for (Direction d : DirectionUtil.VALUES) {
            if (!this.connectedFaces.get(d.func_176745_a())) continue;
            return d;
        }
        return null;
    }

    private void doOverpressureChecks(TileEntity ownerTE, World world, BlockPos pos) {
        float p = this.getPressure();
        if (this.getAir() > this.prevAir && p > this.dangerPressure) {
            float range = this.criticalPressure - this.dangerPressure;
            float delta = p - this.dangerPressure;
            float rnd = world.field_73012_v.nextFloat() * range;
            if (rnd < delta / 125.0f || p > this.criticalPressure) {
                world.func_217385_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0f, Explosion.Mode.BREAK);
                world.func_175655_b(pos, false);
                NetworkHandler.sendToAllTracking(new PacketBlockDestroyed(pos), world, pos);
            } else if (rnd < delta / 25.0f) {
                world.func_184133_a(null, ownerTE.func_174877_v(), (SoundEvent)ModSounds.CREAK.get(), SoundCategory.BLOCKS, 0.7f, 0.6f + world.field_73012_v.nextFloat() * 0.8f);
            }
        }
    }

    private void handleAirLeak(TileEntity ownerTE, Direction actualLeakDir) {
        World world = ownerTE.func_145831_w();
        BlockPos pos = ownerTE.func_174877_v();
        float pressure = this.getPressure();
        if (!world.field_72995_K) {
            if (this.getAir() > 0) {
                int leakedAmount = (int)(pressure * 40.0f) + 20;
                if (leakedAmount > this.getAir()) {
                    leakedAmount = this.getAir();
                }
                this.onAirDispersion(ownerTE, this.leakDir, -leakedAmount);
                this.addAir(-leakedAmount);
            } else if (this.getAir() < 0) {
                int leakedAmount = -((int)(pressure * 40.0f)) + 20;
                if (this.getAir() > leakedAmount) {
                    leakedAmount = -this.getAir();
                }
                this.onAirDispersion(ownerTE, this.leakDir, leakedAmount);
                this.addAir(leakedAmount);
            }
        } else {
            double mx = actualLeakDir.func_82601_c();
            double my = actualLeakDir.func_96559_d();
            double mz = actualLeakDir.func_82599_e();
            double speed = this.getPressure() * 0.1f;
            if (this.getAir() > 0) {
                if (pressure > 1.0f || pressure > 0.5f && world.field_73012_v.nextBoolean() || world.field_73012_v.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)AirParticleData.DENSE, (double)pos.func_177958_n() + 0.5 + mx * 0.6, (double)pos.func_177956_o() + 0.5 + my * 0.6, (double)pos.func_177952_p() + 0.5 + mz * 0.6, mx * speed, my * speed, mz * speed);
                }
            } else if (this.getAir() < 0 && world.field_73012_v.nextBoolean()) {
                world.func_195594_a((IParticleData)AirParticleData.NORMAL, (double)pos.func_177958_n() + 0.5 + mx, (double)pos.func_177956_o() + 0.5 + my, (double)pos.func_177952_p() + 0.5 + mz, mx * speed, my * speed, mz * speed);
            }
            MovingSounds.playMovingSound(MovingSounds.Sound.AIR_LEAK, ownerTE.func_174877_v(), this.anyConnectedFace());
        }
    }

    @Override
    public void setSideLeaking(@Nullable Direction dir) {
        this.leakDir = dir;
    }

    @Override
    @Nullable
    public Direction getSideLeaking() {
        return this.leakDir;
    }

    private LazyOptional<IAirHandlerMachine> getNeighbourAirHandler(TileEntity ownerTE, Direction dir) {
        if (!this.connectedFaces.get(dir.func_176745_a())) {
            return LazyOptional.empty();
        }
        if (!this.neighbourAirHandlers.get(dir).isPresent()) {
            TileEntity te1 = ownerTE.func_145831_w().func_175625_s(ownerTE.func_174877_v().func_177972_a(dir));
            if (te1 != null) {
                LazyOptional cap = te1.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.func_176734_d());
                if (cap.isPresent()) {
                    this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)cap);
                    this.neighbourAirHandlers.get(dir).addListener(l -> this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty()));
                }
            } else {
                this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty());
            }
        }
        return this.neighbourAirHandlers.get(dir);
    }

    private void disperseAir(TileEntity ownerTE) {
        List<IAirHandlerMachine.Connection> neighbours = this.getConnectedAirHandlers(ownerTE, true);
        int totalVolume = this.getVolume();
        int totalAir = this.getAir();
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            totalVolume += neighbour.getAirHandler().getVolume();
            totalAir += neighbour.getAirHandler().getAir();
        }
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            int totalMachineAir = (int)((long)totalAir * (long)neighbour.getAirHandler().getVolume() / (long)totalVolume);
            neighbour.setMaxDispersion(this.getMaxDispersion(ownerTE, neighbour.getDirection()));
            neighbour.setAirToDisperse(Math.max(0, totalMachineAir - neighbour.getAirHandler().getAir()));
        }
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            int air = Math.min(neighbour.getMaxDispersion(), neighbour.getDispersedAir());
            if (air == 0) continue;
            this.onAirDispersion(ownerTE, neighbour.getDirection(), air);
            neighbour.getAirHandler().addAir(air);
            this.addAir(-air);
        }
    }

    private List<IAirHandlerMachine.Connection> getConnectedAirHandlers(TileEntity ownerTE, boolean onlyLowerPressure) {
        ArrayList<IAirHandlerMachine.Connection> neighbours = new ArrayList<IAirHandlerMachine.Connection>();
        for (Direction dir : DirectionUtil.VALUES) {
            if (!this.connectedFaces.get(dir.func_176745_a())) continue;
            this.getNeighbourAirHandler(ownerTE, dir).ifPresent(h -> {
                if (!onlyLowerPressure || h.getPressure() < this.getPressure()) {
                    neighbours.add(new ConnectedAirHandler(dir, (IAirHandlerMachine)h));
                }
            });
        }
        neighbours.addAll(this.addExtraConnectedHandlers(ownerTE).stream().filter(h -> !onlyLowerPressure || h.getPressure() < this.getPressure()).map(ConnectedAirHandler::new).collect(Collectors.toList()));
        return neighbours;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        if (this.leakDir != null) {
            nbt.func_74774_a("Leaking", (byte)this.leakDir.func_176745_a());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.leakDir = nbt.func_74764_b("Leaking") ? Direction.func_82600_a((int)nbt.func_74771_c("Leaking")) : null;
    }

    @Override
    public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(TileEntity ownerTE) {
        return this.getConnectedAirHandlers(ownerTE, false);
    }

    private List<IAirHandlerMachine> addExtraConnectedHandlers(TileEntity ownerTE) {
        if (ownerTE instanceof IAirListener) {
            return ((IAirListener)ownerTE).addConnectedPneumatics(new ArrayList<IAirHandlerMachine>());
        }
        return Collections.emptyList();
    }

    private void onAirDispersion(TileEntity ownerTE, Direction dir, int airDispersed) {
        if (ownerTE instanceof IAirListener) {
            ((IAirListener)ownerTE).onAirDispersion(this, dir, airDispersed);
        }
    }

    private int getMaxDispersion(TileEntity ownerTE, Direction dir) {
        if (ownerTE instanceof IAirListener) {
            return ((IAirListener)ownerTE).getMaxDispersion(this, dir);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void printManometerMessage(PlayerEntity player, List<ITextComponent> curInfo) {
        curInfo.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.tooltip.pressure", new Object[]{PneumaticCraftUtils.roundNumberTo(this.getPressure(), 1)}));
    }

    private static class ConnectedAirHandler
    implements IAirHandlerMachine.Connection {
        final Direction direction;
        final IAirHandlerMachine airHandler;
        int maxDispersion;
        int toDisperse;

        ConnectedAirHandler(Direction direction, IAirHandlerMachine airHandler) {
            this.direction = direction;
            this.airHandler = airHandler;
        }

        ConnectedAirHandler(IAirHandlerMachine airHandler) {
            this(null, airHandler);
        }

        @Override
        public Direction getDirection() {
            return this.direction;
        }

        @Override
        public int getMaxDispersion() {
            return this.maxDispersion;
        }

        @Override
        public void setMaxDispersion(int maxDispersion) {
            this.maxDispersion = maxDispersion;
        }

        @Override
        public int getDispersedAir() {
            return this.toDisperse;
        }

        @Override
        public void setAirToDisperse(int toDisperse) {
            this.toDisperse = toDisperse;
        }

        @Override
        public IAirHandlerMachine getAirHandler() {
            return this.airHandler;
        }
    }
}

