/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAdvancedPressureTube;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPressureTube
extends BlockPneumaticCraftCamo
implements IWaterLoggable {
    private static final int TUBE_WIDTH = 2;
    public static final int CORE_MIN = 6;
    public static final int CORE_MAX = 10;
    private static final double PLUG_SIZE = 2.5;
    private static final VoxelShape CORE = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape[] ARM_CONNECTED = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), Block.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)};
    private static final VoxelShape[] ARM_CLOSED = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)3.5, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)12.5, (double)10.0), Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)3.5), Block.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)12.5), Block.func_208617_a((double)3.5, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)12.5, (double)10.0, (double)10.0)};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[729];
    private static final EnumProperty<ConnectionType> UP_3 = EnumProperty.func_177709_a((String)"up", ConnectionType.class);
    private static final EnumProperty<ConnectionType> DOWN_3 = EnumProperty.func_177709_a((String)"down", ConnectionType.class);
    private static final EnumProperty<ConnectionType> NORTH_3 = EnumProperty.func_177709_a((String)"north", ConnectionType.class);
    private static final EnumProperty<ConnectionType> EAST_3 = EnumProperty.func_177709_a((String)"east", ConnectionType.class);
    private static final EnumProperty<ConnectionType> SOUTH_3 = EnumProperty.func_177709_a((String)"south", ConnectionType.class);
    private static final EnumProperty<ConnectionType> WEST_3 = EnumProperty.func_177709_a((String)"west", ConnectionType.class);
    private static final EnumProperty<ConnectionType>[] CONNECTION_PROPERTIES_3 = new EnumProperty[]{DOWN_3, UP_3, NORTH_3, SOUTH_3, WEST_3, EAST_3};
    private final Tier tier;

    public BlockPressureTube(Tier tier) {
        super(ModBlocks.defaultProps().func_226896_b_());
        this.tier = tier;
        BlockState state = (BlockState)this.func_176194_O().func_177621_b();
        for (EnumProperty<ConnectionType> p : CONNECTION_PROPERTIES_3) {
            state = (BlockState)state.func_206870_a(p, (Comparable)((Object)ConnectionType.UNCONNECTED));
        }
        this.func_180632_j((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return this.tier.teClass;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(CONNECTION_PROPERTIES_3);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        FluidState fluidState;
        BlockState state = this.func_176223_P();
        ArrayList<Direction> l = new ArrayList<Direction>();
        for (Direction dir : DirectionUtil.VALUES) {
            TileEntity te = ctx.func_195991_k().func_175625_s(ctx.func_195995_a().func_177972_a(dir));
            if (te == null || !te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.func_176734_d()).isPresent()) continue;
            state = BlockPressureTube.setSide(state, dir, ConnectionType.CONNECTED);
            l.add(dir);
        }
        if (l.size() == 1) {
            state = BlockPressureTube.setSide(state, ((Direction)l.get(0)).func_176734_d(), ConnectionType.CONNECTED);
        }
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf((fluidState = ctx.func_195991_k().func_204610_c(ctx.func_195995_a())).func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState;
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return (newState = BlockPressureTube.recalculateState(worldIn, currentPos, stateIn)) == null ? super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos) : newState;
    }

    public static BlockState recalculateState(IWorld worldIn, BlockPos currentPos, BlockState stateIn) {
        TileEntityPressureTube tePT = BlockPressureTube.getPressureTube((IBlockReader)worldIn, currentPos);
        if (tePT != null) {
            tePT.clearCachedShape();
            BlockState state = stateIn;
            for (Direction dir : DirectionUtil.VALUES) {
                TileEntity neighbourTE;
                ConnectionType type = ConnectionType.UNCONNECTED;
                if (tePT.isSideClosed(dir)) {
                    type = ConnectionType.CLOSED;
                } else if (tePT.canConnectPneumatic(dir) && (neighbourTE = worldIn.func_175625_s(currentPos.func_177972_a(dir))) != null && neighbourTE.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.func_176734_d()).isPresent()) {
                    type = ConnectionType.CONNECTED;
                }
                state = BlockPressureTube.setSide(state, dir, type);
            }
            return BlockPressureTube.checkForSingleConnection(tePT, state);
        }
        return stateIn;
    }

    private static BlockState checkForSingleConnection(TileEntityPressureTube te, BlockState state) {
        ArrayList<Direction> connected = new ArrayList<Direction>();
        int nUnconnected = 0;
        for (Direction dir : DirectionUtil.VALUES) {
            if (te.getModule(dir) != null) {
                return state;
            }
            switch ((ConnectionType)((Object)state.func_177229_b(CONNECTION_PROPERTIES_3[dir.func_176745_a()]))) {
                case CONNECTED: {
                    connected.add(dir);
                    break;
                }
                case UNCONNECTED: {
                    ++nUnconnected;
                    break;
                }
                case CLOSED: {
                    return state;
                }
            }
            if (connected.size() > 1) break;
        }
        if (nUnconnected == 5 && connected.size() == 1) {
            state = BlockPressureTube.setSide(state, ((Direction)connected.get(0)).func_176734_d(), ConnectionType.CONNECTED);
        }
        return state;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        VoxelShape res = this.getCachedShape(state);
        TileEntityPressureTube te = BlockPressureTube.getPressureTube(reader, pos);
        return te != null ? te.getCachedTubeShape(res) : res;
    }

    private VoxelShape getCachedShape(BlockState state) {
        int idx = 0;
        int mul = 1;
        for (Direction d : Direction.values()) {
            idx += ((ConnectionType)((Object)state.func_177229_b(CONNECTION_PROPERTIES_3[d.func_176745_a()]))).getIndex() * mul;
            mul *= 3;
        }
        if (SHAPE_CACHE[idx] == null) {
            VoxelShape res = CORE;
            block5: for (Direction d : Direction.values()) {
                switch ((ConnectionType)((Object)state.func_177229_b(CONNECTION_PROPERTIES_3[d.func_176745_a()]))) {
                    case CONNECTED: {
                        res = VoxelShapes.func_197878_a((VoxelShape)res, (VoxelShape)ARM_CONNECTED[d.func_176745_a()], (IBooleanFunction)IBooleanFunction.field_223244_o_);
                        continue block5;
                    }
                    case CLOSED: {
                        res = VoxelShapes.func_197878_a((VoxelShape)res, (VoxelShape)ARM_CLOSED[d.func_176745_a()], (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                }
            }
            BlockPressureTube.SHAPE_CACHE[idx] = res;
        }
        return SHAPE_CACHE[idx];
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        TubeModule module;
        if (this.tryPlaceModule(player, world, pos, brtr.func_216354_b(), hand, false)) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_225608_bj_() && (module = BlockPressureTube.getFocusedModule(world, pos, player)) != null) {
            return module.onActivated(player, hand) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, brtr);
    }

    public int getTier() {
        return this.tier.tier;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        ModuleNetworkManager.getInstance(world).invalidateCache();
        TileEntityPressureTube te = BlockPressureTube.getPressureTube((IBlockReader)world, pos);
        if (te != null) {
            te.onNeighborTileUpdate(null);
        }
    }

    public boolean tryPlaceModule(PlayerEntity player, World world, BlockPos pos, Direction side, Hand hand, boolean simulate) {
        TubeModule module;
        TileEntityPressureTube tePT = BlockPressureTube.getPressureTube((IBlockReader)world, pos);
        if (tePT == null) {
            return false;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() instanceof ItemTubeModule) {
            TubeModule module2 = ((ItemTubeModule)heldStack.func_77973_b()).createModule();
            if (tePT.mayPlaceModule(side)) {
                if (simulate) {
                    module2.markFake();
                }
                tePT.setModule(side, module2);
                if (!simulate && !world.field_72995_K) {
                    this.func_220069_a(world.func_180495_p(pos), world, pos, this, pos.func_177972_a(side), false);
                    world.func_195593_d(pos, (Block)this);
                    if (!player.func_184812_l_()) {
                        heldStack.func_190918_g(1);
                    }
                    world.func_184133_a(null, pos, SoundType.field_185853_f.func_185844_d(), SoundCategory.BLOCKS, SoundType.field_185853_f.func_185843_a() * 5.0f, SoundType.field_185853_f.func_185847_b() * 0.9f);
                    if (module2 instanceof INetworkedModule) {
                        ModuleNetworkManager.getInstance(world).invalidateCache();
                    }
                }
                if (!simulate) {
                    module2.onPlaced();
                }
                return true;
            }
        } else if (heldStack.func_77973_b() == ModItems.ADVANCED_PCB.get() && !simulate && (module = BlockPressureTube.getFocusedModule(world, pos, player)) != null && !module.isUpgraded() && module.canUpgrade()) {
            if (!world.field_72995_K) {
                module.upgrade();
                tePT.sendDescriptionPacket();
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    public static TubeModule getFocusedModule(World world, BlockPos pos, PlayerEntity player) {
        Pair<Vector3d, Vector3d> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockState state = world.func_180495_p(pos);
        BlockRayTraceResult rayTraceResult = BlockPressureTube.doTrace(state, (IBlockReader)world, pos, (Vector3d)vecs.getLeft(), (Vector3d)vecs.getRight());
        TubeHitInfo tubeHitInfo = BlockPressureTube.getHitInfo((RayTraceResult)rayTraceResult);
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE) {
            TileEntityPressureTube tube = BlockPressureTube.getPressureTube((IBlockReader)world, pos);
            return tube == null ? null : tube.getModule(tubeHitInfo.dir);
        }
        return null;
    }

    private static BlockState setSide(BlockState state, Direction side, ConnectionType type) {
        return (BlockState)state.func_206870_a(CONNECTION_PROPERTIES_3[side.func_176745_a()], (Comparable)((Object)type));
    }

    private static TileEntityPressureTube getPressureTube(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityPressureTube ? (TileEntityPressureTube)te : null;
    }

    private static Pair<Boolean, Direction> getLookedTube(IBlockReader world, BlockPos pos, PlayerEntity player) {
        Pair<Vector3d, Vector3d> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockState state = world.func_180495_p(pos);
        BlockRayTraceResult rayTraceResult = BlockPressureTube.doTrace(state, world, pos, (Vector3d)vecs.getLeft(), (Vector3d)vecs.getRight());
        TubeHitInfo tubeHitInfo = BlockPressureTube.getHitInfo((RayTraceResult)rayTraceResult);
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return tubeHitInfo.dir == null ? Pair.of((Object)true, (Object)Objects.requireNonNull(rayTraceResult).func_216354_b()) : Pair.of((Object)false, (Object)tubeHitInfo.dir);
        }
        return null;
    }

    private static BlockRayTraceResult doTrace(BlockState state, IBlockReader world, BlockPos pos, Vector3d origin, Vector3d direction) {
        TileEntityPressureTube tube;
        BlockRayTraceResult bestRTR = null;
        BlockRayTraceResult brtr = AxisAlignedBB.func_197743_a(Collections.singletonList(CORE.func_197752_a()), (Vector3d)origin, (Vector3d)direction, (BlockPos)pos);
        if (brtr != null) {
            brtr.hitInfo = TubeHitInfo.CENTER;
            bestRTR = brtr;
        }
        if ((tube = BlockPressureTube.getPressureTube(world, pos)) == null) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            AxisAlignedBB arm;
            switch ((ConnectionType)((Object)state.func_177229_b(CONNECTION_PROPERTIES_3[i]))) {
                case CLOSED: {
                    arm = ARM_CLOSED[i].func_197752_a();
                    break;
                }
                case CONNECTED: {
                    arm = ARM_CONNECTED[i].func_197752_a();
                    break;
                }
                default: {
                    arm = null;
                }
            }
            if (arm == null || (brtr = AxisAlignedBB.func_197743_a(Collections.singletonList(arm), (Vector3d)origin, (Vector3d)direction, (BlockPos)pos)) == null || !BlockPressureTube.isCloserIntersection(origin, (RayTraceResult)bestRTR, (RayTraceResult)brtr)) continue;
            brtr.hitInfo = new TubeHitInfo(Direction.func_82600_a((int)i), TubeHitInfo.PartType.TUBE);
            bestRTR = brtr;
        }
        for (Direction dir : DirectionUtil.VALUES) {
            AxisAlignedBB tubeAABB;
            TubeModule tm = tube.getModule(dir);
            if (tm == null || !BlockPressureTube.isCloserIntersection(origin, (RayTraceResult)bestRTR, (RayTraceResult)(brtr = AxisAlignedBB.func_197743_a(Collections.singletonList(tubeAABB = tm.getShape().func_197752_a()), (Vector3d)origin, (Vector3d)direction, (BlockPos)pos)))) continue;
            brtr.hitInfo = new TubeHitInfo(dir, TubeHitInfo.PartType.MODULE);
            bestRTR = brtr;
        }
        return bestRTR;
    }

    private static boolean isCloserIntersection(Vector3d origin, RayTraceResult oldRTR, RayTraceResult newRTR) {
        return newRTR != null && (oldRTR == null || origin.func_72436_e(newRTR.func_216347_e()) <= origin.func_72436_e(oldRTR.func_216347_e()));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TubeModule tm;
        TileEntityPressureTube tube;
        Pair<Vector3d, Vector3d> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockRayTraceResult rayTraceResult = BlockPressureTube.doTrace(state, world, pos, (Vector3d)vecs.getLeft(), (Vector3d)vecs.getRight());
        TubeHitInfo tubeHitInfo = BlockPressureTube.getHitInfo((RayTraceResult)rayTraceResult);
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE && (tube = BlockPressureTube.getPressureTube(world, pos)) != null && (tm = tube.getModule(tubeHitInfo.dir)) != null) {
            return new ItemStack((IItemProvider)tm.getItem());
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean onWrenched(World world, PlayerEntity player, BlockPos pos, Direction side, Hand hand) {
        if (player == null) {
            return false;
        }
        TileEntityPressureTube tube = BlockPressureTube.getPressureTube((IBlockReader)world, pos);
        if (tube == null) {
            return false;
        }
        TubeModule module = BlockPressureTube.getFocusedModule(world, pos, player);
        if (player.func_225608_bj_()) {
            if (module != null) {
                if (!player.func_184812_l_()) {
                    for (ItemStack drop : module.getDrops()) {
                        ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        entity.func_92058_a(drop);
                        world.func_217376_c((Entity)entity);
                        entity.func_70100_b_(player);
                    }
                }
                tube.setModule(module.getDirection(), null);
                this.func_220069_a(world.func_180495_p(pos), world, pos, this, pos.func_177972_a(side), false);
                world.func_195593_d(pos, (Block)this);
            } else {
                if (!player.func_184812_l_()) {
                    BlockPressureTube.func_220059_a((BlockState)world.func_180495_p(pos), (IWorld)world, (BlockPos)pos, (TileEntity)tube);
                }
                BlockPressureTube.removeBlockSneakWrenched(world, pos);
            }
        } else if (module != null) {
            module.onActivated(player, hand);
        } else {
            Pair<Boolean, Direction> lookData = BlockPressureTube.getLookedTube((IBlockReader)world, pos, player);
            if (lookData != null) {
                Direction sideHit;
                tube.setSideClosed(sideHit, !tube.isSideClosed(sideHit = (Direction)lookData.getRight()));
                tube.onNeighborBlockUpdate(pos.func_177972_a(sideHit));
                world.func_175656_a(pos, BlockPressureTube.recalculateState((IWorld)world, pos, world.func_180495_p(pos)));
            }
        }
        ModuleNetworkManager.getInstance(world).invalidateCache();
        return true;
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c()) {
            BlockPressureTube.getModuleDrops(BlockPressureTube.getPressureTube((IBlockReader)world, pos)).forEach(drop -> world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop)));
            ModuleNetworkManager.getInstance(world).invalidateCache();
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private static NonNullList<ItemStack> getModuleDrops(TileEntityPressureTube tube) {
        NonNullList drops = NonNullList.func_191196_a();
        if (tube != null) {
            tube.tubeModules().map(TubeModule::getDrops).forEach(arg_0 -> drops.addAll(arg_0));
        }
        return drops;
    }

    public int func_180656_a(BlockState state, IBlockReader par1IBlockAccess, BlockPos pos, Direction side) {
        TileEntityPressureTube tePt = BlockPressureTube.getPressureTube(par1IBlockAccess, pos);
        if (tePt != null) {
            int redstoneLevel = 0;
            for (Direction face : DirectionUtil.VALUES) {
                TubeModule tm = tePt.getModule(face);
                if (tm == null || side.func_176734_d() != face && (face == side || !tm.isInline())) continue;
                redstoneLevel = Math.max(redstoneLevel, tm.getRedstoneLevel());
            }
            return redstoneLevel;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Nonnull
    private static TubeHitInfo getHitInfo(RayTraceResult result) {
        return result != null && result.hitInfo instanceof TubeHitInfo ? (TubeHitInfo)result.hitInfo : TubeHitInfo.NO_HIT;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        ConnectionType[] conns = new ConnectionType[DirectionUtil.HORIZONTALS.length];
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            conns[rotation.func_185831_a((Direction)dir).func_176736_b()] = (ConnectionType)((Object)state.func_177229_b(CONNECTION_PROPERTIES_3[dir.func_176745_a()]));
        }
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            state = (BlockState)state.func_206870_a(CONNECTION_PROPERTIES_3[dir.func_176745_a()], (Comparable)((Object)conns[dir.func_176736_b()]));
        }
        return super.func_185499_a(state, rotation);
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        ConnectionType[] conns = new ConnectionType[DirectionUtil.HORIZONTALS.length];
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            Rotation r = mirrorIn.func_185800_a(dir);
            conns[r.func_185831_a((Direction)dir).func_176736_b()] = (ConnectionType)((Object)state.func_177229_b(CONNECTION_PROPERTIES_3[dir.func_176745_a()]));
        }
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            state = (BlockState)state.func_206870_a(CONNECTION_PROPERTIES_3[dir.func_176745_a()], (Comparable)((Object)conns[dir.func_176736_b()]));
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public static enum ConnectionType implements IStringSerializable
    {
        UNCONNECTED(0, "open"),
        CONNECTED(1, "connected"),
        CLOSED(2, "closed");

        private final int index;
        private final String name;

        private ConnectionType(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class TubeHitInfo {
        static final TubeHitInfo NO_HIT = new TubeHitInfo(null, null);
        static final TubeHitInfo CENTER = new TubeHitInfo(null, PartType.TUBE);
        final Direction dir;
        final PartType type;

        TubeHitInfo(Direction dir, PartType type) {
            this.dir = dir;
            this.type = type;
        }

        static enum PartType {
            TUBE,
            MODULE;

        }
    }

    public static enum Tier {
        ONE(1, 5.0f, 7.0f, 1000, TileEntityPressureTube.class),
        TWO(2, 20.0f, 25.0f, 4000, TileEntityAdvancedPressureTube.class);

        private final int tier;
        final float dangerPressure;
        final float criticalPressure;
        final int volume;
        private final Class<? extends TileEntityPressureTube> teClass;

        private Tier(int tier, float dangerPressure, float criticalPressure, int volume, Class<? extends TileEntityPressureTube> teClass) {
            this.tier = tier;
            this.dangerPressure = dangerPressure;
            this.criticalPressure = criticalPressure;
            this.volume = volume;
            this.teClass = teClass;
        }
    }
}

