/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityDisplayTable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockDisplayTable
extends BlockPneumaticCraft {
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];
    private static final BooleanProperty NE = BooleanProperty.func_177716_a((String)"ne");
    private static final BooleanProperty SE = BooleanProperty.func_177716_a((String)"se");
    private static final BooleanProperty SW = BooleanProperty.func_177716_a((String)"sw");
    private static final BooleanProperty NW = BooleanProperty.func_177716_a((String)"nw");
    private static final VoxelShape TOP = BlockDisplayTable.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockDisplayTable() {
        super(ModBlocks.defaultProps());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)NE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NW, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NW, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NE, SW, SE, NW});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        if (state == null) {
            return null;
        }
        boolean[] connected = this.getConnections((IWorld)ctx.func_195991_k(), ctx.func_195995_a(), state);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).func_206870_a((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).func_206870_a((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).func_206870_a((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean[] connected = this.getConnections(worldIn, currentPos, stateIn);
        return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).func_206870_a((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).func_206870_a((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).func_206870_a((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
    }

    private VoxelShape getCachedShape(BlockState state) {
        int shapeIdx = ((Boolean)state.func_177229_b((Property)NE) != false ? 1 : 0) | ((Boolean)state.func_177229_b((Property)SE) != false ? 2 : 0) | ((Boolean)state.func_177229_b((Property)SW) != false ? 4 : 0) | ((Boolean)state.func_177229_b((Property)NW) != false ? 8 : 0);
        VoxelShape[] shapeCache = this.getShapeCache();
        if (shapeCache[shapeIdx] == null) {
            VoxelShape shape = this.adjustShapeForHeight(TOP);
            for (Leg leg : Leg.values()) {
                if (((Boolean)state.func_177229_b((Property)leg.prop)).booleanValue()) continue;
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)this.adjustShapeForHeight(leg.shape));
            }
            shapeCache[shapeIdx] = shape.func_197753_c();
        }
        return shapeCache[shapeIdx];
    }

    private VoxelShape adjustShapeForHeight(VoxelShape shape) {
        AxisAlignedBB aabb = shape.func_197752_a();
        return VoxelShapes.func_197873_a((double)aabb.field_72340_a, (double)Math.max(0.0, aabb.field_72338_b - (1.0 - this.getTableHeight())), (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)(aabb.field_72337_e - (1.0 - this.getTableHeight())), (double)aabb.field_72334_f);
    }

    public double getTableHeight() {
        return 1.0;
    }

    protected VoxelShape[] getShapeCache() {
        return SHAPE_CACHE;
    }

    protected boolean shelfLegs() {
        return false;
    }

    private boolean[] getConnections(IWorld world, BlockPos pos, BlockState state) {
        BlockPos below = pos.func_177977_b();
        if (this.shelfLegs() && !world.func_180495_p(below).func_224755_d((IBlockReader)world, below, Direction.UP)) {
            return new boolean[]{true, true, true, true};
        }
        boolean connE = this.isMatch(world, pos, state, Direction.EAST);
        boolean connW = this.isMatch(world, pos, state, Direction.WEST);
        boolean connS = this.isMatch(world, pos, state, Direction.SOUTH);
        boolean connN = this.isMatch(world, pos, state, Direction.NORTH);
        boolean[] res = new boolean[4];
        res[Leg.SE.ordinal()] = connE || connS;
        res[Leg.NE.ordinal()] = connE || connN;
        res[Leg.SW.ordinal()] = connW || connS;
        res[Leg.NW.ordinal()] = connW || connN;
        return res;
    }

    private boolean isMatch(IWorld world, BlockPos pos, BlockState state, Direction dir) {
        BlockState state2 = world.func_180495_p(pos.func_177972_a(dir));
        return state2.func_177230_c() == this && this.getRotation(state) == this.getRotation(state2);
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityDisplayTable.class;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getCachedShape(state);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        TileEntity te = world.func_175625_s(pos);
        ItemStack heldStack = player.func_184586_b(hand);
        if (player.func_225608_bj_() || te instanceof INamedContainerProvider || ModdedWrenchUtils.getInstance().isWrench(heldStack)) {
            return super.func_225533_a_(state, world, pos, player, hand, brtr);
        }
        if (te instanceof TileEntityDisplayTable) {
            if (!world.field_72995_K) {
                TileEntityDisplayTable teDT = (TileEntityDisplayTable)te;
                if (teDT.getPrimaryInventory().getStackInSlot(0).func_190926_b()) {
                    ItemStack excess = teDT.getPrimaryInventory().insertItem(0, player.func_184586_b(hand), false);
                    if (!player.func_184812_l_()) {
                        player.func_184611_a(hand, excess);
                    }
                } else {
                    ItemStack stack = teDT.getPrimaryInventory().extractItem(0, 64, false);
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + this.getTableHeight() + 0.1, (double)pos.func_177952_p() + 0.5);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    static /* synthetic */ BooleanProperty access$000() {
        return NE;
    }

    static /* synthetic */ BooleanProperty access$100() {
        return SE;
    }

    static /* synthetic */ BooleanProperty access$200() {
        return SW;
    }

    static /* synthetic */ BooleanProperty access$300() {
        return NW;
    }

    private static enum Leg {
        NE(1, -1, BlockDisplayTable.access$000(), Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0)),
        SE(1, 1, BlockDisplayTable.access$100(), Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0)),
        SW(-1, 1, BlockDisplayTable.access$200(), Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0)),
        NW(-1, -1, BlockDisplayTable.access$300(), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0));

        final int x;
        final int z;
        final BooleanProperty prop;
        final VoxelShape shape;

        private Leg(int x, int z, BooleanProperty prop, VoxelShape shape) {
            this.x = x;
            this.z = z;
            this.prop = prop;
            this.shape = shape;
        }
    }
}

