/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.common.ai.NodeProcessorDrone;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticleTrail;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityPathNavigateDrone
extends FlyingPathNavigator
implements IPathNavigator {
    private final EntityDrone droneEntity;
    private boolean forceTeleport;
    private int teleportCounter = -1;
    private BlockPos telPos;
    private static final int TELEPORT_TICKS = 120;
    private int stuckTicks = 0;

    public EntityPathNavigateDrone(EntityDrone droneEntity, World world) {
        super((MobEntity)droneEntity, world);
        this.droneEntity = droneEntity;
    }

    public boolean func_75497_a(Entity p_75497_1_, double p_75497_2_) {
        return super.func_75497_a(p_75497_1_, p_75497_2_) || this.isGoingToTeleport();
    }

    public Path func_75494_a(Entity par1Entity, int p2) {
        BlockPos pos = new BlockPos(par1Entity.func_226277_ct_(), par1Entity.func_174813_aQ().field_72338_b, par1Entity.func_226281_cx_());
        if ((par1Entity instanceof ItemEntity && !this.droneEntity.isBlockValidPathfindBlock(pos) || par1Entity instanceof AbstractMinecartEntity) && this.droneEntity.isBlockValidPathfindBlock(pos.func_177984_a())) {
            pos = pos.func_177984_a();
        }
        return this.func_179680_a(pos, p2);
    }

    void setForceTeleport(boolean forceTeleport) {
        this.forceTeleport = forceTeleport;
    }

    @Nullable
    public Path func_179680_a(BlockPos pos, int p2) {
        PathPoint lastPoint;
        Path path;
        if (!this.droneEntity.isBlockValidPathfindBlock(pos)) {
            return null;
        }
        if (this.droneEntity.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 0.75) {
            return new Path((List)Lists.newArrayList((Object[])new PathPoint[]{new PathPoint(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())}), pos, true);
        }
        this.telPos = pos;
        if (this.forceTeleport) {
            this.teleportCounter = 0;
            return null;
        }
        this.droneEntity.setStandby(false);
        boolean tallBlockKludge = false;
        BlockPos below = pos.func_177977_b();
        VoxelShape shape = this.field_75513_b.func_180495_p(below).func_196952_d((IBlockReader)this.field_75513_b, below);
        if (!shape.func_197766_b() && shape.func_197752_a().field_72337_e > 1.0) {
            path = super.func_179680_a(pos, 1);
            tallBlockKludge = true;
        } else {
            path = super.func_179680_a(pos, 0);
        }
        if (path != null && (lastPoint = path.func_75870_c()) != null && pos.func_218139_n((Vector3i)lastPoint.func_224759_a()) > (tallBlockKludge ? 1 : 0)) {
            path = null;
        }
        if (path == null && this.teleportationAllowed(pos)) {
            if (this.teleportCounter == -1) {
                this.teleportCounter = 0;
            }
        } else {
            this.teleportCounter = -1;
        }
        return path;
    }

    private boolean teleportationAllowed(BlockPos pos) {
        int max = (Integer)ConfigHelper.common().advanced.maxDroneTeleportRange.get();
        return !this.droneEntity.isTeleportRangeLimited() || max == 0 || pos.func_218137_a((IPosition)this.droneEntity.getDronePos(), (double)max);
    }

    @Override
    public boolean isGoingToTeleport() {
        return this.teleportCounter >= 0;
    }

    public boolean func_75500_f() {
        return super.func_75500_f() && !this.isGoingToTeleport();
    }

    public void func_75501_e() {
        ++this.field_75510_g;
        if (this.isGoingToTeleport()) {
            if (this.teleportCounter == 0 || this.teleportCounter == 60) {
                this.droneEntity.field_70170_p.func_184133_a(null, this.droneEntity.func_233580_cy_(), (SoundEvent)ModSounds.HUD_INIT.get(), SoundCategory.NEUTRAL, 0.3f, this.teleportCounter == 0 ? 0.7f : 1.0f);
            }
            if (this.teleportCounter < 80) {
                Random rand = this.droneEntity.func_70681_au();
                float f = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f1 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f2 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((IParticleData)ParticleTypes.field_197599_J, this.droneEntity.func_226277_ct_(), this.droneEntity.func_226278_cu_(), this.droneEntity.func_226281_cx_(), f, f1, f2), (Entity)this.droneEntity);
            }
            if (++this.teleportCounter > 120) {
                if (this.droneEntity.isBlockValidPathfindBlock(this.telPos)) {
                    this.teleport();
                }
                this.teleportCounter = -1;
                this.func_75484_a(null, 0.0);
                this.droneEntity.func_70605_aq().func_75642_a((double)this.telPos.func_177958_n(), (double)this.telPos.func_177956_o(), (double)this.telPos.func_177952_p(), this.droneEntity.getDroneSpeed());
                this.droneEntity.addAirToDrone(-10000);
            }
        } else if (!this.func_75500_f()) {
            this.func_75508_h();
            if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
                if ((Integer)ConfigHelper.common().advanced.stuckDroneTeleportTicks.get() > 0 && this.field_75515_a.func_213322_ci().func_189985_c() < 1.0E-4) {
                    if (this.stuckTicks++ > (Integer)ConfigHelper.common().advanced.stuckDroneTeleportTicks.get()) {
                        Vector3d v = this.droneEntity.getDronePos();
                        this.droneEntity.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.stuckBlock", new BlockPos((double)Math.round(v.field_72450_a), (double)Math.round(v.field_72448_b), (double)Math.round(v.field_72449_c)));
                        this.teleportCounter = 0;
                        this.telPos = this.field_75514_c.func_224770_k();
                        this.stuckTicks = 0;
                    }
                } else {
                    this.stuckTicks = 0;
                }
                if (!this.func_75500_f()) {
                    Vector3d vec32 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                    this.field_75515_a.func_70605_aq().func_75642_a(vec32.field_72450_a, vec32.field_72448_b, vec32.field_72449_c, this.field_75511_d);
                }
            }
        }
    }

    public void teleport() {
        Vector3d dest = Vector3d.func_237489_a_((Vector3i)this.telPos);
        NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticleTrail((IParticleData)ParticleTypes.field_197599_J, this.droneEntity.func_226277_ct_(), this.droneEntity.func_226278_cu_(), this.droneEntity.func_226281_cx_(), dest.field_72450_a, dest.field_72448_b, dest.field_72449_c), (Entity)this.droneEntity);
        this.droneEntity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        this.droneEntity.func_70107_b(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
    }

    @Override
    public boolean moveToXYZ(double x, double y, double z) {
        boolean success = this.func_75492_a(x, y, z, this.droneEntity.getDroneSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    @Override
    public boolean moveToEntity(Entity entity) {
        boolean success = this.func_75497_a(entity, this.droneEntity.getDroneSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    public boolean func_75484_a(Path pathentityIn, double speedIn) {
        return super.func_75484_a(pathentityIn, this.droneEntity.getDroneSpeed());
    }

    private void forceRidingEntityPaths() {
        for (Entity ridingEntity : this.droneEntity.func_184188_bt()) {
            if (!(ridingEntity instanceof MobEntity)) continue;
            MobEntity ridingLiving = (MobEntity)ridingEntity;
            ridingLiving.func_70661_as().func_75484_a(this.droneEntity.func_70661_as().func_75505_d(), this.droneEntity.getDroneSpeed());
        }
    }

    @Override
    public boolean hasNoPath() {
        return this.func_75500_f();
    }

    public boolean func_75493_a(Vector3d p_75493_1_, Vector3d p_75493_2_, int p_75493_3_, int p_75493_4_, int p_75493_5_) {
        return false;
    }

    protected PathFinder func_179679_a(int r) {
        this.field_179695_a = new NodeProcessorDrone();
        return new PathFinder(this.field_179695_a, 1000);
    }

    protected Vector3d func_75502_i() {
        return this.droneEntity.getDronePos();
    }

    protected boolean func_75485_k() {
        return true;
    }
}

