/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.ai.DroneClaimManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class DroneGoToChargingStation
extends Goal {
    private final EntityDrone drone;
    public boolean isExecuting;
    private TileEntityChargingStation curCharger;
    private int chargingTime;

    public DroneGoToChargingStation(EntityDrone drone) {
        this.drone = drone;
        this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
    }

    public boolean func_75250_a() {
        ArrayList<TileEntityChargingStation> validChargingStations = new ArrayList<TileEntityChargingStation>();
        this.drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> {
            if (h.getPressure() < 1.0f) {
                int r = (Integer)ConfigHelper.common().advanced.maxDroneChargingStationSearchRange.get();
                int maxDistSq = r * r;
                for (TileEntityChargingStation station : GlobalTileEntityCacheManager.getInstance().chargingStations) {
                    if (station.func_145831_w() != this.drone.field_70170_p || !(this.drone.func_195048_a(Vector3d.func_237489_a_((Vector3i)station.func_174877_v())) <= (double)maxDistSq)) continue;
                    if (DroneClaimManager.getInstance(this.drone.field_70170_p).isClaimed(station.func_174877_v())) {
                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.claimed", station.func_174877_v());
                        continue;
                    }
                    if (station.getPressure() <= 1.0f) {
                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.notEnoughPressure", station.func_174877_v());
                        continue;
                    }
                    if (station.getUpgrades(EnumUpgrade.DISPENSER) == 0) {
                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.noDispenserUpgrades", station.func_174877_v());
                        continue;
                    }
                    validChargingStations.add(station);
                }
            }
        });
        validChargingStations.sort(Comparator.comparingDouble(te -> PneumaticCraftUtils.distBetweenSq((Vector3i)te.func_174877_v(), this.drone.func_226277_ct_(), this.drone.func_226278_cu_(), this.drone.func_226281_cx_())));
        for (TileEntityChargingStation station : validChargingStations) {
            if (TileEntitySecurityStation.isProtectedFromPlayer((PlayerEntity)this.drone.getFakePlayer(), station.func_174877_v(), false)) {
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.protected", station.func_174877_v());
                continue;
            }
            if (this.drone.getPathNavigator().moveToXYZ((double)station.func_174877_v().func_177958_n() + 0.5, station.func_174877_v().func_177956_o() + 1, (double)station.func_174877_v().func_177952_p() + 0.5) || this.drone.getPathNavigator().isGoingToTeleport()) {
                this.isExecuting = true;
                this.curCharger = station;
                DroneClaimManager.getInstance(this.drone.field_70170_p).claim(station.func_174877_v());
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.cantNavigate", station.func_174877_v());
        }
        this.isExecuting = false;
        return false;
    }

    public boolean func_75253_b() {
        if (this.curCharger.getUpgrades(EnumUpgrade.DISPENSER) == 0 || this.curCharger.func_145837_r()) {
            this.isExecuting = false;
            return false;
        }
        if (!this.drone.getPathNavigator().isGoingToTeleport() && (this.drone.func_70661_as().func_75505_d() == null || this.drone.func_70661_as().func_75505_d().func_75879_b())) {
            this.isExecuting = (Boolean)this.drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).map(h -> h.getPressure() < 9.9f && this.curCharger.getPressure() > h.getPressure() + 0.1f).orElseThrow(RuntimeException::new);
            if (this.isExecuting) {
                ++this.chargingTime;
                if (this.chargingTime > 20) {
                    this.drone.getPathNavigator().moveToXYZ((double)this.curCharger.func_174877_v().func_177958_n() + 0.5, (double)this.curCharger.func_174877_v().func_177956_o() + 1.5, (double)this.curCharger.func_174877_v().func_177952_p() + 0.5);
                    if (this.drone.func_70661_as().func_75505_d() == null || this.drone.func_70661_as().func_75505_d().func_75879_b()) {
                        this.drone.setStandby(true);
                    } else {
                        this.chargingTime = 0;
                    }
                }
                DroneClaimManager.getInstance(this.drone.field_70170_p).claim(this.curCharger.func_174877_v());
            }
            return this.isExecuting;
        }
        this.chargingTime = 0;
        DroneClaimManager.getInstance(this.drone.field_70170_p).claim(this.curCharger.func_174877_v());
        return this.drone.isAccelerating();
    }
}

