/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class DroneEntityAIInventoryImport
extends DroneAIImExBase<ProgWidgetInventoryBase> {
    public DroneEntityAIInventoryImport(IDroneBase drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.importItems(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.importItems(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    private boolean importItems(BlockPos pos, boolean simulate) {
        Direction dir;
        TileEntity te = this.drone.world().func_175625_s(pos);
        boolean imported = false;
        Direction[] directionArray = DirectionUtil.VALUES;
        int n = directionArray.length;
        for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(dir = directionArray[i]) && (imported = IOHelper.getInventoryForTE(te, dir).map(inv -> this.tryImport((IItemHandler)inv, pos, simulate)).orElse(false).booleanValue())); ++i) {
        }
        return imported;
    }

    private boolean tryImport(IItemHandler inv, BlockPos pos, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (((ProgWidgetInventoryBase)this.progWidget).isItemValidForFilters(stack)) {
                ItemStack importedStack = inv.extractItem(i, stack.func_190916_E(), true);
                if (importedStack.func_190926_b()) continue;
                importedStack = importedStack.func_77946_l();
                if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                    importedStack.func_190920_e(Math.min(importedStack.func_190916_E(), this.getRemainingCount()));
                }
                ItemStack remainder = IOHelper.insert(this.drone, importedStack, Direction.UP, simulate);
                int removedItems = importedStack.func_190916_E() - remainder.func_190916_E();
                if (!simulate) {
                    inv.extractItem(i, removedItems, false);
                    this.decreaseCount(removedItems);
                    this.drone.addAirToDrone(-10);
                    if (!((ProgWidgetInventoryBase)this.progWidget).useCount() || this.getRemainingCount() > 0) continue;
                    return false;
                }
                if (removedItems > 0) {
                    return true;
                }
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryImport.debug.filledToMax", pos);
                continue;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryImport.debug.stackdoesntPassFilter", pos);
        }
        return false;
    }
}

