/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractTileModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberInterface;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderPressureChamberInterface
extends AbstractTileModelRenderer<TileEntityPressureChamberInterface> {
    private final ModelRenderer input = new ModelRenderer(128, 128, 0, 84);
    private final ModelRenderer output;

    public RenderPressureChamberInterface(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.input.func_228300_a_(0.0f, 0.0f, 0.0f, 10.0f, 10.0f, 2.0f);
        this.input.func_78793_a(-5.0f, 11.0f, -7.2f);
        this.input.field_78809_i = true;
        this.output = new ModelRenderer(128, 128, 24, 84);
        this.output.func_228300_a_(0.0f, 0.0f, 0.0f, 10.0f, 10.0f, 2.0f);
        this.output.func_78793_a(-5.0f, 11.0f, 5.2f);
        this.output.field_78809_i = true;
    }

    @Override
    public void renderModel(TileEntityPressureChamberInterface te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)Textures.MODEL_PRESSURE_CHAMBER_INTERFACE));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        float inputProgress = MathHelper.func_219799_g((float)partialTicks, (float)te.oldInputProgress, (float)te.inputProgress) / 40.0f;
        float outputProgress = MathHelper.func_219799_g((float)partialTicks, (float)te.oldOutputProgress, (float)te.outputProgress) / 40.0f;
        if (inputProgress < 1.0f) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)((1.0f - (float)Math.cos((double)inputProgress * Math.PI)) * 0.37f), 0.0, 0.0);
            matrixStackIn.func_227862_a_(1.0f - inputProgress, 1.0f, 1.0f);
            this.input.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
        if (outputProgress < 1.0f) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)((1.0f - (float)Math.cos((double)outputProgress * Math.PI)) * 0.37f), 0.0, 0.0);
            matrixStackIn.func_227862_a_(1.0f - outputProgress, 1.0f, 1.0f);
            this.output.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
    }

    @Override
    protected void renderExtras(TileEntityPressureChamberInterface te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!te.getStackInInterface().func_190926_b()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            RenderUtils.rotateMatrixForDirection(matrixStack, te.getRotation());
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel ibakedmodel = itemRenderer.func_184393_a(te.getStackInInterface(), te.func_145831_w(), null);
            itemRenderer.func_229111_a_(te.getStackInInterface(), ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLightIn, combinedOverlayIn, ibakedmodel);
            matrixStack.func_227865_b_();
        }
    }
}

