/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractTileModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoorBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class RenderPneumaticDoorBase
extends AbstractTileModelRenderer<TileEntityPneumaticDoorBase> {
    private final ModelRenderer cylinder1 = new ModelRenderer(64, 64, 0, 28);
    private final ModelRenderer cylinder2;
    private final ModelRenderer cylinder3;

    public RenderPneumaticDoorBase(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.cylinder1.func_228300_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f);
        this.cylinder1.func_78793_a(2.5f, 8.5f, -6.0f);
        this.cylinder1.field_78809_i = true;
        this.cylinder2 = new ModelRenderer(64, 64, 0, 28);
        this.cylinder2.func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 10.0f);
        this.cylinder2.func_78793_a(3.0f, 9.0f, -6.0f);
        this.cylinder2.field_78809_i = true;
        this.cylinder3 = new ModelRenderer(64, 64, 0, 28);
        this.cylinder3.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 10.0f);
        this.cylinder3.func_78793_a(3.5f, 9.5f, -6.0f);
        this.cylinder3.field_78809_i = true;
    }

    @Override
    public void renderModel(TileEntityPneumaticDoorBase te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)Textures.MODEL_PNEUMATIC_DOOR_BASE));
        float progress = MathHelper.func_219799_g((float)partialTicks, (float)te.oldProgress, (float)te.progress);
        float cosinus = (float)Math.sin(Math.toRadians((1.0f - progress) * 90.0f)) * 12.0f / 16.0f;
        float sinus = 0.5625f - (float)Math.cos(Math.toRadians((1.0f - progress) * 90.0f)) * 9.0f / 16.0f;
        double extension = Math.sqrt(Math.pow(sinus, 2.0) + Math.pow(cosinus + 0.25f, 2.0));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        matrixStackIn.func_227861_a_(((double)(te.rightGoing ? -4 : 0) + 2.5) / 16.0, 0.0, -0.375);
        float cylinderAngle = (float)Math.toDegrees(Math.atan(sinus / (cosinus + 0.875f)));
        matrixStackIn.func_227863_a_(te.rightGoing ? Vector3f.field_229181_d_.func_229187_a_(cylinderAngle) : Vector3f.field_229180_c_.func_229187_a_(cylinderAngle));
        matrixStackIn.func_227861_a_(((double)(te.rightGoing ? -3 : 0) - 2.5) / 16.0, 0.0, 0.375);
        double extensionPart = extension * 0.5;
        this.cylinder1.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227861_a_(0.0, 0.0, extensionPart);
        this.cylinder2.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 0.8f, 0.8f, 0.8f, 1.0f);
        matrixStackIn.func_227861_a_(0.0, 0.0, extensionPart);
        this.cylinder3.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 0.6f, 0.6f, 0.6f, 1.0f);
    }
}

