/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.client.gui.GuiAphorismTile;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.vector.Vector3f;

public class RenderAphorismTile
extends TileEntityRenderer<TileEntityAphorismTile> {
    private static final float ICON_SCALE = 9.0f;

    public RenderAphorismTile(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityAphorismTile te, float v, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        RenderUtils.rotateMatrixForDirection(matrixStack, te.getRotation());
        double zOff = te.isInvisible() ? 0.01 : 0.0625;
        matrixStack.func_227861_a_(0.0, 1.0, 0.5 - zOff - 0.01);
        FontRenderer fr = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        fr.getClass();
        int fh = 9;
        GuiAphorismTile editor = this.getEditor(te);
        String[] textLines = te.getTextLines();
        int lineWidth = te.getMaxLineWidth(editor != null);
        float lineHeight = (float)(fh * textLines.length) * (1.0f + (float)(te.getMarginSize() + 1) * 0.075f);
        float textScale = Math.min(0.875f / (float)lineWidth, 0.875f / lineHeight);
        matrixStack.func_227862_a_(textScale, textScale, textScale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(te.textRotation * 90)));
        int editedLine = editor == null ? -1 : editor.cursorY;
        boolean showCursor = editor != null && (editor.updateCounter & 0xF) < 8;
        float mid = (float)(textLines.length + 1) / 2.0f - 1.0f;
        for (int i = 0; i < textLines.length; ++i) {
            String textLine;
            if (!te.getIconAt(i).func_190926_b() && editor == null) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(0.0, (double)(8.0f * (mid - (float)i)), 0.0);
                matrixStack.func_227862_a_(9.0f, 9.0f, 9.0f);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(te.getIconAt(i), ItemCameraTransforms.TransformType.FIXED, combinedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
                matrixStack.func_227865_b_();
                continue;
            }
            if (editedLine == i) {
                String cursor = showCursor ? "\u25a0" : "\u25a1";
                int cx = Math.min(editor.cursorX, textLines[i].length());
                textLine = textLines[i].substring(0, cx) + cursor + textLines[i].substring(cx);
            } else {
                textLine = textLines[i];
            }
            float x = (float)(-fr.func_78256_a(textLine)) / 2.0f;
            float y = (float)(-(textLines.length * fh)) / 2.0f + (float)(i * fh) + 1.0f;
            if (editor == null && te.isRedstoneLine(i)) {
                textLine = textLine.replaceAll(Pattern.quote("{redstone}"), Integer.toString(te.pollRedstone()));
                x = (float)(-fr.func_78256_a(textLine)) / 2.0f;
            }
            fr.func_228079_a_(textLine, x, y, -16777216, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        }
        matrixStack.func_227865_b_();
    }

    private GuiAphorismTile getEditor(TileEntityAphorismTile te) {
        return Minecraft.func_71410_x().field_71462_r instanceof GuiAphorismTile && ((GuiAphorismTile)Minecraft.func_71410_x().field_71462_r).tile == te ? (GuiAphorismTile)Minecraft.func_71410_x().field_71462_r : null;
    }
}

