/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fluids.IFluidTank;

public abstract class AbstractFluidTER<T extends TileEntityBase>
extends TileEntityRenderer<T> {
    AbstractFluidTER(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.func_145831_w().func_72863_F().func_222865_a(new ChunkPos(te.func_174877_v()))) {
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228642_d_((ResourceLocation)AtlasTexture.field_110575_b));
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            for (TankRenderInfo tankRenderInfo : this.getTanksToRender(te)) {
                this.doRender(builder, tankRenderInfo, posMat, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    private void doRender(IVertexBuilder builder, TankRenderInfo tankRenderInfo, Matrix4f posMat, int combinedLight, int combinedOverlay) {
        float v2;
        float v1;
        float u2;
        float u1;
        IFluidTank tank = tankRenderInfo.getTank();
        if (tank.getFluidAmount() == 0) {
            return;
        }
        Fluid fluid = tank.getFluid().getFluid();
        ResourceLocation texture = fluid.getAttributes().getStillTexture(tank.getFluid());
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
        int[] cols = RenderUtils.decomposeColor(fluid.getAttributes().getColor(tank.getFluid()));
        AxisAlignedBB bounds = this.getRenderBounds(tank, tankRenderInfo.getBounds());
        float x1 = (float)bounds.field_72340_a;
        float x2 = (float)bounds.field_72336_d;
        float y1 = (float)bounds.field_72338_b;
        float y2 = (float)bounds.field_72337_e;
        float z1 = (float)bounds.field_72339_c;
        float z2 = (float)bounds.field_72334_f;
        double bx1 = bounds.field_72340_a * 16.0;
        double bx2 = bounds.field_72336_d * 16.0;
        double by1 = bounds.field_72338_b * 16.0;
        double by2 = bounds.field_72337_e * 16.0;
        double bz1 = bounds.field_72339_c * 16.0;
        double bz2 = bounds.field_72334_f * 16.0;
        if (tankRenderInfo.shouldRender(Direction.DOWN)) {
            u1 = still.func_94214_a(bx1);
            u2 = still.func_94214_a(bx2);
            v1 = still.func_94207_b(bz1);
            v2 = still.func_94207_b(bz2);
            builder.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(Direction.UP)) {
            u1 = still.func_94214_a(bx1);
            u2 = still.func_94214_a(bx2);
            v1 = still.func_94207_b(bz1);
            v2 = still.func_94207_b(bz2);
            builder.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(Direction.NORTH)) {
            u1 = still.func_94214_a(bx1);
            u2 = still.func_94214_a(bx2);
            v1 = still.func_94207_b(by1);
            v2 = still.func_94207_b(by2);
            builder.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(Direction.SOUTH)) {
            u1 = still.func_94214_a(bx1);
            u2 = still.func_94214_a(bx2);
            v1 = still.func_94207_b(by1);
            v2 = still.func_94207_b(by2);
            builder.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(Direction.WEST)) {
            u1 = still.func_94214_a(by1);
            u2 = still.func_94214_a(by2);
            v1 = still.func_94207_b(bz1);
            v2 = still.func_94207_b(bz2);
            builder.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(Direction.EAST)) {
            u1 = still.func_94214_a(by1);
            u2 = still.func_94214_a(by2);
            v1 = still.func_94207_b(bz1);
            v2 = still.func_94207_b(bz2);
            builder.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v1).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u2, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(u1, v2).func_227891_b_(combinedOverlay).func_227886_a_(combinedLight).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        }
    }

    private AxisAlignedBB getRenderBounds(IFluidTank tank, AxisAlignedBB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.field_72337_e - tankBounds.field_72338_b;
        double y1 = tankBounds.field_72338_b;
        double y2 = tankBounds.field_72338_b + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getAttributes().isLighterThanAir()) {
            double yOff = tankBounds.field_72337_e - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AxisAlignedBB(tankBounds.field_72340_a, y1, tankBounds.field_72339_c, tankBounds.field_72336_d, y2, tankBounds.field_72334_f);
    }

    static AxisAlignedBB rotateY(AxisAlignedBB in, int rot) {
        switch (rot) {
            case 90: {
                return new AxisAlignedBB(1.0 - in.field_72339_c, in.field_72338_b, in.field_72340_a, 1.0 - in.field_72334_f, in.field_72337_e, in.field_72336_d);
            }
            case 180: {
                return new AxisAlignedBB(1.0 - in.field_72340_a, in.field_72338_b, 1.0 - in.field_72339_c, 1.0 - in.field_72336_d, in.field_72337_e, 1.0 - in.field_72334_f);
            }
            case 270: {
                return new AxisAlignedBB(in.field_72339_c, in.field_72338_b, 1.0 - in.field_72340_a, in.field_72334_f, in.field_72337_e, 1.0 - in.field_72336_d);
            }
        }
        throw new IllegalArgumentException("rot must be 90, 180 or 270");
    }

    abstract Collection<TankRenderInfo> getTanksToRender(T var1);
}

