/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidget;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetButton;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetDropdown;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetLabel;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class RemoteLayout {
    private final List<ActionWidget<?>> actionWidgets = new ArrayList();
    private static final Map<String, Class<? extends ActionWidget<?>>> registeredWidgets = new HashMap();

    private static void registerWidget(Class<? extends ActionWidget<?>> widgetClass) {
        try {
            ActionWidget<?> widget = widgetClass.newInstance();
            registeredWidgets.put(widget.getId(), widgetClass);
            return;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Widget " + widgetClass + " couldn't be registered");
        }
    }

    public RemoteLayout(ItemStack remote, int guiLeft, int guiTop) {
        CompoundNBT tag = remote.func_77978_p();
        if (tag != null) {
            ListNBT tagList = tag.func_150295_c("actionWidgets", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT widgetTag = tagList.func_150305_b(i);
                String id = widgetTag.func_74779_i("id");
                Class<ActionWidget<?>> clazz = registeredWidgets.get(id);
                try {
                    ActionWidget<?> widget = clazz.newInstance();
                    widget.readFromNBT(widgetTag, guiLeft, guiTop);
                    this.actionWidgets.add(widget);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public CompoundNBT toNBT(int guiLeft, int guiTop) {
        CompoundNBT tag = new CompoundNBT();
        ListNBT tagList = new ListNBT();
        for (ActionWidget<?> actionWidget : this.actionWidgets) {
            tagList.add((Object)actionWidget.toNBT(guiLeft, guiTop));
        }
        tag.func_218657_a("actionWidgets", (INBT)tagList);
        return tag;
    }

    public void addWidget(ActionWidget<?> widget) {
        this.actionWidgets.add(widget);
    }

    public List<ActionWidget<?>> getActionWidgets() {
        return this.actionWidgets;
    }

    public List<Widget> getWidgets(boolean filterDisabledWidgets) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (ActionWidget<?> actionWidget : this.actionWidgets) {
            if (filterDisabledWidgets && !actionWidget.isEnabled()) continue;
            widgets.add((Widget)actionWidget.getWidget());
        }
        return widgets;
    }

    static {
        RemoteLayout.registerWidget(ActionWidgetCheckBox.class);
        RemoteLayout.registerWidget(ActionWidgetLabel.class);
        RemoteLayout.registerWidget(ActionWidgetButton.class);
        RemoteLayout.registerWidget(ActionWidgetDropdown.class);
    }
}

