/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiMoveStat;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.AbstractSliderOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsClientHandler;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class JetBootsOptions
extends AbstractSliderOptions<JetBootsClientHandler> {
    private ICheckboxWidget checkBoxBuilderMode;
    private ICheckboxWidget checkBoxStabilizers;
    private IKeybindingButton changeKeybindingButton;

    public JetBootsOptions(IGuiScreen screen, JetBootsClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        super.populateGui(gui);
        IPneumaticHelmetRegistry registry = PneumaticRegistry.getInstance().getHelmetRegistry();
        ResourceLocation ownerID = ((JetBootsHandler)((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler()).getID();
        this.checkBoxBuilderMode = registry.makeKeybindingCheckBox(PneumaticRegistry.RL("jet_boots.module.builder_mode"), 5, 45, -1, b -> this.setFlag("JetBootsBuilderMode", 3, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(this.checkBoxBuilderMode.asWidget());
        this.checkBoxStabilizers = registry.makeKeybindingCheckBox(PneumaticRegistry.RL("jet_boots.module.flight_stabilizers"), 5, 65, -1, b -> this.setFlag("JetBootsStabilizers", 4, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(this.checkBoxStabilizers.asWidget());
        ICheckboxWidget hoverControl = registry.makeKeybindingCheckBox(PneumaticRegistry.RL("jet_boots.module.smart_hover"), 5, 85, -1, b -> this.setFlag("SmartHover", 1, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(hoverControl.asWidget());
        this.changeKeybindingButton = registry.makeKeybindingButton(135, KeyHandler.getInstance().keybindJetBoots);
        gui.addWidget(this.changeKeybindingButton.asWidget());
        gui.addWidget(new WidgetButtonExtended(30, 157, 150, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.moveStatScreen", new Object[0]), b -> {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiMoveStat((IArmorUpgradeClientHandler<?>)this.getClientUpgradeHandler(), ArmorHUDLayout.LayoutType.JET_BOOTS));
        }));
    }

    @Override
    protected PointXY getSliderPos() {
        return new PointXY(30, 105);
    }

    private void setFlag(String flagName, int minTier, ICheckboxWidget cb) {
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        if (commonArmorHandler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= minTier) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a(flagName, cb.isChecked());
            JetBootsHandler upgradeHandler = (JetBootsHandler)((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler();
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlotType.FEET, tag, upgradeHandler.getID()));
            upgradeHandler.onDataFieldUpdated(CommonArmorHandler.getHandlerForPlayer(), flagName, tag.func_74781_a(flagName));
            ResourceLocation ownerId = upgradeHandler.getID();
            HUDHandler.getInstance().addFeatureToggleMessage(ArmorUpgradeRegistry.getStringKey(ownerId), ArmorUpgradeRegistry.getStringKey(cb.getUpgradeId()), cb.isChecked());
        }
    }

    @Override
    public void tick() {
        super.tick();
        int nUpgrades = CommonArmorHandler.getHandlerForPlayer().getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS);
        this.checkBoxBuilderMode.asWidget().field_230693_o_ = nUpgrades >= 3;
        this.checkBoxStabilizers.asWidget().field_230693_o_ = nUpgrades >= 4;
    }

    @Override
    protected String getTagName() {
        return "JetBootsPower";
    }

    @Override
    protected ITextComponent getPrefix() {
        return new StringTextComponent("Power: ");
    }

    @Override
    protected ITextComponent getSuffix() {
        return new StringTextComponent("%");
    }

    @Override
    public Optional<IKeybindingButton> getKeybindingButton() {
        return Optional.of(this.changeKeybindingButton);
    }
}

