/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens;

import java.util.Collections;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoordTrackClientHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CoordinateTrackerOptions
extends IOptionPage.SimpleOptionPage<CoordTrackClientHandler> {
    private Button wirePath;
    private Button pathEnabled;
    private Button xRayEnabled;
    private Button pathUpdateRate;
    private final CoordTrackClientHandler coordHandler = (CoordTrackClientHandler)this.getClientUpgradeHandler();
    private final Minecraft mc = Minecraft.func_71410_x();

    public CoordinateTrackerOptions(IGuiScreen screen, CoordTrackClientHandler clientHandler) {
        super(screen, clientHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        gui.addWidget(new WidgetButtonExtended(30, 40, 150, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.selectTarget", new Object[0]), b -> this.selectTarget()));
        gui.addWidget(new WidgetButtonExtended(30, 62, 150, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.navigateToSurface", new Object[0]), b -> this.navigateToSurface()));
        this.pathEnabled = new WidgetButtonExtended(30, 128, 150, 20, StringTextComponent.field_240750_d_, b -> {
            this.coordHandler.pathEnabled = !this.coordHandler.pathEnabled;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.wirePath = new WidgetButtonExtended(30, 150, 150, 20, StringTextComponent.field_240750_d_, b -> {
            this.coordHandler.wirePath = !this.coordHandler.wirePath;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.xRayEnabled = new WidgetButtonExtended(30, 172, 150, 20, StringTextComponent.field_240750_d_, b -> {
            this.coordHandler.xRayEnabled = !this.coordHandler.xRayEnabled;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.pathUpdateRate = new WidgetButtonExtended(30, 194, 150, 20, StringTextComponent.field_240750_d_, b -> {
            this.coordHandler.pathUpdateSetting = this.coordHandler.pathUpdateSetting.cycle();
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        gui.addWidget(this.pathEnabled);
        gui.addWidget(this.wirePath);
        gui.addWidget(this.xRayEnabled);
        gui.addWidget(this.pathUpdateRate);
        this.updateButtonTexts();
    }

    private void selectTarget() {
        this.mc.field_71439_g.func_71053_j();
        this.mc.func_213228_a(true);
        this.coordHandler.isListeningToCoordTrackerSetting = true;
        HUDHandler.getInstance().addMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.settingCoord", new Object[0]), Collections.singletonList(PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.rightClickToSet", new Object[0])), 90, 0x7000AA00);
    }

    private void navigateToSurface() {
        this.mc.field_71439_g.func_71053_j();
        this.mc.func_213228_a(true);
        switch (this.coordHandler.navigateToSurface((PlayerEntity)this.mc.field_71439_g)) {
            case EASY_PATH: {
                HUDHandler.getInstance().addMessage(new ArmorMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.routeFound", new Object[0]), 90, 0x7000AA00));
                break;
            }
            case DRONE_PATH: {
                HUDHandler.getInstance().addMessage(new ArmorMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.harderRouteFound", new Object[0]), 90, 1883548160));
                break;
            }
            case NO_PATH: {
                HUDHandler.getInstance().addMessage(new ArmorMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.noRouteFound", new Object[0]), 90, 0x70FF0000));
            }
        }
    }

    private void updateButtonTexts() {
        this.pathEnabled.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.navEnabled." + this.coordHandler.pathEnabled, new Object[0]));
        this.wirePath.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.wirePath." + this.coordHandler.wirePath, new Object[0]));
        this.xRayEnabled.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.xray." + this.coordHandler.xRayEnabled, new Object[0]));
        this.pathUpdateRate.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate(this.coordHandler.pathUpdateSetting.getTranslationKey(), new Object[0]));
        this.wirePath.field_230693_o_ = this.coordHandler.pathEnabled;
        this.xRayEnabled.field_230693_o_ = this.coordHandler.pathEnabled;
        this.pathUpdateRate.field_230693_o_ = this.coordHandler.pathEnabled;
    }

    @Override
    public boolean displaySettingsHeader() {
        return true;
    }
}

