/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.inventory.ContainerLiquidCompressor;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.tileentity.TileEntityLiquidCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GuiLiquidCompressor
extends GuiPneumaticContainerBase<ContainerLiquidCompressor, TileEntityLiquidCompressor> {
    public GuiLiquidCompressor(ContainerLiquidCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new WidgetTank(this.field_147003_i + this.getFluidOffset(), this.field_147009_r + 15, ((TileEntityLiquidCompressor)this.te).getTank()));
        WidgetAnimatedStat stat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidCompressor.fuel", new Object[0]), new ItemStack((IItemProvider)ModItems.LPG_BUCKET.get()), -5226496, true);
        Pair<Integer, List<ITextComponent>> p = this.getAllFuels();
        stat.setMinimumExpandedDimensions((Integer)p.getLeft() + 30, 17);
        stat.setText((List)p.getRight());
    }

    @Override
    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((TileEntityLiquidCompressor)this.te).airPerTick, 2)).func_240699_a_(TextFormatting.BLACK));
    }

    protected int getFluidOffset() {
        return 86;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -2);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        return new PointXY(xStart + this.field_146999_f * 3 / 4 + 5, yStart + this.field_147000_g / 4 + 4);
    }

    @Override
    protected String upgradeCategory() {
        return "liquid_compressor";
    }

    private Pair<Integer, List<ITextComponent>> getAllFuels() {
        ArrayList<Object> text = new ArrayList<Object>();
        TranslationTextComponent header = PneumaticCraftUtils.xlate("pneumaticcraft.gui.liquidCompressor.fuelsHeader", new Object[0]);
        text.add(header.func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.AQUA}));
        int maxWidth = this.field_230712_o_.func_238414_a_((ITextProperties)header);
        FuelRegistry fuelRegistry = FuelRegistry.getInstance();
        fuelRegistry.clearCachedFuelFluids();
        World world = ((TileEntityLiquidCompressor)this.te).func_145831_w();
        ArrayList<Fluid> fluids = new ArrayList<Fluid>(fuelRegistry.registeredFuels(world));
        fluids.sort((o1, o2) -> Integer.compare(fuelRegistry.getFuelValue(world, (Fluid)o2), fuelRegistry.getFuelValue(world, (Fluid)o1)));
        Map<String, Integer> counted = fluids.stream().collect(Collectors.toMap(fluid -> new FluidStack(fluid, 1).getDisplayName().getString(), fluid -> 1, Integer::sum));
        int dotWidth = this.field_230712_o_.func_78256_a(".");
        ITextComponent prevLine = StringTextComponent.field_240750_d_;
        for (Fluid fluid2 : fluids) {
            StringTextComponent line;
            String value = String.format("%4d", fuelRegistry.getFuelValue(world, fluid2) / 1000);
            int nSpc = (32 - this.field_230712_o_.func_78256_a(value)) / dotWidth;
            value = value + StringUtils.repeat((char)'.', (int)nSpc);
            String fluidName = new FluidStack(fluid2, 1).getDisplayName().getString();
            float mul = fuelRegistry.getBurnRateMultiplier(world, fluid2);
            StringTextComponent stringTextComponent = line = mul == 1.0f ? new StringTextComponent(value + "| " + StringUtils.abbreviate((String)fluidName, (int)25)) : new StringTextComponent(value + "| " + StringUtils.abbreviate((String)fluidName, (int)20) + " (x" + PneumaticCraftUtils.roundNumberTo(mul, 2) + ")");
            if (!line.equals((Object)prevLine)) {
                maxWidth = Math.max(maxWidth, this.field_230712_o_.func_238414_a_((ITextProperties)line));
                text.add(line);
            }
            prevLine = line;
            if (counted.getOrDefault(fluidName, 0) <= 1) continue;
            IFormattableTextComponent line2 = new StringTextComponent("       " + ModNameCache.getModName(fluid2)).func_240699_a_(TextFormatting.GOLD);
            text.add(line2);
            maxWidth = Math.max(maxWidth, this.field_230712_o_.func_238414_a_((ITextProperties)line2));
        }
        return Pair.of((Object)Math.min(maxWidth, this.field_147003_i - 10), text);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_COMPRESSOR;
    }

    @Override
    public void addProblems(List<ITextComponent> curInfo) {
        super.addProblems(curInfo);
        if (((TileEntityLiquidCompressor)this.te).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            ((TileEntityLiquidCompressor)this.te).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                if (!((TileEntityLiquidCompressor)this.te).isProducing && fluidHandler.getFluidInTank(0).isEmpty()) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel", new Object[0]));
                }
            });
        } else {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel", new Object[0]));
        }
    }
}

