/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerElectrostaticCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElectrostaticCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class GuiElectrostaticCompressor
extends GuiPneumaticContainerBase<ContainerElectrostaticCompressor, TileEntityElectrostaticCompressor> {
    private int connectedCompressors;
    private WidgetAnimatedStat electrostaticStat;

    public GuiElectrostaticCompressor(ContainerElectrostaticCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.electrostaticStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostaticCompressor.title", new Object[0]), new ItemStack((IItemProvider)ModBlocks.ELECTROSTATIC_COMPRESSOR.get()), -14638849, false);
        this.electrostaticStat.setForegroundColor(-16777216);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected void addWarnings(List<ITextComponent> textList) {
        int generated;
        super.addWarnings(textList);
        int grounding = 10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath;
        if (this.connectedCompressors > 0 && grounding < (generated = 200000 / this.connectedCompressors)) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.electrostatic.notEnoughGrounding", grounding, generated));
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (ClientUtils.getClientWorld().func_82737_E() % 20L == 0L) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            HashSet<TileEntityElectrostaticCompressor> compressors = new HashSet<TileEntityElectrostaticCompressor>();
            positions.add(((TileEntityElectrostaticCompressor)this.te).func_174877_v());
            ((TileEntityElectrostaticCompressor)this.te).getElectrostaticGrid(positions, compressors, ((TileEntityElectrostaticCompressor)this.te).func_174877_v());
            this.connectedCompressors = compressors.size();
        }
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        info.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.generating", PneumaticCraftUtils.roundNumberTo(200000.0f / (float)this.connectedCompressors, 1)));
        info.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.connected", this.connectedCompressors));
        info.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.maxRedirection", PneumaticCraftUtils.roundNumberTo(10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath, 1)));
        info.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.lightningRod", ((TileEntityElectrostaticCompressor)this.te).ironBarsAbove));
        info.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.strikeTime", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntityElectrostaticCompressor)this.te).getStrikeChance(), false)));
        this.electrostaticStat.setText(info);
    }
}

