/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.ingredient.CompoundFluidIngredient;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidIngredient
extends Ingredient {
    private List<Fluid> fluids;
    private ItemStack[] cachedStacks;
    private final int amount;
    private final ResourceLocation fluidId;
    private final ITag<Fluid> fluidTag;
    private final CompoundNBT nbt;
    private final boolean fuzzyNBT;
    public static final FluidIngredient EMPTY = new FluidIngredient(Collections.emptyList(), 0, null, null, null, false);

    protected FluidIngredient(List<Fluid> fluids, int amount, ResourceLocation fluidId, ITag<Fluid> fluidTag, CompoundNBT nbt, boolean fuzzyNBT) {
        super(Stream.empty());
        this.fluids = fluids;
        this.amount = amount;
        this.fluidId = fluidId;
        this.fluidTag = fluidTag;
        this.nbt = nbt;
        this.fuzzyNBT = fuzzyNBT;
    }

    public static FluidIngredient of(FluidStack fluidStack) {
        return FluidIngredient.of(fluidStack.getAmount(), fluidStack.getTag(), false, fluidStack.getFluid());
    }

    public static FluidIngredient of(int amount, @Nullable CompoundNBT nbt, boolean fuzzyNBT, Fluid ... fluids) {
        return new FluidIngredient(Arrays.asList(fluids), amount, null, null, nbt, fuzzyNBT);
    }

    public static FluidIngredient of(int amount, Fluid ... fluids) {
        return FluidIngredient.of(amount, null, false, fluids);
    }

    public static FluidIngredient of(int amount, @Nullable CompoundNBT nbt, boolean fuzzyNBT, ITag<Fluid> fluidTag) {
        return new FluidIngredient(null, amount, null, fluidTag, nbt, fuzzyNBT);
    }

    public static FluidIngredient of(int amount, ITag<Fluid> fluidTag) {
        return FluidIngredient.of(amount, null, false, fluidTag);
    }

    public static FluidIngredient of(int amount, @Nullable CompoundNBT nbt, boolean fuzzyNBT, ResourceLocation fluidId) {
        return new FluidIngredient(null, amount, fluidId, null, nbt, fuzzyNBT);
    }

    public static FluidIngredient of(int amount, ResourceLocation fluidId) {
        return FluidIngredient.of(amount, null, false, fluidId);
    }

    public static FluidIngredient ofFluidStream(Stream<FluidIngredient> stream) {
        return new CompoundFluidIngredient(stream);
    }

    protected Collection<Fluid> getFluidList() {
        if (this.fluids == null) {
            if (this.fluidId != null) {
                this.fluids = ForgeRegistries.FLUIDS.containsKey(this.fluidId) ? Collections.singletonList(ForgeRegistries.FLUIDS.getValue(this.fluidId)) : Collections.emptyList();
            } else if (this.fluidTag != null) {
                this.fluids = ImmutableList.copyOf((Collection)this.fluidTag.func_230236_b_());
            } else {
                throw new IllegalStateException("no fluid ID or fluid tag is available?");
            }
        }
        return this.fluids;
    }

    public boolean func_203189_d() {
        return this.getFluidList().isEmpty();
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.hasContainerItem() && FluidUtil.getFluidContained((ItemStack)stack).map(this::testFluid).orElse(false) != false;
    }

    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            ArrayList<ItemStack> tankList = new ArrayList<ItemStack>();
            for (Fluid f : this.getFluidList()) {
                FluidStack fluidStack = new FluidStack(f, 1000);
                ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)fluidStack);
                if (!bucket.func_190926_b()) {
                    tankList.add(bucket);
                }
                Stream.of("small", "medium", "large", "huge").map(tankName -> (Block)ForgeRegistries.BLOCKS.getValue(PneumaticRegistry.RL(tankName + "_tank"))).filter(tankBlock -> tankBlock != null && tankBlock != Blocks.field_150350_a).forEach(tankBlock -> this.maybeAddTank((List<ItemStack>)tankList, (Block)tankBlock, fluidStack));
            }
            this.cachedStacks = tankList.toArray(new ItemStack[0]);
        }
        return this.cachedStacks;
    }

    public boolean testFluid(FluidStack fluidStack) {
        return this.getFluidList().stream().anyMatch(f -> fluidStack.getFluid() == f && fluidStack.getAmount() >= this.getAmount() && this.matchNBT(fluidStack));
    }

    public boolean testFluid(Fluid fluid) {
        return this.getFluidList().stream().anyMatch(f -> f == fluid);
    }

    private void maybeAddTank(List<ItemStack> l, Block tankBlock, FluidStack stack) {
        ItemStack tank = new ItemStack((IItemProvider)tankBlock);
        tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
            h.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            l.add(h.getContainer());
        });
    }

    private boolean matchNBT(FluidStack fluidStack) {
        if (this.nbt == null) {
            return true;
        }
        if (fluidStack.getTag() == null) {
            return false;
        }
        if (this.fuzzyNBT) {
            return this.nbt.func_150296_c().stream().allMatch(key -> NBTUtil.func_181123_a((INBT)this.nbt.func_74781_a(key), (INBT)fluidStack.getTag().func_74781_a(key), (boolean)true));
        }
        return NBTUtil.func_181123_a((INBT)this.nbt, (INBT)fluidStack.getTag(), (boolean)true);
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        if (this.fluidTag != null) {
            ResourceLocation tagId = TagCollectionManager.func_242178_a().func_241837_c().func_232975_b_(this.fluidTag);
            json.addProperty("tag", tagId.toString());
        } else if (this.fluidId != null) {
            json.addProperty("fluid", this.fluidId.toString());
        } else if (!this.fluids.isEmpty()) {
            json.addProperty("fluid", this.fluids.get(0).getRegistryName().toString());
        } else {
            throw new IllegalStateException("ingredient has no ID, tag or fluid!");
        }
        json.addProperty("amount", (Number)this.getAmount());
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
            json.addProperty("fuzzyNBT", Boolean.valueOf(this.fuzzyNBT));
        }
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<FluidStack> getFluidStacks() {
        return this.getFluidList().stream().map(f -> new FluidStack(f, this.getAmount())).collect(Collectors.toList());
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:fluid");
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public FluidIngredient parse(PacketBuffer buffer) {
            int nFluids = buffer.func_150792_a();
            int amount = buffer.func_150792_a();
            HashSet<IForgeRegistryEntry> fluids = new HashSet<IForgeRegistryEntry>();
            for (int i = 0; i < nFluids; ++i) {
                fluids.add(buffer.readRegistryId());
            }
            if (buffer.readBoolean()) {
                return FluidIngredient.of(amount, buffer.func_150793_b(), buffer.readBoolean(), fluids.toArray(new Fluid[0]));
            }
            return FluidIngredient.of(amount, fluids.toArray(new Fluid[0]));
        }

        public FluidIngredient parse(JsonObject json) {
            FluidIngredient result;
            int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
            CompoundNBT nbt = this.possibleNBT(json);
            boolean fuzzyNBT = JSONUtils.func_151209_a((JsonObject)json, (String)"fuzzyNBT", (boolean)false);
            if (json.has("tag")) {
                ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
                ITag tag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(rl);
                if (tag == null) {
                    throw new JsonSyntaxException("Unknown fluid tag '" + rl + "'");
                }
                result = FluidIngredient.of(amount, nbt, fuzzyNBT, (ITag<Fluid>)tag);
            } else if (json.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
                if (fluid == null || fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException("Unknown fluid '" + fluidId + "'");
                }
                result = FluidIngredient.of(amount, nbt, fuzzyNBT, fluid);
            } else {
                throw new JsonSyntaxException("fluid ingredient must have 'fluid' or 'tag' field!");
            }
            return result;
        }

        private CompoundNBT possibleNBT(JsonObject json) {
            if (json.has("nbt")) {
                JsonElement element = json.get("nbt");
                try {
                    if (element.isJsonObject()) {
                        return JsonToNBT.func_180713_a((String)GSON.toJson(element));
                    }
                    return JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"));
                }
                catch (CommandSyntaxException e) {
                    throw new JsonSyntaxException((Throwable)e);
                }
            }
            return null;
        }

        public void write(PacketBuffer buffer, FluidIngredient ingredient) {
            buffer.func_150787_b(ingredient.getFluidList().size());
            buffer.func_150787_b(ingredient.getAmount());
            ingredient.getFluidList().forEach(arg_0 -> ((PacketBuffer)buffer).writeRegistryId(arg_0));
            if (ingredient.nbt != null) {
                buffer.writeBoolean(true);
                buffer.func_150786_a(ingredient.nbt);
                buffer.writeBoolean(ingredient.fuzzyNBT);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

