/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.gui.PasswordFieldWidget;

public final class AuthScreen
extends Screen {
    private TextFieldWidget username;
    private PasswordFieldWidget pw;
    private Button confirm;
    private Button cancel;
    private CheckboxButton save;
    private Button config;
    private Screen prev;
    private int baseY;
    private String message = "";

    public AuthScreen(Screen prev) {
        super((ITextComponent)new TranslationTextComponent("reauth.gui.auth.title"));
        this.prev = prev;
    }

    public AuthScreen(Screen prev, String message) {
        this(prev);
        this.message = message;
    }

    public void func_231160_c_() {
        String msg;
        super.func_231160_c_();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.baseY = this.field_230709_l_ / 2 - 55;
        this.username = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 155, this.baseY + 15, 310, 20, (ITextComponent)new TranslationTextComponent("reauth.gui.auth.username"));
        this.username.func_146203_f(512);
        this.username.func_146180_a(ReAuth.config.getUsername());
        this.func_230480_a_((Widget)this.username);
        this.pw = new PasswordFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 155, this.baseY + 60, 310, 20, (ITextComponent)new TranslationTextComponent("reauth.gui.auth.password"));
        this.pw.func_146203_f(Short.MAX_VALUE);
        this.pw.func_146180_a(ReAuth.config.getPassword());
        this.func_230480_a_((Widget)this.pw);
        this.focus((TextFieldWidget)(this.username.func_146179_b().isEmpty() ? this.username : this.pw));
        this.save = new CheckboxButton(this.field_230708_k_ / 2 - 155, this.baseY + 85, 310, 20, (ITextComponent)new TranslationTextComponent("reauth.gui.auth.checkbox"), !this.pw.func_146179_b().isEmpty());
        if (ReAuth.config.hasCrypto()) {
            this.func_230480_a_((Widget)this.save);
        }
        this.confirm = new Button(this.field_230708_k_ / 2 - 155, this.baseY + 110, 153, 20, StringTextComponent.field_240750_d_, b -> this.doLogin());
        this.func_230480_a_((Widget)this.confirm);
        this.cancel = new Button(this.field_230708_k_ / 2 + 2, this.baseY + 110, 155, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), b -> this.getMinecraft().func_147108_a(this.prev));
        this.func_230480_a_((Widget)this.cancel);
        this.config = new Button(this.field_230708_k_ - 80, this.field_230709_l_ - 25, 75, 20, (ITextComponent)new TranslationTextComponent("reauth.gui.auth.config"), b -> {
            ReAuth.config.setCredentials("", "", "");
            this.func_231175_as__();
        });
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)ReAuth.modInfo);
        if (this.message.isEmpty() && result.status == VersionChecker.Status.OUTDATED && (msg = (String)result.changes.get(result.target)) != null) {
            this.message = I18n.func_135052_a((String)"reauth.gui.auth.update", (Object[])new Object[]{msg});
        }
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrices);
        this.drawCenteredString2(matrices, this.field_230712_o_, I18n.func_135052_a((String)"reauth.gui.auth.text1", (Object[])new Object[0]), this.field_230708_k_ / 2, this.baseY, Color.WHITE.getRGB());
        this.drawCenteredString2(matrices, this.field_230712_o_, I18n.func_135052_a((String)"reauth.gui.auth.text2", (Object[])new Object[0]), this.field_230708_k_ / 2, this.baseY + 45, Color.WHITE.getRGB());
        if (!this.message.isEmpty()) {
            this.drawCenteredString2(matrices, this.field_230712_o_, this.message, this.field_230708_k_ / 2, this.baseY - 15, 0xFFFFFF);
        }
        if (!ReAuth.config.hasCrypto()) {
            this.field_230712_o_.func_238405_a_(matrices, I18n.func_135052_a((String)"reauth.gui.auth.noCrypto", (Object[])new Object[0]), (float)(this.field_230708_k_ / 2 - 155), (float)(this.baseY + 90), Color.WHITE.getRGB());
        }
        LoginType status = this.getLoginType();
        this.confirm.func_238482_a_((ITextComponent)new TranslationTextComponent(status.getTranslation()));
        this.confirm.field_230693_o_ = status.isActive();
        super.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
    }

    private void focus(TextFieldWidget widget) {
        IGuiEventListener old = this.func_241217_q_();
        if (old instanceof TextFieldWidget) {
            ((TextFieldWidget)old).func_146195_b(false);
        }
        if (widget != null) {
            widget.func_146195_b(true);
        }
        this.func_231035_a_((IGuiEventListener)widget);
    }

    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 257 || keyCode == 335) {
            IGuiEventListener focus = this.func_241217_q_();
            if (focus == this.username) {
                this.focus(this.pw);
                return true;
            }
            if (focus == this.pw) {
                this.doLogin();
                return true;
            }
        }
        return super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    private LoginType getLoginType() {
        String user = this.username.func_146179_b();
        if (user.isEmpty()) {
            return LoginType.None;
        }
        if (this.pw.func_146179_b().isEmpty()) {
            if (ReAuth.auth.isValidName(user)) {
                return LoginType.Offline;
            }
            return LoginType.None;
        }
        return LoginType.Online;
    }

    private void doLogin() {
        boolean success = false;
        try {
            LoginType type = this.getLoginType();
            switch (type) {
                case Online: {
                    ReAuth.auth.login(this.username.func_146179_b(), this.pw.getPassword(), this.save.func_212942_a());
                    break;
                }
                case Offline: {
                    ReAuth.auth.offline(this.username.func_146179_b());
                    break;
                }
                default: {
                    return;
                }
            }
            this.message = I18n.func_135052_a((String)"reauth.login.success", (Object[])new Object[0]);
            success = true;
        }
        catch (AuthenticationException e) {
            this.message = I18n.func_135052_a((String)"reauth.login.fail", (Object[])new Object[]{e.getMessage()});
            ReAuth.log.error("Login failed:", (Throwable)e);
        }
        catch (Exception e) {
            this.message = I18n.func_135052_a((String)"reauth.login.error", (Object[])new Object[]{e.getMessage()});
            ReAuth.log.error("Error:", (Throwable)e);
        }
        if (success) {
            this.func_231175_as__();
        }
    }

    public void func_231175_as__() {
        this.getMinecraft().func_147108_a(this.prev);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.pw.setPassword(new char[0]);
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    private void drawCenteredString2(MatrixStack matrix, FontRenderer font, String text, int x, int y, int color) {
        font.func_238405_a_(matrix, text, (float)(x - font.func_78256_a(text) / 2), (float)y, color);
    }

    private static enum LoginType {
        None(false, "none"),
        Online(true, "online"),
        Offline(true, "offline");

        private final boolean active;
        private final String translation;

        private LoginType(boolean active, String translation) {
            this.active = active;
            this.translation = translation;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getTranslation() {
            return "reauth.gui.auth.confirm." + this.translation;
        }
    }
}

