/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import technicianlp.reauth.AuthHelper;
import technicianlp.reauth.DisconnectHandler;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.ReflectionHelper;
import technicianlp.reauth.gui.AuthScreen;

@Mod.EventBusSubscriber(modid="reauth", value={Dist.CLIENT})
public final class EventHandler {
    private static final Field disconnectMessage = ReflectionHelper.findMcpField(DisconnectedScreen.class, "field_146304_f");
    private static final Field previousScreen;

    @SubscribeEvent
    public static void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        if (screen instanceof MultiplayerScreen) {
            event.addWidget((Widget)new Button(5, 5, 100, 20, (ITextComponent)new TranslationTextComponent("reauth.gui.button"), b -> EventHandler.openAuthenticationScreen(screen)));
        } else if (screen instanceof MainMenuScreen) {
            event.addWidget((Widget)new Button(-50, -50, 20, 20, (ITextComponent)new TranslationTextComponent("reauth.gui.button"), b -> EventHandler.openAuthenticationScreen(screen)));
        } else if (screen instanceof DisconnectedScreen) {
            EventHandler.handleDisconnectScreen(event, screen);
        } else if (screen instanceof ConnectingScreen) {
            DisconnectHandler.setConnectScreen((ConnectingScreen)screen);
        }
    }

    private static void handleDisconnectScreen(GuiScreenEvent.InitGuiEvent.Post event, Screen screen) {
        if ("connect.failed".equals(DisconnectHandler.getTranslationKey(screen.func_231171_q_())) && DisconnectHandler.getTranslationKey(ReflectionHelper.getField(disconnectMessage, screen)).startsWith("disconnect.loginFailed")) {
            Widget menu = (Widget)event.getWidgetList().get(0);
            String key = DisconnectHandler.canRetryLogin() ? "reauth.retry" : "reauth.retry.disabled";
            TranslationTextComponent retryText = new TranslationTextComponent(key, new Object[]{ReAuth.config.getProfile()});
            Button retryButton = new Button(menu.field_230690_l_, menu.field_230691_m_ + 25, 200, 20, (ITextComponent)retryText, b -> DisconnectHandler.retryLogin());
            if (!DisconnectHandler.canRetryLogin()) {
                retryButton.field_230693_o_ = false;
            }
            event.addWidget((Widget)retryButton);
            event.addWidget((Widget)new Button(menu.field_230690_l_, menu.field_230691_m_ + 50, 200, 20, (ITextComponent)new TranslationTextComponent("reauth.open"), b -> Minecraft.func_71410_x().func_147108_a((Screen)new AuthScreen((Screen)ReflectionHelper.getField(previousScreen, screen)))));
        }
    }

    private static void openAuthenticationScreen(Screen parent) {
        Minecraft.func_71410_x().func_147108_a((Screen)new AuthScreen(parent));
    }

    @SubscribeEvent
    public static void onDrawGui(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (e.getGui() instanceof MultiplayerScreen) {
            AuthHelper.SessionStatus state = ReAuth.auth.getSessionStatus(false);
            Minecraft.func_71410_x().field_71466_p.func_238405_a_(e.getMatrixStack(), I18n.func_135052_a((String)state.getTranslationKey(), (Object[])new Object[0]), 110.0f, 10.0f, -1);
        }
    }

    @SubscribeEvent
    public static void onOpenGui(GuiOpenEvent e) {
        if (e.getGui() instanceof MultiplayerScreen && Minecraft.func_71410_x().field_71462_r instanceof MultiplayerScreen && Screen.func_231173_s_()) {
            ReAuth.auth.getSessionStatus(true);
        }
    }

    static {
        Preconditions.checkNotNull((Object)disconnectMessage, (Object)"Reflection failed: field_146304_f");
        previousScreen = ReflectionHelper.findMcpField(DisconnectedScreen.class, "field_146307_h");
        Preconditions.checkNotNull((Object)previousScreen, (Object)"Reflection failed: field_146307_h");
    }
}

