/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.ISmartVertexConsumer;
import codechicken.lib.model.Quad;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.LC;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import codechicken.lib.render.pipeline.attribute.ColourAttribute;
import codechicken.lib.render.pipeline.attribute.LightCoordAttribute;
import codechicken.lib.render.pipeline.attribute.NormalAttribute;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;

public class BakedVertexSource
implements IVertexSource,
ISmartVertexConsumer {
    private static final ThreadLocal<BakedVertexSource> instances = ThreadLocal.withInitial(BakedVertexSource::new);
    private final Quad unpacker = new Quad(CachedFormat.lookup(DefaultVertexFormats.field_176600_a));
    private int vertexIndex = -1;
    private Vertex5[] vertices = new Vertex5[0];
    private Object[] attributes = new Object[0];
    private TextureAtlasSprite[] sprites = new TextureAtlasSprite[0];

    private BakedVertexSource() {
        this.ensureAttr(AttributeKey.AttributeKeyRegistry.numAttributes() - 1);
        this.ensureSpace(24);
    }

    public static BakedVertexSource instance() {
        return instances.get();
    }

    @Override
    public Vertex5[] getVertices() {
        return this.vertices;
    }

    @Override
    public <T> T getAttributes(AttributeKey<T> attr) {
        this.ensureAttr(attr.attributeKeyIndex);
        return SneakyUtils.unsafeCast(this.attributes[attr.attributeKeyIndex]);
    }

    @Override
    public boolean hasAttribute(AttributeKey<?> attr) {
        return attr == NormalAttribute.attributeKey || attr == ColourAttribute.attributeKey || attr == LightCoordAttribute.attributeKey;
    }

    @Override
    public void prepareVertex(CCRenderState ccrs) {
        ccrs.sprite = this.sprites[ccrs.vertexIndex];
    }

    public void reset() {
        this.reset(CachedFormat.lookup(DefaultVertexFormats.field_176600_a));
    }

    public void reset(CachedFormat format) {
        this.vertexIndex = -1;
        this.unpacker.reset(format);
    }

    public int availableVertices() {
        return this.vertexIndex + 1;
    }

    private void onFull() {
        if (this.vertexIndex == -1) {
            this.vertexIndex = 0;
        }
        this.ensureSpace(this.availableVertices() + 4);
        for (int i = 0; i < 4; ++i) {
            int v;
            ++this.vertexIndex;
            Quad.Vertex vertex = this.unpacker.vertices[i];
            Vertex5 vertex5 = this.vertices[v];
            vertex5.vec.set(vertex.vec);
            vertex5.uv.set(vertex.uv);
            Vector3 normal = this.getAttr(NormalAttribute.attributeKey)[v];
            normal.set(vertex.normal);
            this.getAttr(LightCoordAttribute.attributeKey)[v].compute(vertex5.vec, normal);
            this.getAttr(ColourAttribute.attributeKey)[v] = Colour.packRGBA(vertex.color);
            this.sprites[v] = this.unpacker.sprite;
        }
    }

    private void ensureAttr(int aIdx) {
        if (this.attributes.length <= aIdx) {
            this.attributes = Arrays.copyOf(this.attributes, aIdx + 1);
        }
    }

    private void ensureSpace(int numVertices) {
        if (this.vertices.length <= numVertices) {
            int prevLen = this.vertices.length;
            int fillStart = this.vertexIndex == -1 ? 0 : this.vertexIndex;
            this.vertices = Arrays.copyOf(this.vertices, numVertices);
            BakedVertexSource.fill(this.vertices, fillStart, numVertices, Vertex5::new);
            for (int aIdx = 0; aIdx < this.attributes.length; ++aIdx) {
                Object attr = this.attributes[aIdx];
                AttributeKey key = AttributeKey.AttributeKeyRegistry.getAttributeKey(aIdx);
                if (attr == null) {
                    attr = key.newArray(numVertices);
                } else {
                    Object newAttr = key.newArray(numVertices);
                    System.arraycopy(attr, 0, newAttr, 0, prevLen);
                }
                this.attributes[aIdx] = attr;
                if (key == NormalAttribute.attributeKey) {
                    BakedVertexSource.fill((Object[])attr, fillStart, numVertices, Vector3::new);
                    continue;
                }
                if (key != LightCoordAttribute.attributeKey) continue;
                BakedVertexSource.fill((Object[])attr, fillStart, numVertices, LC::new);
            }
            this.sprites = Arrays.copyOf(this.sprites, numVertices);
        }
    }

    private <T> T getAttr(AttributeKey<T> key) {
        return SneakyUtils.unsafeCast(this.attributes[key.attributeKeyIndex]);
    }

    @Override
    public void put(Quad quad) {
        this.unpacker.put(quad);
        this.onFull();
    }

    public void put(int element, float ... data) {
        this.unpacker.put(element, data);
        if (this.unpacker.full) {
            this.onFull();
        }
    }

    public VertexFormat getVertexFormat() {
        return DefaultVertexFormats.field_176600_a;
    }

    public void setQuadTint(int tint) {
        this.unpacker.setQuadTint(tint);
    }

    public void setQuadOrientation(Direction orientation) {
        this.unpacker.setQuadOrientation(orientation);
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.unpacker.setApplyDiffuseLighting(diffuse);
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.unpacker.setTexture(texture);
    }

    private static void fill(Object[] arr, int start, int end, Supplier<Object> supplier) {
        for (int i = start; i < end; ++i) {
            arr[i] = supplier.get();
        }
    }
}

