/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjanitor.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbjanitor.FTBJanitor;
import dev.ftb.mods.ftbjanitor.command.DumpCommands;
import dev.ftb.mods.ftbjanitor.command.JERCommands;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ftbjanitor")
public class FTBJanitorCommands {
    public static final ITag<Block> CLEAR_AREA_TAG = BlockTags.func_199894_a((String)"ftbjanitor:clear_area");
    public static boolean autofly = false;

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbjanitor").requires(source -> source.func_197028_i().func_71264_H() || source.func_197034_c(2));
        command.then(Commands.func_197057_a((String)"autofly").executes(context -> FTBJanitorCommands.autofly()));
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dev").executes(context -> FTBJanitorCommands.devEnv((CommandSource)context.getSource(), true))).then(Commands.func_197056_a((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> FTBJanitorCommands.devEnv((CommandSource)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"enabled")))));
        command.then(Commands.func_197057_a((String)"heal").executes(context -> FTBJanitorCommands.heal(((CommandSource)context.getSource()).func_197035_h())));
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear_area_from_tag").executes(context -> FTBJanitorCommands.clearArea((CommandSource)context.getSource(), 30, false, true))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)3, (int)200)).executes(context -> FTBJanitorCommands.clearArea((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), false, true))).then(Commands.func_197056_a((String)"keep_structures", (ArgumentType)BoolArgumentType.bool()).executes(context -> FTBJanitorCommands.clearArea((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), BoolArgumentType.getBool((CommandContext)context, (String)"keep_structures"), true)))));
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear_area_from_vanilla_blocks").executes(context -> FTBJanitorCommands.clearArea((CommandSource)context.getSource(), 30, false, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)3, (int)200)).executes(context -> FTBJanitorCommands.clearArea((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), false, false))).then(Commands.func_197056_a((String)"keep_structures", (ArgumentType)BoolArgumentType.bool()).executes(context -> FTBJanitorCommands.clearArea((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), BoolArgumentType.getBool((CommandContext)context, (String)"keep_structures"), false)))));
        LiteralArgumentBuilder dump = Commands.func_197057_a((String)"dump");
        JERCommands.register((LiteralArgumentBuilder<CommandSource>)command);
        DumpCommands.register((LiteralArgumentBuilder<CommandSource>)dump);
        if (event.getEnvironment() != Commands.EnvironmentType.DEDICATED) {
            FTBJanitor.proxy.registerCommands((LiteralArgumentBuilder<CommandSource>)command, (LiteralArgumentBuilder<CommandSource>)dump);
        }
        command.then((ArgumentBuilder)dump);
        event.getDispatcher().register(command);
    }

    private static int autofly() {
        autofly = !autofly;
        return 1;
    }

    private static int devEnv(CommandSource source, boolean envValue) {
        MinecraftServer s = source.func_197028_i();
        ((GameRules.BooleanValue)s.func_200252_aR().func_223585_a(GameRules.field_223607_j)).func_223570_a(envValue, s);
        ((GameRules.BooleanValue)s.func_200252_aR().func_223585_a(GameRules.field_223601_d)).func_223570_a(envValue, s);
        ((GameRules.BooleanValue)s.func_200252_aR().func_223585_a(GameRules.field_223617_t)).func_223570_a(envValue, s);
        if (envValue) {
            IServerWorldInfo info = (IServerWorldInfo)source.func_197023_e().func_72912_H();
            info.func_76068_b(6000L);
            info.func_230391_a_(2000000);
            info.func_76080_g(0);
            info.func_76090_f(0);
            info.func_76084_b(false);
            info.func_76069_a(false);
        }
        return 1;
    }

    private static int heal(ServerPlayerEntity player) {
        player.func_70606_j(player.func_110138_aP());
        player.func_71024_bL().func_75122_a(20, 20.0f);
        return 1;
    }

    private static int clearArea(CommandSource source, int radius, boolean keepStructures, boolean useTag) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Clearing area, expect lag..."), false);
        ServerWorld world = source.func_197023_e();
        BlockPos pos = new BlockPos(source.func_197036_d());
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        ArrayList structures = new ArrayList();
        for (Structure s : Registry.field_218361_B) {
            structures.add(s);
        }
        for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
            for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                int h = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z);
                for (int y = h - 2; y >= 0; --y) {
                    Block block;
                    mutablePos.func_181079_c(x, y, z);
                    if (keepStructures && FTBJanitorCommands.isPartOfStructure(structures, world, (BlockPos)mutablePos) || (block = world.func_180495_p((BlockPos)mutablePos).func_177230_c()) == Blocks.field_150357_h || block instanceof AirBlock || !(useTag ? CLEAR_AREA_TAG.func_230235_a_((Object)block) : block.getRegistryName() == null || block.getRegistryName().func_110624_b().equals("minecraft"))) continue;
                    world.func_180501_a((BlockPos)mutablePos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Done!"), false);
        return 1;
    }

    private static boolean isPartOfStructure(List<Structure<?>> structures, ServerWorld world, BlockPos pos) {
        if (structures.isEmpty()) {
            return false;
        }
        for (Structure<?> feature : structures) {
            if (!world.func_241112_a_().func_235010_a_(pos, true, feature).func_75069_d()) continue;
            return true;
        }
        return false;
    }
}

